/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.services;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.fcrepo.kernel.exception.RepositoryRuntimeException;
import org.fcrepo.kernel.exception.ResourceTypeException;
import org.fcrepo.kernel.impl.FedoraBinaryImpl;
import org.fcrepo.kernel.impl.services.AbstractService;
import org.fcrepo.kernel.models.FedoraBinary;
import org.fcrepo.kernel.services.BinaryService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class BinaryServiceImpl
extends AbstractService
implements BinaryService {
    private static final Logger LOGGER = LoggerFactory.getLogger(BinaryServiceImpl.class);

    public FedoraBinary findOrCreate(Session session, String path) {
        try {
            Node dsNode = this.findOrCreateNode(session, path, "nt:file");
            if (dsNode.isNew()) {
                this.initializeNewDatastreamProperties(dsNode);
            }
            return this.cast(dsNode.getNode("jcr:content"));
        }
        catch (RepositoryException e) {
            throw new RepositoryRuntimeException((Throwable)e);
        }
    }

    public FedoraBinary find(Session session, String path) {
        try {
            Node dsNode = this.findNode(session, path);
            return this.cast(dsNode.getNode("jcr:content"));
        }
        catch (RepositoryException e) {
            throw new RepositoryRuntimeException((Throwable)e);
        }
    }

    private void initializeNewDatastreamProperties(Node node) {
        try {
            Node contentNode;
            if (node.canAddMixin("fedora:Resource")) {
                node.addMixin("fedora:Resource");
            }
            if (node.canAddMixin("fedora:NonRdfSourceDescription")) {
                node.addMixin("fedora:NonRdfSourceDescription");
            }
            if ((contentNode = jcrTools.findOrCreateChild(node, "jcr:content", "nt:resource")).canAddMixin("fedora:Binary")) {
                contentNode.addMixin("fedora:Binary");
            }
        }
        catch (RepositoryException e) {
            LOGGER.warn("Could not decorate {} with datastream properties: {}", (Object)node, (Object)e);
        }
    }

    public FedoraBinary cast(Node node) {
        this.assertIsType(node);
        return new FedoraBinaryImpl(node);
    }

    private void assertIsType(Node node) {
        if (!FedoraBinaryImpl.hasMixin(node)) {
            throw new ResourceTypeException(node + " can not be used as a binary");
        }
    }
}

