/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.services;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import javax.jcr.NamespaceException;
import javax.jcr.NamespaceRegistry;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.fcrepo.kernel.exception.FedoraInvalidNamespaceException;
import org.fcrepo.kernel.exception.RepositoryRuntimeException;
import org.fcrepo.kernel.impl.FedoraResourceImpl;
import org.fcrepo.kernel.impl.rdf.impl.NodeTypeRdfContext;
import org.fcrepo.kernel.impl.services.AbstractService;
import org.fcrepo.kernel.models.FedoraResource;
import org.fcrepo.kernel.services.NodeService;
import org.fcrepo.kernel.utils.iterators.RdfStream;
import org.modeshape.jcr.api.nodetype.NodeTypeManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class NodeServiceImpl
extends AbstractService
implements NodeService {
    private static final Logger LOGGER = LoggerFactory.getLogger(NodeServiceImpl.class);

    @Override
    public boolean exists(Session session, String path) {
        try {
            this.validatePath(session, path);
            return session.nodeExists(path);
        }
        catch (RepositoryException e) {
            throw new RepositoryRuntimeException((Throwable)e);
        }
    }

    public FedoraResource find(Session session, String path) {
        try {
            return new FedoraResourceImpl(session.getNode(path));
        }
        catch (RepositoryException e) {
            throw new RepositoryRuntimeException((Throwable)e);
        }
    }

    public void copyObject(Session session, String source, String destination) {
        try {
            session.getWorkspace().copy(source, destination);
        }
        catch (RepositoryException e) {
            throw new RepositoryRuntimeException((Throwable)e);
        }
    }

    public void moveObject(Session session, String source, String destination) {
        try {
            session.getWorkspace().move(source, destination);
        }
        catch (RepositoryException e) {
            throw new RepositoryRuntimeException((Throwable)e);
        }
    }

    public RdfStream getNodeTypes(Session session) {
        try {
            return new NodeTypeRdfContext(session.getWorkspace().getNodeTypeManager());
        }
        catch (RepositoryException e) {
            throw new RepositoryRuntimeException((Throwable)e);
        }
    }

    public void registerNodeTypes(Session session, InputStream cndStream) throws IOException {
        try {
            NodeTypeManager nodeTypeManager = (NodeTypeManager)session.getWorkspace().getNodeTypeManager();
            nodeTypeManager.registerNodeTypes(cndStream, true);
        }
        catch (RepositoryException e) {
            throw new RepositoryRuntimeException((Throwable)e);
        }
    }

    private void validatePath(Session session, String path) {
        String[] pathSegments;
        NamespaceRegistry namespaceRegistry;
        try {
            namespaceRegistry = session.getWorkspace().getNamespaceRegistry();
            Preconditions.checkNotNull((Object)namespaceRegistry, (Object)"Couldn't find namespace registry in repository!");
        }
        catch (RepositoryException e) {
            throw new RepositoryRuntimeException((Throwable)e);
        }
        String relPath = path.replaceAll("^/+", "").replaceAll("/+$", "");
        for (String segment : pathSegments = relPath.split("/")) {
            if (segment.length() <= 0 || !segment.contains(":") || segment.substring(0, segment.indexOf(":")) == "fedora") continue;
            String prefix = segment.substring(0, segment.indexOf(":"));
            try {
                namespaceRegistry.getURI(prefix);
            }
            catch (NamespaceException e) {
                throw new FedoraInvalidNamespaceException(String.format("The namespace prefix (%s) has not been registered", prefix), (Throwable)e);
            }
            catch (RepositoryException e) {
                throw new RepositoryRuntimeException((Throwable)e);
            }
        }
    }

    public FedoraResource findOrCreate(Session session, String path) {
        throw new RepositoryRuntimeException("unimplemented");
    }

    public FedoraResource cast(Node node) {
        return new FedoraResourceImpl(node);
    }
}

