/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.services;

import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Workspace;
import javax.jcr.version.Version;
import javax.jcr.version.VersionException;
import javax.jcr.version.VersionHistory;
import javax.jcr.version.VersionIterator;
import javax.jcr.version.VersionManager;
import org.fcrepo.kernel.impl.FedoraBinaryImpl;
import org.fcrepo.kernel.impl.services.AbstractService;
import org.fcrepo.kernel.services.VersionService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class VersionServiceImpl
extends AbstractService
implements VersionService {
    private static final Logger LOGGER = LoggerFactory.getLogger(VersionService.class);

    public String createVersion(Session session, String absPath) throws RepositoryException {
        Node node = session.getNode(absPath);
        if (!VersionServiceImpl.isVersioningEnabled(node)) {
            VersionServiceImpl.enableVersioning(node);
        }
        return VersionServiceImpl.checkpoint(session, absPath);
    }

    public void revertToVersion(Session session, String absPath, String label) throws RepositoryException {
        Workspace workspace = session.getWorkspace();
        Version v = VersionServiceImpl.getVersionForLabel(workspace, absPath, label);
        if (v == null) {
            throw new PathNotFoundException("Unknown version \"" + label + "\"!");
        }
        VersionManager versionManager = workspace.getVersionManager();
        versionManager.checkin(absPath);
        versionManager.restore(v, true);
        versionManager.checkout(absPath);
    }

    public void removeVersion(Session session, String absPath, String label) throws RepositoryException {
        String[] versionLabels;
        Workspace workspace = session.getWorkspace();
        Version v = VersionServiceImpl.getVersionForLabel(workspace, absPath, label);
        if (v == null) {
            throw new PathNotFoundException("Unknown version \"" + label + "\"!");
        }
        if (workspace.getVersionManager().getBaseVersion(absPath).equals(v)) {
            throw new VersionException("Cannot remove current version");
        }
        VersionHistory history = v.getContainingHistory();
        for (String versionLabel : versionLabels = history.getVersionLabels(v)) {
            LOGGER.debug("Removing label: {}", (Object)versionLabel);
            history.removeVersionLabel(versionLabel);
        }
        history.removeVersion(v.getName());
    }

    private static Version getVersionForLabel(Workspace workspace, String absPath, String label) throws RepositoryException {
        VersionHistory history = workspace.getVersionManager().getVersionHistory(absPath);
        if (history.hasVersionLabel(label)) {
            return history.getVersionByLabel(label);
        }
        VersionIterator versionIt = history.getAllVersions();
        if (versionIt == null) {
            return null;
        }
        while (versionIt.hasNext()) {
            Version v = versionIt.nextVersion();
            if (!v.getFrozenNode().getIdentifier().equals(label)) continue;
            return v;
        }
        return null;
    }

    private static boolean isVersioningEnabled(Node n) throws RepositoryException {
        return n.isNodeType("mix:versionable") || FedoraBinaryImpl.hasMixin(n) && VersionServiceImpl.isVersioningEnabled(n.getParent());
    }

    private static void enableVersioning(Node node) throws RepositoryException {
        node.addMixin("mix:versionable");
        if (FedoraBinaryImpl.hasMixin(node)) {
            node.getParent().addMixin("mix:versionable");
        }
        node.getSession().save();
    }

    private static String checkpoint(Session session, String absPath) throws RepositoryException {
        LOGGER.trace("Setting implicit version checkpoint set for {}", (Object)absPath);
        Workspace workspace = session.getWorkspace();
        Version v = workspace.getVersionManager().checkpoint(absPath);
        return v == null ? null : v.getFrozenNode().getIdentifier();
    }
}

