/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.utils;

import java.net.URI;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import javax.jcr.RepositoryException;
import org.fcrepo.kernel.utils.CacheEntry;
import org.fcrepo.kernel.utils.FixityResult;

public class FixityResultImpl
implements FixityResult {
    private long computedSize;
    private URI computedChecksum;
    private final String storeIdentifier;

    public FixityResultImpl(long size, URI checksum) {
        this("comparison-only-identifier", size, checksum);
    }

    public FixityResultImpl(CacheEntry entry, long size, URI checksum) throws RepositoryException {
        this(entry.getExternalIdentifier(), size, checksum);
    }

    public FixityResultImpl(String storeIdentifier, long size, URI checksum) {
        this.storeIdentifier = storeIdentifier;
        this.computedSize = size;
        this.computedChecksum = checksum;
    }

    public String getStoreIdentifier() {
        return this.storeIdentifier;
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj instanceof FixityResult) {
            FixityResult that = (FixityResult)obj;
            result = this.computedSize == that.getComputedSize() && this.computedChecksum.equals(that.getComputedChecksum());
        }
        return result;
    }

    public int hashCode() {
        return Objects.hash(this.computedSize, this.computedChecksum);
    }

    public String toString() {
        return "Fixity: checksum: " + this.computedChecksum + " / " + Long.toString(this.computedSize);
    }

    public boolean matches(URI checksum) {
        return this.computedChecksum.equals(checksum);
    }

    public boolean matches(long size) {
        return this.computedSize == size;
    }

    public boolean matches(long size, URI checksum) {
        return this.matches(size) && this.matches(checksum);
    }

    public Set<FixityResult.FixityState> getStatus(long size, URI checksum) {
        EnumSet<FixityResult.FixityState> status = EnumSet.noneOf(FixityResult.FixityState.class);
        if (this.matches(size, checksum)) {
            status.add(FixityResult.FixityState.SUCCESS);
        } else {
            if (!this.matches(size)) {
                status.add(FixityResult.FixityState.BAD_SIZE);
            }
            if (!this.matches(checksum)) {
                status.add(FixityResult.FixityState.BAD_CHECKSUM);
            }
        }
        return status;
    }

    public long getComputedSize() {
        return this.computedSize;
    }

    public URI getComputedChecksum() {
        return this.computedChecksum;
    }
}

