/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.utils.impl;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.jcr.Property;
import org.fcrepo.kernel.impl.services.functions.GetClusterExecutor;
import org.fcrepo.kernel.impl.utils.impl.DistributedFixityCheck;
import org.fcrepo.kernel.impl.utils.impl.LocalBinaryStoreEntry;
import org.fcrepo.kernel.utils.FixityResult;
import org.infinispan.distexec.DistributedExecutorService;
import org.modeshape.jcr.value.BinaryKey;
import org.modeshape.jcr.value.binary.BinaryStore;
import org.modeshape.jcr.value.binary.infinispan.ChunkBinaryMetadata;
import org.modeshape.jcr.value.binary.infinispan.InfinispanBinaryStore;
import org.modeshape.jcr.value.binary.infinispan.InfinispanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfinispanCacheStoreEntry
extends LocalBinaryStoreEntry {
    private static final Logger LOGGER = LoggerFactory.getLogger(InfinispanCacheStoreEntry.class);
    private static final GetClusterExecutor EXECUTOR_FACTORY = new GetClusterExecutor();

    public InfinispanCacheStoreEntry(InfinispanBinaryStore store, Property property) {
        super((BinaryStore)store, property);
    }

    @Override
    public Collection<FixityResult> checkFixity(String algorithm) {
        BinaryKey key = this.binaryKey();
        ImmutableSet.Builder fixityResults = new ImmutableSet.Builder();
        if (this.store().hasBinary(key)) {
            String dataKey = InfinispanUtils.dataKeyFrom((InfinispanBinaryStore)this.store(), key);
            ChunkBinaryMetadata metadata = InfinispanUtils.getMetadata((InfinispanBinaryStore)this.store(), key);
            DistributedFixityCheck task = new DistributedFixityCheck(dataKey, algorithm, metadata.getChunkSize(), metadata.getLength());
            List futures = this.clusterExecutor().submitEverywhere((Callable)((Object)task), (Object[])new String[]{dataKey + "-0"});
            while (!futures.isEmpty()) {
                Iterator iterator = futures.iterator();
                while (iterator.hasNext()) {
                    Future future = (Future)iterator.next();
                    try {
                        Collection result = (Collection)future.get(100L, TimeUnit.MILLISECONDS);
                        iterator.remove();
                        fixityResults.addAll((Iterable)result);
                    }
                    catch (TimeoutException e) {
                        LOGGER.trace("Going to retry cluster transform after timeout", (Throwable)e);
                    }
                    catch (InterruptedException | ExecutionException e) {
                        throw Throwables.propagate((Throwable)e);
                    }
                }
            }
        }
        return fixityResults.build();
    }

    private DistributedExecutorService clusterExecutor() {
        return EXECUTOR_FACTORY.apply((InfinispanBinaryStore)this.store());
    }
}

