/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.modeshape.jcr.JcrObservationManager;
import org.modeshape.jcr.JcrRepository;
import org.modeshape.jcr.bus.ChangeBus;
import org.modeshape.jcr.cache.change.ChangeSetListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(SessionUtils.class);

    private SessionUtils() {
    }

    public static void unregisterObservationManager(Session session) {
        try {
            SessionUtils.getChangeBus(session).unregister((ChangeSetListener)SessionUtils.getObservationManager(session));
        }
        catch (RepositoryException e) {
            LOGGER.info("Unable to dispose observation manager: {}", (Throwable)e);
        }
    }

    private static JcrObservationManager getObservationManager(Session session) throws RepositoryException {
        return (JcrObservationManager)session.getWorkspace().getObservationManager();
    }

    private static ChangeBus getChangeBus(Session session) {
        return ((JcrRepository)session.getRepository()).changeBus();
    }
}

