/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.integration.kernel.impl;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Resource;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import org.apache.commons.io.IOUtils;
import org.fcrepo.integration.kernel.impl.AbstractIT;
import org.fcrepo.kernel.exception.MalformedRdfException;
import org.fcrepo.kernel.identifiers.IdentifierConverter;
import org.fcrepo.kernel.impl.rdf.impl.DefaultIdentifierTranslator;
import org.fcrepo.kernel.impl.rdf.impl.PropertiesRdfContext;
import org.fcrepo.kernel.impl.utils.FedoraTypesUtils;
import org.fcrepo.kernel.models.Container;
import org.fcrepo.kernel.services.ContainerService;
import org.fcrepo.kernel.utils.iterators.RdfStream;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.test.context.ContextConfiguration;

@ContextConfiguration(value={"/spring-test/repo.xml"})
public class FedoraObjectImplIT
extends AbstractIT {
    @Inject
    Repository repo;
    @Inject
    ContainerService containerService;
    private Session session;
    private DefaultIdentifierTranslator subjects;

    @Before
    public void setUp() throws RepositoryException {
        this.session = this.repo.login();
        this.subjects = new DefaultIdentifierTranslator(this.session);
    }

    @Test
    public void testCreatedObject() throws RepositoryException {
        this.containerService.findOrCreate(this.session, "/testObject");
        this.session.save();
        this.session.logout();
        this.session = this.repo.login();
        Container obj = (Container)this.containerService.findOrCreate(this.session, "/testObject");
        Assert.assertNotNull((String)"Couldn't find object!", (Object)obj);
    }

    @Test
    public void testObjectGraph() throws Exception {
        Container object = (Container)this.containerService.findOrCreate(this.session, "/graphObject");
        Model model = object.getTriples((IdentifierConverter)this.subjects, PropertiesRdfContext.class).asModel();
        Resource graphSubject = (Resource)this.subjects.reverse().convert((Object)object);
        Assert.assertFalse((String)"Graph store should not contain JCR prefixes", (boolean)Pattern.compile("jcr").matcher(model.toString()).find());
        Assert.assertFalse((String)"Graph store should contain our fcrepo prefix", (boolean)Pattern.compile("fcrepo").matcher(model.toString()).find());
        object.updateProperties((IdentifierConverter)this.subjects, "PREFIX dc: <http://purl.org/dc/elements/1.1/>\nINSERT { <http://example/egbook> dc:title \"This is an example of an update that will be ignored\" } WHERE {}", object.getTriples((IdentifierConverter)this.subjects, PropertiesRdfContext.class));
        object.updateProperties((IdentifierConverter)this.subjects, "PREFIX dc: <http://purl.org/dc/elements/1.1/>\nINSERT { <" + graphSubject + "> dc:title " + "\"This is an example title\" } WHERE {}", object.getTriples((IdentifierConverter)this.subjects, PropertiesRdfContext.class));
        Value[] values = object.getNode().getProperty("dc:title").getValues();
        Assert.assertTrue((values.length > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)values[0].getString(), (boolean)values[0].getString().equals("This is an example title"));
        object.updateProperties((IdentifierConverter)this.subjects, "PREFIX myurn: <info:myurn/>\nINSERT { <" + graphSubject + "> myurn:info " + "\"This is some example data\"} WHERE {}", object.getTriples((IdentifierConverter)this.subjects, PropertiesRdfContext.class));
        Value value = object.getNode().getProperty(object.getNode().getSession().getNamespacePrefix("info:myurn/") + ":info").getValues()[0];
        Assert.assertEquals((Object)"This is some example data", (Object)value.getString());
        object.updateProperties((IdentifierConverter)this.subjects, "PREFIX dcterms: <http://purl.org/dc/terms/>\nINSERT { <" + graphSubject + "> dcterms:" + "isPartOf <" + graphSubject + "> } WHERE {}", object.getTriples((IdentifierConverter)this.subjects, PropertiesRdfContext.class));
        Value refValue = object.getNode().getProperty("dcterms:isPartOf_ref").getValues()[0];
        Assert.assertTrue((String)refValue.getString(), (boolean)refValue.getString().equals(object.getNode().getIdentifier()));
        object.updateProperties((IdentifierConverter)this.subjects, "PREFIX dc: <http://purl.org/dc/elements/1.1/>\nDELETE { <" + graphSubject + "> dc:title " + "\"This is an example title\" } WHERE {}", object.getTriples((IdentifierConverter)this.subjects, PropertiesRdfContext.class));
        Assert.assertFalse((String)"Found unexpected dc:title", (boolean)object.getNode().hasProperty("dc:title"));
        object.updateProperties((IdentifierConverter)this.subjects, "PREFIX dcterms: <http://purl.org/dc/terms/>\nDELETE { <" + graphSubject + "> " + "dcterms:isPartOf <" + graphSubject + "> " + "} WHERE {}", object.getTriples((IdentifierConverter)this.subjects, PropertiesRdfContext.class));
        Assert.assertFalse((String)"found unexpected reference", (boolean)object.getNode().hasProperty("dcterms:isPartOf"));
        this.session.save();
    }

    @Test
    public void testObjectGraphWithUriProperty() throws RepositoryException {
        Container object = (Container)this.containerService.findOrCreate(this.session, "/graphObject");
        Resource graphSubject = (Resource)this.subjects.reverse().convert((Object)object);
        object.updateProperties((IdentifierConverter)this.subjects, "PREFIX some: <info:some#>\nINSERT { <" + graphSubject + "> some:urlProperty " + "<" + graphSubject + "> } WHERE {}", object.getTriples((IdentifierConverter)this.subjects, PropertiesRdfContext.class));
        String prefix = this.session.getWorkspace().getNamespaceRegistry().getPrefix("info:some#");
        String propertyName = prefix + ":urlProperty";
        String referencePropertyName = FedoraTypesUtils.getReferencePropertyName((String)propertyName);
        Assert.assertTrue((boolean)object.getNode().hasProperty(referencePropertyName));
        Assert.assertFalse((boolean)object.getNode().hasProperty(propertyName));
        Assert.assertEquals((Object)object.getNode(), (Object)this.session.getNodeByIdentifier(object.getNode().getProperty(prefix + ":urlProperty_ref").getValues()[0].getString()));
        object.updateProperties((IdentifierConverter)this.subjects, "PREFIX some: <info:some#>\nDELETE { <" + graphSubject + "> some:urlProperty " + "<" + graphSubject + "> } WHERE {}", object.getTriples((IdentifierConverter)this.subjects, PropertiesRdfContext.class));
        Assert.assertFalse((boolean)object.getNode().hasProperty(referencePropertyName));
        Assert.assertFalse((boolean)object.getNode().hasProperty(propertyName));
        object.updateProperties((IdentifierConverter)this.subjects, "PREFIX some: <info:some#>\nINSERT DATA { <" + graphSubject + "> some:urlProperty <" + graphSubject + ">;\n" + "       some:urlProperty <info:somewhere/else> . }", object.getTriples((IdentifierConverter)this.subjects, PropertiesRdfContext.class));
        Assert.assertTrue((boolean)object.getNode().hasProperty(referencePropertyName));
        Assert.assertTrue((boolean)object.getNode().hasProperty(propertyName));
        Assert.assertEquals((long)1L, (long)object.getNode().getProperty(prefix + ":urlProperty_ref").getValues().length);
        Assert.assertEquals((Object)object.getNode(), (Object)this.session.getNodeByIdentifier(object.getNode().getProperty(prefix + ":urlProperty_ref").getValues()[0].getString()));
    }

    @Test
    public void testUpdatingObjectGraphWithErrors() {
        String pid = this.getRandomPid();
        Container object = (Container)this.containerService.findOrCreate(this.session, pid);
        MalformedRdfException e = null;
        try {
            object.updateProperties((IdentifierConverter)this.subjects, "INSERT DATA { <> <info:some-property> <relative-url> . \n<> <info:some-other-property> <another-relative-url> }", new RdfStream());
        }
        catch (MalformedRdfException ex) {
            e = ex;
        }
        Assert.assertNotNull((String)"Expected an exception to get thrown", (Object)((Object)e));
        Assert.assertEquals((String)"Excepted two nested exceptions", (long)2L, (long)e.getMessage().split("\n").length);
        Assert.assertTrue((boolean)e.getMessage().contains("/relative-url"));
        Assert.assertTrue((boolean)e.getMessage().contains("/another-relative-url"));
    }

    @Test
    public void testReplaceObjectGraphWithErrors() {
        String pid = this.getRandomPid();
        Container object = (Container)this.containerService.findOrCreate(this.session, pid);
        Model model = ModelFactory.createDefaultModel().read(IOUtils.toInputStream((String)"<> <info:some-property> <relative-url> . \n<> <info:some-other-property> <another-relative-url>"), ((Resource)this.subjects.reverse().convert((Object)object)).toString(), "TTL");
        MalformedRdfException e = null;
        try {
            object.replaceProperties((IdentifierConverter)this.subjects, model, new RdfStream());
        }
        catch (MalformedRdfException ex) {
            e = ex;
        }
        Assert.assertNotNull((String)"Expected an exception to get thrown", (Object)((Object)e));
        Assert.assertEquals((String)"Excepted two nested exceptions", (long)2L, (long)e.getMessage().split("\n").length);
        Assert.assertTrue((boolean)e.getMessage().contains("/relative-url"));
        Assert.assertTrue((boolean)e.getMessage().contains("/another-relative-url"));
    }
}

