/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.integration.kernel.impl;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.NodeFactory;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.vocabulary.RDF;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import javax.inject.Inject;
import javax.jcr.Property;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.nodetype.NodeTypeDefinition;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.nodetype.NodeTypeTemplate;
import javax.jcr.version.Version;
import org.fcrepo.integration.kernel.impl.AbstractIT;
import org.fcrepo.kernel.RdfLexicon;
import org.fcrepo.kernel.exception.InvalidChecksumException;
import org.fcrepo.kernel.exception.MalformedRdfException;
import org.fcrepo.kernel.exception.RepositoryRuntimeException;
import org.fcrepo.kernel.identifiers.IdentifierConverter;
import org.fcrepo.kernel.impl.FedoraResourceImpl;
import org.fcrepo.kernel.impl.rdf.impl.DefaultIdentifierTranslator;
import org.fcrepo.kernel.impl.rdf.impl.PropertiesRdfContext;
import org.fcrepo.kernel.impl.rdf.impl.ReferencesRdfContext;
import org.fcrepo.kernel.impl.rdf.impl.RootRdfContext;
import org.fcrepo.kernel.impl.rdf.impl.TypeRdfContext;
import org.fcrepo.kernel.impl.rdf.impl.VersionsRdfContext;
import org.fcrepo.kernel.models.Container;
import org.fcrepo.kernel.models.FedoraBinary;
import org.fcrepo.kernel.models.FedoraResource;
import org.fcrepo.kernel.models.NonRdfSourceDescription;
import org.fcrepo.kernel.services.BinaryService;
import org.fcrepo.kernel.services.ContainerService;
import org.fcrepo.kernel.services.NodeService;
import org.fcrepo.kernel.services.VersionService;
import org.fcrepo.kernel.utils.iterators.PropertyIterator;
import org.fcrepo.kernel.utils.iterators.RdfStream;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.test.context.ContextConfiguration;

@ContextConfiguration(value={"/spring-test/repo.xml"})
public class FedoraResourceImplIT
extends AbstractIT {
    @Inject
    Repository repo;
    @Inject
    NodeService nodeService;
    @Inject
    ContainerService containerService;
    @Inject
    BinaryService binaryService;
    @Inject
    VersionService versionService;
    private Session session;
    private DefaultIdentifierTranslator subjects;

    @Before
    public void setUp() throws RepositoryException {
        this.session = this.repo.login();
        this.subjects = new DefaultIdentifierTranslator(this.session);
    }

    @After
    public void tearDown() {
        this.session.logout();
    }

    @Test
    public void testGetRootNode() throws RepositoryException {
        Session session = this.repo.login();
        FedoraResource object = (FedoraResource)this.nodeService.find(session, "/");
        Assert.assertEquals((Object)"/", (Object)object.getPath());
        session.logout();
    }

    private Node createGraphSubjectNode(FedoraResource obj) {
        return ((Resource)this.subjects.reverse().convert((Object)obj)).asNode();
    }

    @Test
    public void testRandomNodeGraph() {
        FedoraResource object = (FedoraResource)this.containerService.findOrCreate(this.session, "/testNodeGraph");
        Node s = ((Resource)this.subjects.reverse().convert((Object)object)).asNode();
        Node p = NodeFactory.createURI((String)"http://fedora.info/definitions/v4/repository#primaryType");
        Node o = NodeFactory.createLiteral((String)"nt:folder");
        Assert.assertTrue((boolean)object.getTriples((IdentifierConverter)this.subjects, PropertiesRdfContext.class).asModel().getGraph().contains(s, p, o));
    }

    @Test
    public void testLastModified() throws RepositoryException {
        String pid = UUID.randomUUID().toString();
        this.containerService.findOrCreate(this.session, "/" + pid);
        this.session.save();
        this.session.logout();
        this.session = this.repo.login();
        Container obj2 = (Container)this.containerService.findOrCreate(this.session, "/" + pid);
        Assert.assertFalse((boolean)obj2.getLastModifiedDate().before(obj2.getCreatedDate()));
    }

    @Test
    public void testRepositoryRootGraph() {
        FedoraResource object = (FedoraResource)this.nodeService.find(this.session, "/");
        Graph graph = object.getTriples((IdentifierConverter)this.subjects, RootRdfContext.class).asModel().getGraph();
        Node s = this.createGraphSubjectNode(object);
        Node p = NodeFactory.createURI((String)"http://fedora.info/definitions/v4/repository#repository.jcr.repository.vendor.url");
        Node o = NodeFactory.createLiteral((String)"http://www.modeshape.org");
        Assert.assertTrue((boolean)graph.contains(s, p, o));
        p = NodeFactory.createURI((String)"http://fedora.info/definitions/v4/repository#hasNodeType");
        o = NodeFactory.createLiteral((String)"fedora:Resource");
        Assert.assertTrue((boolean)graph.contains(s, p, o));
    }

    @Test
    public void testObjectGraph() throws RepositoryException {
        String pid = "/" + this.getRandomPid();
        FedoraResource object = (FedoraResource)this.containerService.findOrCreate(this.session, pid);
        Graph graph = object.getTriples((IdentifierConverter)this.subjects, PropertiesRdfContext.class).asModel().getGraph();
        Node s = this.createGraphSubjectNode(object);
        Node p = NodeFactory.createURI((String)"http://fedora.info/definitions/v4/repository#uuid");
        Node o = NodeFactory.createLiteral((String)object.getNode().getIdentifier());
        Assert.assertTrue((boolean)graph.contains(s, p, o));
        p = NodeFactory.createURI((String)"http://fedora.info/definitions/v4/repository#mixinTypes");
        o = NodeFactory.createLiteral((String)"fedora:Resource");
        Assert.assertTrue((boolean)graph.contains(s, p, o));
        o = NodeFactory.createLiteral((String)"fedora:Container");
        Assert.assertTrue((boolean)graph.contains(s, p, o));
    }

    @Test
    public void testObjectGraphWithCustomProperty() throws RepositoryException {
        FedoraResource object = (FedoraResource)this.containerService.findOrCreate(this.session, "/testObjectGraph");
        javax.jcr.Node node = object.getNode();
        node.setProperty("dc:title", "this-is-some-title");
        node.setProperty("dc:subject", "this-is-some-subject-stored-as-a-binary", 2);
        node.setProperty("jcr:data", "jcr-data-should-be-ignored", 2);
        this.session.save();
        this.session.logout();
        this.session = this.repo.login();
        object = (FedoraResource)this.containerService.findOrCreate(this.session, "/testObjectGraph");
        Graph graph = object.getTriples((IdentifierConverter)this.subjects, PropertiesRdfContext.class).asModel().getGraph();
        Node s = this.createGraphSubjectNode(object);
        Node p = RdfLexicon.DC_TITLE.asNode();
        Node o = NodeFactory.createLiteral((String)"this-is-some-title");
        Assert.assertTrue((boolean)graph.contains(s, p, o));
        p = NodeFactory.createURI((String)"http://purl.org/dc/elements/1.1/subject");
        o = NodeFactory.createLiteral((String)"this-is-some-subject-stored-as-a-binary");
        Assert.assertTrue((boolean)graph.contains(s, p, o));
        p = Node.ANY;
        o = NodeFactory.createLiteral((String)"jcr-data-should-be-ignored");
        Assert.assertFalse((boolean)graph.contains(s, p, o));
    }

    @Test
    public void testRdfTypeInheritance() throws RepositoryException {
        this.logger.info("in testRdfTypeInheritance...");
        NodeTypeManager mgr = this.session.getWorkspace().getNodeTypeManager();
        NodeTypeTemplate type = mgr.createNodeTypeTemplate();
        type.setName("test:aSupertype");
        type.setMixin(true);
        NodeTypeDefinition[] nodeTypes = new NodeTypeDefinition[]{type};
        mgr.registerNodeTypes(nodeTypes, true);
        NodeTypeTemplate type2 = mgr.createNodeTypeTemplate();
        type2.setName("test:testInher");
        type2.setMixin(true);
        type2.setDeclaredSuperTypeNames(new String[]{"test:aSupertype"});
        NodeTypeDefinition[] nodeTypes2 = new NodeTypeDefinition[]{type2};
        mgr.registerNodeTypes(nodeTypes2, true);
        FedoraResource object = (FedoraResource)this.containerService.findOrCreate(this.session, "/testNTTnheritanceObject");
        javax.jcr.Node node = object.getNode();
        node.addMixin("test:testInher");
        this.session.save();
        this.session.logout();
        this.session = this.repo.login();
        object = (FedoraResource)this.containerService.findOrCreate(this.session, "/testNTTnheritanceObject");
        Node s = this.createGraphSubjectNode(object);
        Node p = ResourceFactory.createProperty((String)"http://www.w3.org/1999/02/22-rdf-syntax-ns#type").asNode();
        Node o = ResourceFactory.createProperty((String)"info:fedora/test/aSupertype").asNode();
        Assert.assertTrue((String)"supertype test:aSupertype not found inherited in test:testInher!", (boolean)object.getTriples((IdentifierConverter)this.subjects, TypeRdfContext.class).asModel().getGraph().contains(s, p, o));
    }

    @Test
    public void testDatastreamGraph() throws RepositoryException, InvalidChecksumException {
        Container parentObject = (Container)this.containerService.findOrCreate(this.session, "/testDatastreamGraphParent");
        ((FedoraBinary)this.binaryService.findOrCreate(this.session, "/testDatastreamGraph")).setContent((InputStream)new ByteArrayInputStream("123456789test123456789".getBytes()), "text/plain", null, null, null);
        NonRdfSourceDescription object = ((FedoraBinary)this.binaryService.findOrCreate(this.session, "/testDatastreamGraph")).getDescription();
        object.getNode().setProperty("fedora:isPartOf", this.session.getNode("/testDatastreamGraphParent"));
        Graph graph = object.getTriples((IdentifierConverter)this.subjects, PropertiesRdfContext.class).asModel().getGraph();
        Node s = this.createGraphSubjectNode((FedoraResource)object);
        Node p = NodeFactory.createURI((String)"http://fedora.info/definitions/v4/repository#uuid");
        Node o = NodeFactory.createLiteral((String)object.getNode().getIdentifier());
        Assert.assertTrue((boolean)graph.contains(s, p, o));
        p = NodeFactory.createURI((String)"http://fedora.info/definitions/v4/repository#mixinTypes");
        o = NodeFactory.createLiteral((String)"fedora:Resource");
        Assert.assertTrue((boolean)graph.contains(s, p, o));
        o = NodeFactory.createLiteral((String)"fedora:NonRdfSourceDescription");
        Assert.assertTrue((boolean)graph.contains(s, p, o));
        p = NodeFactory.createURI((String)"http://fedora.info/definitions/v4/repository#numberOfChildren");
        o = NodeFactory.createLiteral((String)"0");
        p = NodeFactory.createURI((String)"http://fedora.info/definitions/v4/repository#isPartOf");
        o = this.createGraphSubjectNode((FedoraResource)parentObject);
        Assert.assertTrue((boolean)graph.contains(s, p, o));
    }

    @Test
    public void testUpdatingObjectGraph() throws MalformedRdfException {
        FedoraResource object = (FedoraResource)this.containerService.findOrCreate(this.session, "/testObjectGraphUpdates");
        object.updateProperties((IdentifierConverter)this.subjects, "INSERT { <" + this.createGraphSubjectNode(object).getURI() + "> " + "<info:fcrepo/zyx> \"a\" } WHERE {} ", new RdfStream());
        Resource s = ResourceFactory.createResource((String)this.createGraphSubjectNode(object).getURI());
        com.hp.hpl.jena.rdf.model.Property p = ResourceFactory.createProperty((String)"info:fcrepo/zyx");
        Literal o = ResourceFactory.createPlainLiteral((String)"a");
        Model model = object.getTriples((IdentifierConverter)this.subjects, PropertiesRdfContext.class).asModel();
        Assert.assertTrue((boolean)model.contains(s, p, (RDFNode)o));
        object.updateProperties((IdentifierConverter)this.subjects, "DELETE { <" + this.createGraphSubjectNode(object).getURI() + "> " + "<info:fcrepo/zyx> ?o }\n" + "INSERT { " + "<" + this.createGraphSubjectNode(object).getURI() + "> " + "<info:fcrepo/zyx> \"b\" } " + "WHERE { " + "<" + this.createGraphSubjectNode(object).getURI() + "> " + "<info:fcrepo/zyx> ?o } ", RdfStream.fromModel((Model)model));
        model = object.getTriples((IdentifierConverter)this.subjects, PropertiesRdfContext.class).asModel();
        Assert.assertFalse((String)"found value we should have removed", (boolean)model.contains(s, p, (RDFNode)o));
        o = ResourceFactory.createPlainLiteral((String)"b");
        Assert.assertTrue((String)"could not find new value", (boolean)model.contains(s, p, (RDFNode)o));
    }

    @Test
    public void testAddVersionLabel() throws RepositoryException {
        FedoraResource object = (FedoraResource)this.containerService.findOrCreate(this.session, "/testObjectVersionLabel");
        object.getNode().addMixin("mix:versionable");
        this.session.save();
        object.addVersionLabel("v0.0.1");
        this.session.save();
        Assert.assertTrue((boolean)Arrays.asList(object.getVersionHistory().getVersionLabels()).contains("v0.0.1"));
    }

    @Test
    public void testGetObjectVersionGraph() throws RepositoryException {
        FedoraResource object = (FedoraResource)this.containerService.findOrCreate(this.session, "/testObjectVersionGraph");
        object.getNode().addMixin("mix:versionable");
        this.session.save();
        this.versionService.createVersion(this.session, object.getPath());
        this.session.save();
        object.addVersionLabel("v0.0.1");
        this.session.save();
        Model graphStore = object.getTriples((IdentifierConverter)this.subjects, VersionsRdfContext.class).asModel();
        this.logger.debug(graphStore.toString());
        Resource s = ResourceFactory.createResource((String)this.createGraphSubjectNode(object).getURI());
        com.hp.hpl.jena.rdf.model.Property p = ResourceFactory.createProperty((String)"http://fedora.info/definitions/v4/repository#hasVersion");
        StmtIterator triples = graphStore.listStatements(s, p, (RDFNode)null);
        List list = triples.toList();
        Assert.assertEquals((long)1L, (long)list.size());
        s = ((Statement)list.get(0)).getObject().asResource();
        p = ResourceFactory.createProperty((String)"http://fedora.info/definitions/v4/repository#hasVersionLabel");
        Literal o = ResourceFactory.createPlainLiteral((String)"v0.0.1");
        Assert.assertTrue((boolean)graphStore.contains(s, p, (RDFNode)o));
    }

    @Test(expected=MalformedRdfException.class)
    public void testAddMissingReference() throws RepositoryException, MalformedRdfException {
        FedoraResource object = (FedoraResource)this.containerService.findOrCreate(this.session, "/testRefObject");
        object.updateProperties((IdentifierConverter)this.subjects, "PREFIX example: <http://example.org/>\nPREFIX xsd: <http://www.w3.org/2001/XMLSchema#>\nPREFIX fedora: <http://fedora.info/definitions/v4/repository#>\nINSERT { <> fedora:isPartOf <" + this.subjects.toDomain("/some-path") + ">}" + "WHERE { }", new RdfStream());
    }

    @Test
    public void testUpdatingRdfType() throws RepositoryException {
        FedoraResource object = (FedoraResource)this.containerService.findOrCreate(this.session, "/testObjectRdfType");
        object.updateProperties((IdentifierConverter)this.subjects, "INSERT { <" + this.createGraphSubjectNode(object).getURI() + "> <" + RDF.type + "> <http://some/uri> } WHERE { }", new RdfStream());
        Assert.assertTrue((boolean)object.getNode().isNodeType("{http://some/}uri"));
    }

    @Test
    public void testRemoveRdfType() throws RepositoryException {
        FedoraResource object = (FedoraResource)this.containerService.findOrCreate(this.session, "/testRemoveObjectRdfType");
        object.updateProperties((IdentifierConverter)this.subjects, "INSERT { <" + this.createGraphSubjectNode(object).getURI() + "> <" + RDF.type + "> <http://some/uri> } WHERE { }", object.getTriples((IdentifierConverter)this.subjects, TypeRdfContext.class));
        Assert.assertTrue((boolean)object.getNode().isNodeType("{http://some/}uri"));
        object.updateProperties((IdentifierConverter)this.subjects, "DELETE { <" + this.createGraphSubjectNode(object).getURI() + "> <" + RDF.type + "> <http://some/uri> } WHERE { }", object.getTriples((IdentifierConverter)this.subjects, TypeRdfContext.class));
        Assert.assertFalse((boolean)object.getNode().isNodeType("{http://some/}uri"));
    }

    @Test
    public void testEtagValue() throws RepositoryException {
        FedoraResource object = (FedoraResource)this.containerService.findOrCreate(this.session, "/testEtagObject");
        this.session.save();
        String actual = object.getEtagValue();
        Assert.assertNotNull((Object)actual);
        Assert.assertNotEquals((Object)"", (Object)actual);
    }

    @Test
    public void testGetReferences() throws RepositoryException {
        String pid = UUID.randomUUID().toString();
        this.containerService.findOrCreate(this.session, pid);
        Container subject = (Container)this.containerService.findOrCreate(this.session, pid + "/a");
        Container object = (Container)this.containerService.findOrCreate(this.session, pid + "/b");
        Value value = this.session.getValueFactory().createValue(object.getNode());
        subject.getNode().setProperty("fedora:isPartOf", new Value[]{value});
        this.session.save();
        Model model = object.getTriples((IdentifierConverter)this.subjects, ReferencesRdfContext.class).asModel();
        Assert.assertTrue((boolean)model.contains((Resource)this.subjects.reverse().convert((Object)subject), ResourceFactory.createProperty((String)"http://fedora.info/definitions/v4/repository#isPartOf"), (RDFNode)this.subjects.reverse().convert((Object)object)));
    }

    @Test
    public void testReplaceProperties() throws RepositoryException {
        String pid = UUID.randomUUID().toString();
        Container object = (Container)this.containerService.findOrCreate(this.session, pid);
        RdfStream triples = object.getTriples((IdentifierConverter)this.subjects, PropertiesRdfContext.class);
        Model model = triples.asModel();
        Resource resource = model.createResource();
        Resource subject = (Resource)this.subjects.reverse().convert((Object)object);
        com.hp.hpl.jena.rdf.model.Property predicate = model.createProperty("info:xyz");
        model.add(subject, predicate, (RDFNode)resource);
        model.add(resource, model.createProperty("http://purl.org/dc/elements/1.1/title"), "xyz");
        object.replaceProperties((IdentifierConverter)this.subjects, model, object.getTriples((IdentifierConverter)this.subjects, PropertiesRdfContext.class));
        PropertyIterator properties = new PropertyIterator(object.getNode().getProperties());
        UnmodifiableIterator relation = Iterators.filter((Iterator)properties, (Predicate)new Predicate<Property>(){

            public boolean apply(Property property) {
                try {
                    return property.getName().contains("xyz_ref");
                }
                catch (RepositoryException e) {
                    return false;
                }
            }
        });
        Assert.assertTrue((boolean)relation.hasNext());
        Property next = (Property)relation.next();
        Value[] values = next.getValues();
        Assert.assertEquals((long)1L, (long)values.length);
        javax.jcr.Node skolemizedNode = this.session.getNodeByIdentifier(values[0].getString());
        Assert.assertTrue((boolean)skolemizedNode.getPath().contains("/.well-known/genid/"));
        Assert.assertEquals((Object)"xyz", (Object)skolemizedNode.getProperty("dc:title").getValues()[0].getString());
    }

    @Test
    public void testDeleteObject() throws RepositoryException {
        String pid = this.getRandomPid();
        this.containerService.findOrCreate(this.session, "/" + pid);
        this.session.save();
        ((Container)this.containerService.findOrCreate(this.session, "/" + pid)).delete();
        this.session.save();
        Assert.assertTrue((boolean)this.session.getNode("/" + pid).isNodeType("fedora:Tombstone"));
    }

    @Test
    public void testDeleteObjectWithInboundReferences() throws RepositoryException {
        String pid = this.getRandomPid();
        FedoraResource resourceA = (FedoraResource)this.containerService.findOrCreate(this.session, "/" + pid + "/a");
        FedoraResource resourceB = (FedoraResource)this.containerService.findOrCreate(this.session, "/" + pid + "/b");
        Value value = this.session.getValueFactory().createValue(resourceB.getNode());
        resourceA.getNode().setProperty("fedora:hasMember", new Value[]{value});
        this.session.save();
        ((Container)this.containerService.findOrCreate(this.session, "/" + pid + "/a")).delete();
        this.session.save();
        ((Container)this.containerService.findOrCreate(this.session, "/" + pid + "/b")).delete();
        this.session.save();
        Assert.assertTrue((boolean)this.session.getNode("/" + pid + "/b").isNodeType("fedora:Tombstone"));
    }

    @Test
    public void testGetContainer() {
        String pid = this.getRandomPid();
        Container container = (Container)this.containerService.findOrCreate(this.session, "/" + pid);
        FedoraResource resource = (FedoraResource)this.containerService.findOrCreate(this.session, "/" + pid + "/a");
        Assert.assertEquals((Object)container, (Object)resource.getContainer());
    }

    @Test
    public void testGetChildren() {
        String pid = this.getRandomPid();
        Container container = (Container)this.containerService.findOrCreate(this.session, "/" + pid);
        FedoraResource resource = (FedoraResource)this.containerService.findOrCreate(this.session, "/" + pid + "/a");
        Assert.assertEquals((Object)resource, container.getChildren().next());
    }

    @Test
    public void testGetChildrenWithBinary() {
        String pid = this.getRandomPid();
        Container container = (Container)this.containerService.findOrCreate(this.session, "/" + pid);
        FedoraResource resource = (FedoraResource)this.binaryService.findOrCreate(this.session, "/" + pid + "/a");
        Assert.assertEquals((Object)resource, container.getChildren().next());
    }

    @Test
    public void testGetContainerForBinary() {
        String pid = this.getRandomPid();
        Container container = (Container)this.containerService.findOrCreate(this.session, "/" + pid);
        FedoraResource resource = (FedoraResource)this.binaryService.findOrCreate(this.session, "/" + pid + "/a");
        Assert.assertEquals((Object)container, (Object)resource.getContainer());
    }

    @Test
    public void testGetContainerWithHierarchy() {
        String pid = this.getRandomPid();
        Container container = (Container)this.containerService.findOrCreate(this.session, "/" + pid);
        FedoraResource resource = (FedoraResource)this.containerService.findOrCreate(this.session, "/" + pid + "/a/b/c/d");
        Assert.assertEquals((Object)container, (Object)resource.getContainer());
    }

    @Test
    public void testGetChildrenWithHierarchy() {
        String pid = this.getRandomPid();
        Container container = (Container)this.containerService.findOrCreate(this.session, "/" + pid);
        FedoraResource resource = (FedoraResource)this.containerService.findOrCreate(this.session, "/" + pid + "/a/b/c/d");
        Assert.assertEquals((Object)resource, container.getChildren().next());
    }

    @Test
    public void testGetChildrenTombstonesAreHidden() {
        String pid = this.getRandomPid();
        Container container = (Container)this.containerService.findOrCreate(this.session, "/" + pid);
        FedoraResource resource = (FedoraResource)this.containerService.findOrCreate(this.session, "/" + pid + "/a");
        resource.delete();
        Assert.assertFalse((boolean)container.getChildren().hasNext());
    }

    @Test
    public void testGetChildrenHidesHashUris() {
        String pid = this.getRandomPid();
        Container container = (Container)this.containerService.findOrCreate(this.session, "/" + pid);
        this.containerService.findOrCreate(this.session, "/" + pid + "/#/a");
        Assert.assertFalse((boolean)container.getChildren().hasNext());
    }

    @Test
    public void testGetUnfrozenResource() throws RepositoryException {
        String pid = this.getRandomPid();
        Container object = (Container)this.containerService.findOrCreate(this.session, "/" + pid);
        object.enableVersioning();
        this.session.save();
        object.addVersionLabel("some-label");
        Version version = object.getVersionHistory().getVersionByLabel("some-label");
        this.session.save();
        FedoraResourceImpl frozenResource = new FedoraResourceImpl(version.getFrozenNode());
        Assert.assertEquals((Object)object, (Object)frozenResource.getUnfrozenResource());
    }

    @Test
    public void testGetVersionedAncestor() throws RepositoryException {
        String pid = this.getRandomPid();
        Container object = (Container)this.containerService.findOrCreate(this.session, "/" + pid);
        object.enableVersioning();
        this.session.save();
        this.containerService.findOrCreate(this.session, "/" + pid + "/a/b/c");
        this.session.save();
        this.session.getWorkspace().getVersionManager().checkpoint(object.getPath());
        object.addVersionLabel("some-label");
        this.session.save();
        Version version = object.getVersionHistory().getVersionByLabel("some-label");
        FedoraResourceImpl frozenResource = new FedoraResourceImpl(version.getFrozenNode().getNode("a"));
        Assert.assertEquals((Object)object, (Object)frozenResource.getVersionedAncestor().getUnfrozenResource());
    }

    @Test(expected=RepositoryRuntimeException.class)
    public void testNullBaseVersionLabel() throws RepositoryException {
        String pid = this.getRandomPid();
        Container object = (Container)this.containerService.findOrCreate(this.session, "/" + pid);
        this.session.save();
        FedoraResourceImpl resource = new FedoraResourceImpl(object.getNode());
        resource.addVersionLabel("noop");
    }

    @Test(expected=RepositoryRuntimeException.class)
    public void testNullBaseVersion() throws RepositoryException {
        String pid = this.getRandomPid();
        Container object = (Container)this.containerService.findOrCreate(this.session, "/" + pid);
        this.session.save();
        object.getBaseVersion();
    }

    @Test(expected=RepositoryRuntimeException.class)
    public void testNullVersionHistory() throws RepositoryException {
        String pid = this.getRandomPid();
        Container object = (Container)this.containerService.findOrCreate(this.session, "/" + pid);
        this.session.save();
        object.getVersionHistory();
    }

    @Test
    public void testGetNodeVersion() throws RepositoryException {
        String pid = this.getRandomPid();
        Container object = (Container)this.containerService.findOrCreate(this.session, "/" + pid);
        object.enableVersioning();
        this.session.save();
        this.containerService.findOrCreate(this.session, "/" + pid + "/a/b/c");
        this.session.save();
        this.session.getWorkspace().getVersionManager().checkpoint(object.getPath());
        object.addVersionLabel("some-label");
        this.session.save();
        Version version = object.getVersionHistory().getVersionByLabel("some-label");
        FedoraResourceImpl frozenResource = new FedoraResourceImpl(version.getFrozenNode());
        Assert.assertNull((Object)frozenResource.getNodeVersion("some-label"));
    }

    @Test
    public void testGetNullNodeVersion() throws RepositoryException {
        String pid = this.getRandomPid();
        Container object = (Container)this.containerService.findOrCreate(this.session, "/" + pid);
        object.enableVersioning();
        this.session.save();
        this.containerService.findOrCreate(this.session, "/" + pid + "/a/b/c");
        this.session.save();
        this.session.getWorkspace().getVersionManager().checkpoint(object.getPath());
        object.addVersionLabel("some-label");
        this.session.save();
        Version version = object.getVersionHistory().getVersionByLabel("some-label");
        FedoraResourceImpl frozenResource = new FedoraResourceImpl(version.getFrozenNode().getNode("a"));
        Assert.assertNull((Object)frozenResource.getNodeVersion("some-label"));
    }

    @Test
    public void testNullLastModifiedDate() throws RepositoryException {
        String pid = this.getRandomPid();
        Container object = (Container)this.containerService.findOrCreate(this.session, "/" + pid);
        Assert.assertFalse((boolean)object.hasProperty("jcr:lastModified"));
        Assert.assertNull((Object)object.getLastModifiedDate());
    }

    @Test
    public void testDisableVersioning() throws RepositoryException {
        String pid = this.getRandomPid();
        Container object = (Container)this.containerService.findOrCreate(this.session, "/" + pid);
        object.enableVersioning();
        this.session.save();
        Assert.assertTrue((boolean)object.isVersioned());
        object.disableVersioning();
        Assert.assertFalse((boolean)object.isVersioned());
    }

    @Test(expected=RepositoryRuntimeException.class)
    public void testDisableVersioningException() throws RepositoryException {
        String pid = this.getRandomPid();
        Container object = (Container)this.containerService.findOrCreate(this.session, "/" + pid);
        object.disableVersioning();
    }

    @Test
    public void testHash() throws RepositoryException {
        String pid = this.getRandomPid();
        Container object = (Container)this.containerService.findOrCreate(this.session, "/" + pid);
        object.enableVersioning();
        this.session.save();
        FedoraResourceImpl frozenResource = new FedoraResourceImpl(object.getNode());
        Assert.assertFalse((frozenResource.hashCode() == 0 ? 1 : 0) != 0);
    }
}

