/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.integration.kernel.impl;

import javax.inject.Inject;
import javax.jcr.Node;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.fcrepo.integration.kernel.impl.AbstractIT;
import org.fcrepo.kernel.exception.RepositoryRuntimeException;
import org.fcrepo.kernel.impl.TombstoneImpl;
import org.fcrepo.kernel.impl.rdf.impl.DefaultIdentifierTranslator;
import org.fcrepo.kernel.models.Container;
import org.fcrepo.kernel.services.ContainerService;
import org.fcrepo.kernel.services.NodeService;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.test.context.ContextConfiguration;

@ContextConfiguration(value={"/spring-test/repo.xml"})
public class TombstoneImplIT
extends AbstractIT {
    @Inject
    Repository repo;
    @Inject
    NodeService nodeService;
    @Inject
    ContainerService containerService;
    private Session session;
    private DefaultIdentifierTranslator subjects;

    @Before
    public void setUp() throws RepositoryException {
        this.session = this.repo.login();
        this.subjects = new DefaultIdentifierTranslator(this.session);
    }

    @After
    public void tearDown() {
        this.session.logout();
    }

    @Test(expected=RepositoryRuntimeException.class)
    public void testTombstoneNodeTypeException() throws RepositoryException {
        String pid = this.getRandomPid();
        Container container = (Container)this.containerService.findOrCreate(this.session, "/" + pid + "/a");
        new TombstoneImpl(container.getNode());
        this.session.logout();
        TombstoneImpl.hasMixin((Node)container.getNode());
    }

    @Test
    public void testDeleteObject() throws RepositoryException {
        String pid = this.getRandomPid();
        Container container = (Container)this.containerService.findOrCreate(this.session, "/" + pid + "/a");
        TombstoneImpl tombstone = new TombstoneImpl(container.getNode());
        tombstone.delete();
        try {
            this.nodeService.find(this.session, container.getPath());
            Assert.fail();
        }
        catch (RepositoryRuntimeException e) {
            // empty catch block
        }
    }

    @Test(expected=RepositoryRuntimeException.class)
    public void testDeleteObjectWithException() throws RepositoryException {
        String pid = this.getRandomPid();
        this.containerService.findOrCreate(this.session, "/" + pid + "/a");
        this.session.save();
        Container container = (Container)this.containerService.findOrCreate(this.session, "/" + pid + "/a");
        TombstoneImpl tombstone = new TombstoneImpl(container.getNode());
        this.session.logout();
        tombstone.delete();
    }
}

