/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl;

import java.io.InputStream;
import java.util.Calendar;
import java.util.Date;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.nodetype.NodeType;
import org.fcrepo.kernel.FedoraJcrTypes;
import org.fcrepo.kernel.impl.NonRdfSourceDescriptionImpl;
import org.fcrepo.kernel.models.NonRdfSourceDescription;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.modeshape.jcr.api.ValueFactory;

public class DatastreamImplTest
implements FedoraJcrTypes {
    private static final String testDsId = "testDs";
    private NonRdfSourceDescription testObj;
    private String testObjPath;
    @Mock
    private Session mockSession;
    @Mock
    private Node mockRootNode;
    @Mock
    private Node mockDsNode;
    @Mock
    private InputStream mockStream;
    @Mock
    private ValueFactory mockVF;
    @Mock
    private NodeType mockDsNodeType;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        NodeType[] nodeTypes = new NodeType[]{this.mockDsNodeType};
        try {
            Mockito.when((Object)this.mockDsNodeType.getName()).thenReturn((Object)"fedora:NonRdfSourceDescription");
            Mockito.when((Object)this.mockDsNode.getMixinNodeTypes()).thenReturn((Object)nodeTypes);
            Mockito.when((Object)this.mockDsNode.getName()).thenReturn((Object)testDsId);
            Mockito.when((Object)this.mockDsNode.getSession()).thenReturn((Object)this.mockSession);
            NodeType mockNodeType = (NodeType)Mockito.mock(NodeType.class);
            Mockito.when((Object)mockNodeType.getName()).thenReturn((Object)"nt:file");
            Mockito.when((Object)this.mockDsNode.getPrimaryNodeType()).thenReturn((Object)mockNodeType);
            this.testObj = new NonRdfSourceDescriptionImpl(this.mockDsNode);
        }
        catch (RepositoryException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @After
    public void tearDown() {
        this.mockSession = null;
        this.mockRootNode = null;
        this.mockDsNode = null;
    }

    @Test
    public void testGetNode() {
        Assert.assertEquals((Object)this.testObj.getNode(), (Object)this.mockDsNode);
    }

    @Test
    public void testGetCreatedDate() throws RepositoryException {
        Date expected = new Date();
        Calendar cal = Calendar.getInstance();
        cal.setTime(expected);
        Property mockProp = (Property)Mockito.mock(Property.class);
        Mockito.when((Object)mockProp.getDate()).thenReturn((Object)cal);
        Mockito.when((Object)this.mockDsNode.hasProperty("jcr:created")).thenReturn((Object)true);
        Mockito.when((Object)this.mockDsNode.getProperty("jcr:created")).thenReturn((Object)mockProp);
        Date actual = this.testObj.getCreatedDate();
        Assert.assertEquals((long)expected.getTime(), (long)actual.getTime());
    }

    @Test
    public void testGetLastModifiedDate() throws RepositoryException {
        Date expected = new Date();
        Calendar cal = Calendar.getInstance();
        cal.setTime(expected);
        Property mockProp = (Property)Mockito.mock(Property.class);
        Mockito.when((Object)mockProp.getDate()).thenReturn((Object)cal);
        Mockito.when((Object)this.mockDsNode.hasProperty("jcr:lastModified")).thenReturn((Object)true);
        Mockito.when((Object)this.mockDsNode.getProperty("jcr:lastModified")).thenReturn((Object)mockProp);
        Date actual = this.testObj.getLastModifiedDate();
        Assert.assertEquals((long)expected.getTime(), (long)actual.getTime());
    }

    @Test
    public void testHasDatastreamMixin() throws RepositoryException {
        Node test = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)test.isNodeType("fedora:NonRdfSourceDescription")).thenReturn((Object)true);
        Assert.assertTrue((String)"mockYes should have mixin", (boolean)NonRdfSourceDescriptionImpl.hasMixin((Node)test));
    }

    @Test
    public void testHasNoMixin() throws RepositoryException {
        Node test = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)test.isNodeType("fedora:NonRdfSourceDescription")).thenReturn((Object)false);
        Assert.assertFalse((String)"mockNo should not have mixin", (boolean)NonRdfSourceDescriptionImpl.hasMixin((Node)test));
    }
}

