/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.identifiers;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.fcrepo.kernel.impl.identifiers.NodeResourceConverter;
import org.fcrepo.kernel.models.Container;
import org.fcrepo.kernel.models.FedoraBinary;
import org.fcrepo.kernel.models.FedoraResource;
import org.fcrepo.kernel.models.NonRdfSourceDescription;
import org.fcrepo.kernel.models.Tombstone;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class NodeResourceConverterTest {
    private NodeResourceConverter testObj;
    @Mock
    private FedoraResource mockResource;
    @Mock
    private Node mockNode;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.testObj = NodeResourceConverter.nodeConverter;
        Mockito.when((Object)this.mockResource.getNode()).thenReturn((Object)this.mockNode);
    }

    @Test
    public void testForwardObject() {
        FedoraResource actual = (FedoraResource)this.testObj.convert((Object)this.mockNode);
        Assert.assertTrue((boolean)(actual instanceof Container));
        Assert.assertEquals((Object)this.mockNode, (Object)actual.getNode());
    }

    @Test
    public void testForwardDatastream() throws RepositoryException {
        Mockito.when((Object)this.mockNode.isNodeType("fedora:NonRdfSourceDescription")).thenReturn((Object)true);
        FedoraResource actual = (FedoraResource)this.testObj.convert((Object)this.mockNode);
        Assert.assertTrue((boolean)(actual instanceof NonRdfSourceDescription));
        Assert.assertEquals((Object)this.mockNode, (Object)actual.getNode());
    }

    @Test
    public void testForwardBinary() throws RepositoryException {
        Mockito.when((Object)this.mockNode.isNodeType("fedora:Binary")).thenReturn((Object)true);
        FedoraResource actual = (FedoraResource)this.testObj.convert((Object)this.mockNode);
        Assert.assertTrue((boolean)(actual instanceof FedoraBinary));
        Assert.assertEquals((Object)this.mockNode, (Object)actual.getNode());
    }

    @Test
    public void testForwardTombstone() throws RepositoryException {
        Mockito.when((Object)this.mockNode.isNodeType("fedora:Tombstone")).thenReturn((Object)true);
        FedoraResource actual = (FedoraResource)this.testObj.convert((Object)this.mockNode);
        Assert.assertTrue((boolean)(actual instanceof Tombstone));
        Assert.assertEquals((Object)this.mockNode, (Object)actual.getNode());
    }

    @Test
    public void testBackward() {
        Node actual = (Node)this.testObj.reverse().convert((Object)this.mockResource);
        Assert.assertEquals((Object)this.mockNode, (Object)actual);
    }
}

