/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.observer;

import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.Session;
import javax.jcr.nodetype.NodeType;
import org.fcrepo.kernel.impl.observer.DefaultFilter;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.modeshape.jcr.api.Repository;
import org.modeshape.jcr.api.observation.Event;

public class DefaultFilterTest {
    private DefaultFilter testObj;
    @Mock
    private Session mockSession;
    @Mock
    private Repository mockRepo;
    @Mock
    private Event mockEvent;
    @Mock
    private Node mockNode;
    @Mock
    private Property mockProperty;
    @Mock
    private NodeType fedoraResource;
    @Mock
    private NodeType fedoraContainer;
    @Mock
    private NodeType fedoraDatastream;
    @Mock
    private NodeType fedoraBinary;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.testObj = new DefaultFilter();
        Mockito.when((Object)this.fedoraResource.getName()).thenReturn((Object)"fedora:Resource");
        Mockito.when((Object)this.fedoraContainer.getName()).thenReturn((Object)"fedora:Container");
        Mockito.when((Object)this.fedoraDatastream.getName()).thenReturn((Object)"fedora:NonRdfSourceDescription");
        Mockito.when((Object)this.fedoraBinary.getName()).thenReturn((Object)"fedora:Binary");
    }

    @Test
    public void shouldApplyToResource() throws Exception {
        Mockito.when((Object)this.mockEvent.getMixinNodeTypes()).thenReturn((Object)new NodeType[]{this.fedoraResource});
        Assert.assertTrue((boolean)this.testObj.getFilter(this.mockSession).apply((Object)this.mockEvent));
    }

    @Test
    public void shouldApplyToObject() throws Exception {
        Mockito.when((Object)this.mockEvent.getMixinNodeTypes()).thenReturn((Object)new NodeType[]{this.fedoraContainer});
        Assert.assertTrue((boolean)this.testObj.getFilter(this.mockSession).apply((Object)this.mockEvent));
    }

    @Test
    public void shouldApplyToDatastream() throws Exception {
        Mockito.when((Object)this.mockEvent.getMixinNodeTypes()).thenReturn((Object)new NodeType[]{this.fedoraDatastream});
        Assert.assertTrue((boolean)this.testObj.getFilter(this.mockSession).apply((Object)this.mockEvent));
    }

    @Test
    public void shouldApplyToBinary() throws Exception {
        Mockito.when((Object)this.mockEvent.getMixinNodeTypes()).thenReturn((Object)new NodeType[]{this.fedoraBinary});
        Assert.assertTrue((boolean)this.testObj.getFilter(this.mockSession).apply((Object)this.mockEvent));
    }

    @Test
    public void shouldNotApplyToNonFedoraNodes() throws Exception {
        Mockito.when((Object)this.mockEvent.getMixinNodeTypes()).thenReturn((Object)new NodeType[0]);
        Assert.assertFalse((boolean)this.testObj.getFilter(this.mockSession).apply((Object)this.mockEvent));
    }
}

