/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.rdf.impl.mappings;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.fcrepo.kernel.impl.rdf.impl.mappings.PropertyValueIterator;
import org.fcrepo.kernel.impl.testutilities.TestPropertyIterator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class PropertyValueIteratorTest {
    private PropertyValueIterator testObj;
    @Mock
    private Property mockProperty;
    @Mock
    private Property mockMultivaluedProperty;
    @Mock
    private Value value1;
    @Mock
    private Value value2;
    @Mock
    private Value value3;
    private PropertyIterator propertyIterator;

    @Before
    public void setUp() throws RepositoryException {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.mockProperty.getValue()).thenReturn((Object)this.value1);
        Mockito.when((Object)this.mockMultivaluedProperty.isMultiple()).thenReturn((Object)true);
        Mockito.when((Object)this.mockMultivaluedProperty.getValues()).thenReturn((Object)new Value[]{this.value2, this.value3});
        this.propertyIterator = new TestPropertyIterator(this.mockProperty, this.mockMultivaluedProperty);
    }

    @Test
    public void testSingleValueSingleProperty() {
        this.testObj = new PropertyValueIterator(this.mockProperty);
        ArrayList values = Lists.newArrayList((Iterator)this.testObj);
        Assert.assertTrue((boolean)values.contains(this.value1));
    }

    @Test
    public void testMultiValueSingleProperty() {
        this.testObj = new PropertyValueIterator(this.mockMultivaluedProperty);
        ArrayList values = Lists.newArrayList((Iterator)this.testObj);
        Assert.assertTrue((boolean)values.containsAll((Collection<?>)ImmutableList.of((Object)this.value2, (Object)this.value3)));
    }

    @Test
    public void testSingleValuePropertyIterator() {
        this.testObj = new PropertyValueIterator((Iterator)this.propertyIterator);
        ArrayList values = Lists.newArrayList((Iterator)this.testObj);
        Assert.assertTrue((boolean)values.containsAll((Collection<?>)ImmutableList.of((Object)this.value1, (Object)this.value2, (Object)this.value3)));
    }
}

