/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl;

import com.google.common.base.Converter;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.UnmodifiableIterator;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelChangedListener;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.update.UpdateAction;
import com.hp.hpl.jena.update.UpdateFactory;
import com.hp.hpl.jena.update.UpdateRequest;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.version.LabelExistsVersionException;
import javax.jcr.version.Version;
import javax.jcr.version.VersionHistory;
import org.apache.commons.codec.digest.DigestUtils;
import org.fcrepo.kernel.FedoraJcrTypes;
import org.fcrepo.kernel.exception.MalformedRdfException;
import org.fcrepo.kernel.exception.PathNotFoundRuntimeException;
import org.fcrepo.kernel.exception.RepositoryRuntimeException;
import org.fcrepo.kernel.identifiers.IdentifierConverter;
import org.fcrepo.kernel.impl.TombstoneImpl;
import org.fcrepo.kernel.impl.identifiers.NodeResourceConverter;
import org.fcrepo.kernel.impl.utils.FedoraTypesUtils;
import org.fcrepo.kernel.impl.utils.JcrPropertyStatementListener;
import org.fcrepo.kernel.impl.utils.iterators.RdfAdder;
import org.fcrepo.kernel.impl.utils.iterators.RdfRemover;
import org.fcrepo.kernel.models.FedoraBinary;
import org.fcrepo.kernel.models.FedoraResource;
import org.fcrepo.kernel.models.NonRdfSourceDescription;
import org.fcrepo.kernel.services.functions.JcrPropertyFunctions;
import org.fcrepo.kernel.utils.iterators.GraphDifferencingIterator;
import org.fcrepo.kernel.utils.iterators.NodeIterator;
import org.fcrepo.kernel.utils.iterators.PropertyIterator;
import org.fcrepo.kernel.utils.iterators.RdfStream;
import org.modeshape.jcr.api.JcrTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FedoraResourceImpl
extends JcrTools
implements FedoraJcrTypes,
FedoraResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(FedoraResourceImpl.class);
    protected Node node;
    private static Predicate<Node> nastyChildren = new Predicate<Node>(){

        public boolean apply(Node n) {
            LOGGER.trace("Testing child node {}", (Object)n);
            try {
                return FedoraTypesUtils.isInternalNode.apply((Object)n) || n.getName().equals("jcr:content") || TombstoneImpl.hasMixin(n) || n.getName().equals("#");
            }
            catch (RepositoryException e) {
                throw new RepositoryRuntimeException((Throwable)e);
            }
        }
    };
    private static final Converter<FedoraResource, FedoraResource> datastreamToBinary = new Converter<FedoraResource, FedoraResource>(){

        protected FedoraResource doForward(FedoraResource fedoraResource) {
            if (fedoraResource instanceof NonRdfSourceDescription) {
                return ((NonRdfSourceDescription)fedoraResource).getDescribedResource();
            }
            return fedoraResource;
        }

        protected FedoraResource doBackward(FedoraResource fedoraResource) {
            if (fedoraResource instanceof FedoraBinary) {
                return ((FedoraBinary)fedoraResource).getDescription();
            }
            return fedoraResource;
        }
    };
    private static final Converter<Node, FedoraResource> nodeToObjectBinaryConverter = NodeResourceConverter.nodeConverter.andThen(datastreamToBinary);

    public FedoraResourceImpl(Node node) {
        this.node = node;
    }

    public Node getNode() {
        return this.node;
    }

    public String getPath() {
        try {
            return this.node.getPath();
        }
        catch (RepositoryException e) {
            throw new RepositoryRuntimeException((Throwable)e);
        }
    }

    public Iterator<FedoraResource> getChildren() {
        try {
            return Iterators.concat(this.nodeToGoodChildren(this.node));
        }
        catch (RepositoryException e) {
            throw new RepositoryRuntimeException((Throwable)e);
        }
    }

    private Iterator<Iterator<FedoraResource>> nodeToGoodChildren(Node input) throws RepositoryException {
        UnmodifiableIterator children = Iterators.filter((Iterator)new NodeIterator(input.getNodes()), (Predicate)Predicates.not(nastyChildren));
        return Iterators.transform((Iterator)children, (Function)new Function<Node, Iterator<FedoraResource>>(){

            public Iterator<FedoraResource> apply(Node input) {
                try {
                    if (input.isNodeType("fedora:Pairtree")) {
                        return Iterators.concat((Iterator)FedoraResourceImpl.this.nodeToGoodChildren(input));
                    }
                    return Iterators.singletonIterator((Object)nodeToObjectBinaryConverter.convert((Object)input));
                }
                catch (RepositoryException e) {
                    throw new RepositoryRuntimeException((Throwable)e);
                }
            }
        });
    }

    public FedoraResource getContainer() {
        try {
            if (this.getNode().getDepth() == 0) {
                return null;
            }
            Node container = this.getNode().getParent();
            while (container.getDepth() > 0) {
                if (container.isNodeType("fedora:Pairtree") || container.isNodeType("fedora:NonRdfSourceDescription")) {
                    container = container.getParent();
                    continue;
                }
                return (FedoraResource)NodeResourceConverter.nodeConverter.convert(container);
            }
            return (FedoraResource)NodeResourceConverter.nodeConverter.convert(container);
        }
        catch (RepositoryException e) {
            throw new RepositoryRuntimeException((Throwable)e);
        }
    }

    public FedoraResource getChild(String relPath) {
        try {
            return (FedoraResource)NodeResourceConverter.nodeConverter.convert(this.getNode().getNode(relPath));
        }
        catch (RepositoryException e) {
            throw new RepositoryRuntimeException((Throwable)e);
        }
    }

    public boolean hasProperty(String relPath) {
        try {
            return this.getNode().hasProperty(relPath);
        }
        catch (RepositoryException e) {
            throw new RepositoryRuntimeException((Throwable)e);
        }
    }

    public Property getProperty(String relPath) {
        try {
            return this.getNode().getProperty(relPath);
        }
        catch (RepositoryException e) {
            throw new RepositoryRuntimeException((Throwable)e);
        }
    }

    public void delete() {
        try {
            Iterator inboundProperties = Iterators.concat((Iterator)new PropertyIterator(this.node.getReferences()), (Iterator)new PropertyIterator(this.node.getWeakReferences()));
            while (inboundProperties.hasNext()) {
                ((Property)inboundProperties.next()).remove();
            }
            Node parent = this.getNode().getDepth() > 0 ? this.getNode().getParent() : null;
            String name = this.getNode().getName();
            this.node.remove();
            if (parent != null) {
                this.createTombstone(parent, name);
            }
        }
        catch (RepositoryException e) {
            throw new RepositoryRuntimeException((Throwable)e);
        }
    }

    private void createTombstone(Node parent, String path) throws RepositoryException {
        this.findOrCreateChild(parent, path, "fedora:Tombstone");
    }

    public Date getCreatedDate() {
        try {
            if (this.hasProperty("jcr:created")) {
                return new Date(this.getProperty("jcr:created").getDate().getTimeInMillis());
            }
        }
        catch (PathNotFoundException e) {
            throw new PathNotFoundRuntimeException((Throwable)e);
        }
        catch (RepositoryException e) {
            throw new RepositoryRuntimeException((Throwable)e);
        }
        LOGGER.debug("Node {} does not have a createdDate", (Object)this.node);
        return null;
    }

    public Date getLastModifiedDate() {
        try {
            if (this.hasProperty("jcr:lastModified")) {
                return new Date(this.getProperty("jcr:lastModified").getDate().getTimeInMillis());
            }
        }
        catch (PathNotFoundException e) {
            throw new PathNotFoundRuntimeException((Throwable)e);
        }
        catch (RepositoryException e) {
            throw new RepositoryRuntimeException((Throwable)e);
        }
        LOGGER.debug("Could not get last modified date property for node {}", (Object)this.node);
        Date createdDate = this.getCreatedDate();
        if (createdDate != null) {
            LOGGER.trace("Using created date for last modified date for node {}", (Object)this.node);
            return createdDate;
        }
        return null;
    }

    public boolean hasType(String type) {
        try {
            if (JcrPropertyFunctions.isFrozen.apply((Object)this.node) && this.hasProperty("jcr:frozenMixinTypes")) {
                ArrayList types = Lists.newArrayList((Iterator)Iterators.transform((Iterator)((Iterator)JcrPropertyFunctions.property2values.apply((Object)this.getProperty("jcr:frozenMixinTypes"))), (Function)JcrPropertyFunctions.value2string));
                return types.contains(type);
            }
            return this.node.isNodeType(type);
        }
        catch (PathNotFoundException e) {
            throw new PathNotFoundRuntimeException((Throwable)e);
        }
        catch (RepositoryException e) {
            throw new RepositoryRuntimeException((Throwable)e);
        }
    }

    public void updateProperties(IdentifierConverter<Resource, FedoraResource> idTranslator, String sparqlUpdateStatement, RdfStream originalTriples) throws MalformedRdfException {
        Model model = originalTriples.asModel();
        JcrPropertyStatementListener listener = new JcrPropertyStatementListener(idTranslator, this.getSession());
        model.register((ModelChangedListener)listener);
        UpdateRequest request = UpdateFactory.create((String)sparqlUpdateStatement, (String)((Resource)idTranslator.reverse().convert((Object)this)).toString());
        model.setNsPrefixes(request.getPrefixMapping());
        UpdateAction.execute((UpdateRequest)request, (Model)model);
        listener.assertNoExceptions();
    }

    public RdfStream getTriples(IdentifierConverter<Resource, FedoraResource> idTranslator, Class<? extends RdfStream> context) {
        return this.getTriples(idTranslator, Collections.singleton(context));
    }

    public RdfStream getTriples(IdentifierConverter<Resource, FedoraResource> idTranslator, Iterable<? extends Class<? extends RdfStream>> contexts) {
        RdfStream stream = new RdfStream();
        for (Class<? extends RdfStream> clazz : contexts) {
            try {
                Constructor<? extends RdfStream> declaredConstructor = clazz.getDeclaredConstructor(FedoraResource.class, IdentifierConverter.class);
                RdfStream rdfStream = declaredConstructor.newInstance(new Object[]{this, idTranslator});
                stream.concat((Iterator)rdfStream);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException e) {
                throw Throwables.propagate((Throwable)e);
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                if (cause instanceof RepositoryException) {
                    throw new RepositoryRuntimeException(cause);
                }
                throw Throwables.propagate((Throwable)cause);
            }
        }
        return stream;
    }

    public void addVersionLabel(String label) {
        try {
            VersionHistory versionHistory = this.getVersionHistory();
            if (versionHistory.hasVersionLabel(label)) {
                throw new LabelExistsVersionException("The specified label \"" + label + "\" is already assigned to another version of this resource!");
            }
            versionHistory.addVersionLabel(this.getBaseVersion().getName(), label, false);
        }
        catch (RepositoryException e) {
            throw new RepositoryRuntimeException((Throwable)e);
        }
    }

    public Version getBaseVersion() {
        try {
            return this.getSession().getWorkspace().getVersionManager().getBaseVersion(this.getPath());
        }
        catch (RepositoryException e) {
            throw new RepositoryRuntimeException((Throwable)e);
        }
    }

    public VersionHistory getVersionHistory() {
        try {
            return this.getSession().getWorkspace().getVersionManager().getVersionHistory(this.getPath());
        }
        catch (RepositoryException e) {
            throw new RepositoryRuntimeException((Throwable)e);
        }
    }

    public Boolean isNew() {
        return this.node.isNew();
    }

    public void replaceProperties(IdentifierConverter<Resource, FedoraResource> idTranslator, Model inputModel, RdfStream originalTriples) throws MalformedRdfException {
        RdfStream replacementStream = new RdfStream().namespaces(inputModel.getNsPrefixMap());
        GraphDifferencingIterator differencer = new GraphDifferencingIterator(inputModel, (Iterator)originalTriples);
        StringBuilder exceptions = new StringBuilder();
        try {
            new RdfRemover(idTranslator, this.getSession(), replacementStream.withThisContext((Iterator)differencer)).consume();
        }
        catch (MalformedRdfException e) {
            exceptions.append(e.getMessage());
            exceptions.append("\n");
        }
        try {
            new RdfAdder(idTranslator, this.getSession(), replacementStream.withThisContext(differencer.notCommon())).consume();
        }
        catch (MalformedRdfException e) {
            exceptions.append(e.getMessage());
        }
        if (exceptions.length() > 0) {
            throw new MalformedRdfException(exceptions.toString());
        }
    }

    public String getEtagValue() {
        Date lastModifiedDate = this.getLastModifiedDate();
        if (lastModifiedDate != null) {
            return DigestUtils.shaHex((String)(this.getPath() + lastModifiedDate.getTime()));
        }
        return "";
    }

    public void enableVersioning() {
        try {
            this.node.addMixin("mix:versionable");
        }
        catch (RepositoryException e) {
            throw new RepositoryRuntimeException((Throwable)e);
        }
    }

    public void disableVersioning() {
        try {
            this.node.removeMixin("mix:versionable");
        }
        catch (RepositoryException e) {
            throw new RepositoryRuntimeException((Throwable)e);
        }
    }

    public boolean isVersioned() {
        try {
            return this.node.isNodeType("mix:versionable");
        }
        catch (RepositoryException e) {
            throw new RepositoryRuntimeException((Throwable)e);
        }
    }

    public boolean isFrozenResource() {
        return FedoraTypesUtils.isFrozenNode.apply((Object)this);
    }

    public FedoraResource getVersionedAncestor() {
        try {
            if (!this.isFrozenResource()) {
                return null;
            }
            Node versionableFrozenNode = this.getNode();
            FedoraResource unfrozenResource = this.getUnfrozenResource();
            while (!unfrozenResource.isVersioned()) {
                if (versionableFrozenNode.getDepth() == 0) {
                    return null;
                }
                versionableFrozenNode = versionableFrozenNode.getParent();
                unfrozenResource = new FedoraResourceImpl(versionableFrozenNode).getUnfrozenResource();
            }
            return new FedoraResourceImpl(versionableFrozenNode);
        }
        catch (RepositoryException e) {
            throw new RepositoryRuntimeException((Throwable)e);
        }
    }

    public FedoraResource getUnfrozenResource() {
        if (!this.isFrozenResource()) {
            return this;
        }
        try {
            return new FedoraResourceImpl(this.getSession().getNodeByIdentifier(this.getProperty("jcr:frozenUuid").getString()));
        }
        catch (RepositoryException e) {
            throw new RepositoryRuntimeException((Throwable)e);
        }
    }

    public Node getNodeVersion(String label) {
        try {
            VersionHistory hist;
            Session session = this.getSession();
            try {
                Node frozenNode = session.getNodeByIdentifier(label);
                String baseUUID = this.getNode().getIdentifier();
                Property p = frozenNode.getProperty("jcr:frozenUuid");
                if (p != null && p.getString().equals(baseUUID)) {
                    return frozenNode;
                }
            }
            catch (ItemNotFoundException ex) {
                // empty catch block
            }
            if (this.isVersioned() && (hist = session.getWorkspace().getVersionManager().getVersionHistory(this.getPath())).hasVersionLabel(label)) {
                LOGGER.debug("Found version for {} by label {}.", (Object)this, (Object)label);
                return hist.getVersionByLabel(label).getFrozenNode();
            }
            LOGGER.warn("Unknown version {} with label or uuid {}!", (Object)this, (Object)label);
            return null;
        }
        catch (RepositoryException e) {
            throw new RepositoryRuntimeException((Throwable)e);
        }
    }

    public boolean equals(Object object) {
        if (object instanceof FedoraResourceImpl) {
            return ((FedoraResourceImpl)((Object)object)).getNode().equals(this.getNode());
        }
        return false;
    }

    public int hashCode() {
        return this.getNode().hashCode();
    }

    protected Session getSession() {
        try {
            return this.getNode().getSession();
        }
        catch (RepositoryException e) {
            throw new RepositoryRuntimeException((Throwable)e);
        }
    }

    public String toString() {
        return this.getNode().toString();
    }
}

