/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.rdf.impl;

import com.google.common.base.Function;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.NodeFactory;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.vocabulary.RDF;
import java.util.Iterator;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NodeType;
import org.fcrepo.kernel.identifiers.IdentifierConverter;
import org.fcrepo.kernel.impl.rdf.JcrRdfTools;
import org.fcrepo.kernel.impl.rdf.impl.NodeRdfContext;
import org.fcrepo.kernel.models.FedoraResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypeRdfContext
extends NodeRdfContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(TypeRdfContext.class);

    public TypeRdfContext(FedoraResource resource, IdentifierConverter<Resource, FedoraResource> idTranslator) throws RepositoryException {
        super(resource, idTranslator);
        this.concatRdfTypes();
    }

    private void concatRdfTypes() throws RepositoryException {
        Object[] mixinNodeTypesArr;
        ImmutableList.Builder nodeTypesB = ImmutableList.builder();
        NodeType primaryNodeType = this.resource().getNode().getPrimaryNodeType();
        nodeTypesB.add((Object)primaryNodeType);
        if (primaryNodeType != null && primaryNodeType.getSupertypes() != null) {
            ImmutableSet primarySupertypes = ImmutableSet.builder().add((Object[])primaryNodeType.getSupertypes()).build();
            nodeTypesB.addAll((Iterable)primarySupertypes);
        }
        if ((mixinNodeTypesArr = this.resource().getNode().getMixinNodeTypes()) != null) {
            ImmutableSet mixinNodeTypes = ImmutableSet.builder().add(mixinNodeTypesArr).build();
            nodeTypesB.addAll((Iterable)mixinNodeTypes);
            ImmutableSet.Builder mixinSupertypes = ImmutableSet.builder();
            for (NodeType mixinNodeType : mixinNodeTypes) {
                mixinSupertypes.addAll((Iterable)ImmutableSet.builder().add((Object[])mixinNodeType.getSupertypes()).build());
            }
            nodeTypesB.addAll((Iterable)mixinSupertypes.build());
        }
        ImmutableList nodeTypes = nodeTypesB.build();
        UnmodifiableIterator nodeTypesIt = nodeTypes.iterator();
        this.concat(Iterators.transform((Iterator)nodeTypesIt, this.nodetype2triple()));
    }

    private Function<NodeType, Triple> nodetype2triple() {
        return new Function<NodeType, Triple>(){

            public Triple apply(NodeType nodeType) {
                try {
                    String fullTypeName = nodeType.getName();
                    LOGGER.trace("Translating JCR mixin name: {}", (Object)fullTypeName);
                    String prefix = fullTypeName.split(":")[0];
                    String typeName = fullTypeName.split(":")[1];
                    String namespace = TypeRdfContext.this.getJcrUri(prefix);
                    LOGGER.trace("with JCR namespace: {}", (Object)namespace);
                    Node rdfType = NodeFactory.createURI((String)(JcrRdfTools.getRDFNamespaceForJcrNamespace(namespace) + typeName));
                    LOGGER.trace("into RDF resource: {}", (Object)rdfType);
                    return Triple.create((Node)TypeRdfContext.this.subject(), (Node)RDF.type.asNode(), (Node)rdfType);
                }
                catch (RepositoryException e) {
                    throw Throwables.propagate((Throwable)e);
                }
            }
        };
    }

    private String getJcrUri(String prefix) throws RepositoryException {
        return this.resource().getNode().getSession().getWorkspace().getNamespaceRegistry().getURI(prefix);
    }
}

