/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.rdf.impl;

import com.google.common.base.Converter;
import com.google.common.base.Function;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterators;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.NodeFactory;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import java.util.Iterator;
import javax.jcr.RepositoryException;
import javax.jcr.version.Version;
import javax.jcr.version.VersionHistory;
import org.fcrepo.kernel.RdfLexicon;
import org.fcrepo.kernel.identifiers.IdentifierConverter;
import org.fcrepo.kernel.impl.identifiers.NodeResourceConverter;
import org.fcrepo.kernel.models.FedoraResource;
import org.fcrepo.kernel.utils.iterators.RdfStream;
import org.fcrepo.kernel.utils.iterators.VersionIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VersionsRdfContext
extends RdfStream {
    private final VersionHistory versionHistory;
    private final IdentifierConverter<Resource, FedoraResource> idTranslator;
    private final Node subject;
    private final Logger LOGGER = LoggerFactory.getLogger(VersionsRdfContext.class);
    private Function<Version, Iterator<Triple>> version2triples = new Function<Version, Iterator<Triple>>(){

        public Iterator<Triple> apply(Version version) {
            try {
                if (version.getName().equals(VersionsRdfContext.this.versionHistory.getRootVersion().getName())) {
                    VersionsRdfContext.this.LOGGER.trace("Skipped root version from triples");
                    return new RdfStream();
                }
                javax.jcr.Node frozenNode = version.getFrozenNode();
                Node versionSubject = ((Resource)NodeResourceConverter.nodeToResource((Converter<Resource, FedoraResource>)VersionsRdfContext.this.idTranslator).convert((Object)frozenNode)).asNode();
                RdfStream results = new RdfStream();
                results.concat(Triple.create((Node)VersionsRdfContext.this.subject, (Node)RdfLexicon.HAS_VERSION.asNode(), (Node)versionSubject));
                for (String label : VersionsRdfContext.this.versionHistory.getVersionLabels(version)) {
                    results.concat(Triple.create((Node)versionSubject, (Node)RdfLexicon.HAS_VERSION_LABEL.asNode(), (Node)NodeFactory.createLiteral((String)label)));
                }
                results.concat(Triple.create((Node)versionSubject, (Node)RdfLexicon.CREATED_DATE.asNode(), (Node)ResourceFactory.createTypedLiteral((Object)version.getCreated()).asNode()));
                return results;
            }
            catch (RepositoryException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
    };

    public VersionsRdfContext(FedoraResource resource, IdentifierConverter<Resource, FedoraResource> idTranslator) throws RepositoryException {
        this.idTranslator = idTranslator;
        this.subject = ((Resource)idTranslator.reverse().convert((Object)resource)).asNode();
        this.versionHistory = resource.getVersionHistory();
        this.concat(this.versionTriples());
    }

    private Iterator<Triple> versionTriples() throws RepositoryException {
        return Iterators.concat((Iterator)Iterators.transform((Iterator)new VersionIterator(this.versionHistory.getAllVersions()), this.version2triples));
    }
}

