/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.rdf.impl.mappings;

import com.google.common.base.Throwables;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.util.Iterator;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.ItemDefinition;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeType;
import org.fcrepo.kernel.impl.rdf.impl.mappings.ItemDefinitionToTriples;
import org.fcrepo.kernel.utils.iterators.RdfStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeDefinitionToTriples
extends ItemDefinitionToTriples<NodeDefinition> {
    private static final Logger LOGGER = LoggerFactory.getLogger(NodeDefinitionToTriples.class);

    public NodeDefinitionToTriples(Node domain) {
        super(domain);
    }

    @Override
    public Iterator<Triple> apply(NodeDefinition input) {
        try {
            Node propertyDefinitionNode = NodeDefinitionToTriples.getResource((ItemDefinition)input).asNode();
            NodeType[] requiredPrimaryTypes = input.getRequiredPrimaryTypes();
            if (requiredPrimaryTypes.length > 1) {
                LOGGER.trace("Skipping RDFS:range for {} with multiple primary types", (Object)propertyDefinitionNode.getName());
            } else {
                if (requiredPrimaryTypes.length == 1) {
                    LOGGER.trace("Adding RDFS:range for {} with primary types {}", (Object)input.getName(), (Object)requiredPrimaryTypes[0].getName());
                    return new RdfStream(Triple.create((Node)propertyDefinitionNode, (Node)RDFS.range.asNode(), (Node)NodeDefinitionToTriples.getResource(requiredPrimaryTypes[0]).asNode())).concat(super.apply(input));
                }
                LOGGER.trace("Skipping RDFS:range for {} with no required primary types");
            }
            return super.apply(input);
        }
        catch (RepositoryException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

