/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.services;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.fcrepo.kernel.exception.RepositoryRuntimeException;
import org.fcrepo.kernel.exception.TombstoneException;
import org.fcrepo.kernel.impl.TombstoneImpl;
import org.fcrepo.kernel.impl.utils.FedoraTypesUtils;
import org.fcrepo.kernel.models.FedoraResource;
import org.modeshape.jcr.api.JcrTools;

public abstract class AbstractService {
    protected static final JcrTools jcrTools = new JcrTools();

    protected Node findOrCreateNode(Session session, String path, String finalNodeType) throws RepositoryException {
        Node preexistingNode = FedoraTypesUtils.getClosestExistingAncestor(session, path);
        if (TombstoneImpl.hasMixin(preexistingNode)) {
            throw new TombstoneException((FedoraResource)new TombstoneImpl(preexistingNode));
        }
        Node node = jcrTools.findOrCreateNode(session, path, "nt:folder", finalNodeType);
        if (node.isNew()) {
            this.tagHierarchyWithPairtreeMixin(preexistingNode, node);
        }
        return node;
    }

    protected Node findNode(Session session, String path) {
        try {
            return session.getNode(path);
        }
        catch (RepositoryException e) {
            throw new RepositoryRuntimeException((Throwable)e);
        }
    }

    private void tagHierarchyWithPairtreeMixin(Node baseNode, Node createdNode) throws RepositoryException {
        Node parent = createdNode.getParent();
        while (parent.isNew() && !parent.equals(baseNode)) {
            parent.addMixin("fedora:Pairtree");
            parent = parent.getParent();
        }
    }

    public boolean exists(Session session, String path) {
        try {
            return session.nodeExists(path);
        }
        catch (RepositoryException e) {
            throw new RepositoryRuntimeException((Throwable)e);
        }
    }
}

