/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.utils.impl;

import javax.jcr.Binary;
import javax.jcr.Property;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import org.fcrepo.kernel.impl.utils.BinaryCacheEntry;
import org.fcrepo.kernel.impl.utils.ProjectedCacheEntry;
import org.fcrepo.kernel.impl.utils.impl.FileSystemBinaryStoreEntry;
import org.fcrepo.kernel.impl.utils.impl.InfinispanCacheStoreEntry;
import org.fcrepo.kernel.impl.utils.impl.LocalBinaryStoreEntry;
import org.fcrepo.kernel.utils.CacheEntry;
import org.modeshape.jcr.GetBinaryStore;
import org.modeshape.jcr.value.BinaryValue;
import org.modeshape.jcr.value.binary.BinaryStore;
import org.modeshape.jcr.value.binary.CompositeBinaryStore;
import org.modeshape.jcr.value.binary.ExternalBinaryValue;
import org.modeshape.jcr.value.binary.FileSystemBinaryStore;
import org.modeshape.jcr.value.binary.InMemoryBinaryValue;
import org.modeshape.jcr.value.binary.infinispan.InfinispanBinaryStore;

public class CacheEntryFactory {
    private static GetBinaryStore getBinaryStore = new GetBinaryStore();

    private CacheEntryFactory() {
    }

    public static CacheEntry forProperty(Repository repository, Property property) throws RepositoryException {
        Binary binary = property.getBinary();
        BinaryStore store = CacheEntryFactory.binaryStore(repository);
        if (binary instanceof ExternalBinaryValue) {
            return new ProjectedCacheEntry(property);
        }
        if (binary instanceof InMemoryBinaryValue) {
            return new BinaryCacheEntry(property);
        }
        return CacheEntryFactory.forProperty(store, property);
    }

    public static CacheEntry forProperty(BinaryStore store, Property property) throws RepositoryException {
        BinaryValue binary = (BinaryValue)property.getBinary();
        if (store instanceof InfinispanBinaryStore) {
            return new InfinispanCacheStoreEntry((InfinispanBinaryStore)store, property);
        }
        if (store instanceof FileSystemBinaryStore) {
            return new FileSystemBinaryStoreEntry((FileSystemBinaryStore)store, property);
        }
        if (store instanceof CompositeBinaryStore) {
            CompositeBinaryStore compositeBinaryStore = (CompositeBinaryStore)store;
            BinaryStore binaryStoreContainingKey = compositeBinaryStore.findBinaryStoreContainingKey(binary.getKey());
            return CacheEntryFactory.forProperty(binaryStoreContainingKey, property);
        }
        return new LocalBinaryStoreEntry(store, property);
    }

    private static BinaryStore binaryStore(Repository repo) {
        BinaryStore store = getBinaryStore.apply(repo);
        assert (store != null);
        return store;
    }
}

