/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.lock.Lock;
import javax.jcr.lock.LockException;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.annotation.ThreadSafe;
import org.modeshape.common.i18n.I18nResource;
import org.modeshape.common.logging.Logger;
import org.modeshape.jcr.AbstractJcrNode;
import org.modeshape.jcr.ExecutionContext;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.JcrLexicon;
import org.modeshape.jcr.JcrLockManager;
import org.modeshape.jcr.JcrRepository;
import org.modeshape.jcr.JcrSession;
import org.modeshape.jcr.ModeShapeLexicon;
import org.modeshape.jcr.RepositoryConfiguration;
import org.modeshape.jcr.SystemContent;
import org.modeshape.jcr.api.value.DateTime;
import org.modeshape.jcr.cache.CachedNode;
import org.modeshape.jcr.cache.ChildReference;
import org.modeshape.jcr.cache.LockFailureException;
import org.modeshape.jcr.cache.MutableCachedNode;
import org.modeshape.jcr.cache.NodeCache;
import org.modeshape.jcr.cache.NodeKey;
import org.modeshape.jcr.cache.SessionCache;
import org.modeshape.jcr.cache.change.Change;
import org.modeshape.jcr.cache.change.ChangeSet;
import org.modeshape.jcr.cache.change.ChangeSetListener;
import org.modeshape.jcr.cache.change.NodeAdded;
import org.modeshape.jcr.cache.change.NodeRemoved;
import org.modeshape.jcr.value.DateTimeFactory;
import org.modeshape.jcr.value.Name;
import org.modeshape.jcr.value.Path;
import org.modeshape.jcr.value.PathFactory;
import org.modeshape.jcr.value.Property;
import org.modeshape.jcr.value.PropertyFactory;

@ThreadSafe
class RepositoryLockManager
implements ChangeSetListener {
    private static final int KEY_OFFSET = "mode:lock-".length();
    private final JcrRepository.RunningState repository;
    private final String systemWorkspaceName;
    private final String processId;
    private final ConcurrentMap<NodeKey, ModeShapeLock> locksByNodeKey;
    private final Path locksPath;
    private final Logger logger;

    RepositoryLockManager(JcrRepository.RunningState repository) {
        this.repository = repository;
        this.systemWorkspaceName = repository.repositoryCache().getSystemWorkspaceName();
        this.processId = repository.context().getProcessId();
        this.locksByNodeKey = new ConcurrentHashMap<NodeKey, ModeShapeLock>();
        PathFactory pathFactory = repository.context().getValueFactories().getPathFactory();
        this.locksPath = pathFactory.create(pathFactory.createRootPath(), new Name[]{JcrLexicon.SYSTEM, ModeShapeLexicon.LOCKS});
        this.logger = Logger.getLogger(this.getClass());
    }

    RepositoryLockManager with(JcrRepository.RunningState repository) {
        assert (this.systemWorkspaceName == repository.repositoryCache().getSystemWorkspaceName());
        assert (this.processId == repository.context().getProcessId());
        PathFactory pathFactory = repository.context().getValueFactories().getPathFactory();
        Path locksPath = pathFactory.create(pathFactory.createRootPath(), new Name[]{JcrLexicon.SYSTEM, ModeShapeLexicon.LOCKS});
        assert (this.locksPath.equals(locksPath));
        return new RepositoryLockManager(repository);
    }

    protected void refreshFromSystem() {
        try {
            SessionCache systemCache = this.repository.createSystemSession(this.repository.context(), true);
            SystemContent system = new SystemContent(systemCache);
            CachedNode locks = system.locksNode();
            for (ChildReference ref : locks.getChildReferences((NodeCache)systemCache)) {
                CachedNode node = systemCache.getNode(ref);
                if (node == null) {
                    this.logger.warn((I18nResource)JcrI18n.lockNotFound, new Object[]{ref.getKey()});
                    continue;
                }
                ModeShapeLock lock = new ModeShapeLock(node, (NodeCache)systemCache);
                this.locksByNodeKey.put(lock.getLockedNodeKey(), lock);
            }
        }
        catch (Throwable e) {
            this.logger.error(e, (I18nResource)JcrI18n.errorRefreshingLocks, new Object[]{this.repository.name()});
        }
    }

    protected void cleanupLocks(Set<String> activeSessionIds) {
        try {
            ExecutionContext context = this.repository.context();
            DateTimeFactory dates = context.getValueFactories().getDateFactory();
            DateTime now = dates.create();
            DateTime newExpiration = dates.create(now, (long)RepositoryConfiguration.LOCK_EXTENSION_INTERVAL_IN_MILLIS);
            PropertyFactory propertyFactory = context.getPropertyFactory();
            SessionCache systemSession = this.repository.createSystemSession(context, false);
            SystemContent systemContent = new SystemContent(systemSession);
            HashMap<String, ArrayList<NodeKey>> lockedNodesByWorkspaceName = new HashMap<String, ArrayList<NodeKey>>();
            MutableCachedNode locksNode = systemContent.mutableLocksNode();
            for (ChildReference ref : locksNode.getChildReferences((NodeCache)systemSession)) {
                NodeKey lockKey = ref.getKey();
                CachedNode lockNode = systemSession.getNode(lockKey);
                if (lockNode == null) continue;
                ModeShapeLock lock = new ModeShapeLock(lockNode, (NodeCache)systemSession);
                NodeKey lockedNodeKey = lock.getLockedNodeKey();
                if (lock.isSessionScoped() && activeSessionIds.contains(lock.getLockingSessionId())) {
                    MutableCachedNode mutableLockNode = systemSession.mutable(lockKey);
                    Property prop = propertyFactory.create(ModeShapeLexicon.EXPIRATION_DATE, (Object)newExpiration);
                    mutableLockNode.setProperty(systemSession, prop);
                    this.locksByNodeKey.replace(lockedNodeKey, lock.withExpiryTime(newExpiration));
                    continue;
                }
                DateTime expirationDate = this.firstDate(lockNode.getProperty(ModeShapeLexicon.EXPIRATION_DATE, (NodeCache)systemSession));
                if (!expirationDate.isBefore(now)) continue;
                systemContent.removeLock(lock);
                ArrayList<NodeKey> lockedNodes = (ArrayList<NodeKey>)lockedNodesByWorkspaceName.get(lock.getWorkspaceName());
                if (lockedNodes == null) {
                    lockedNodes = new ArrayList<NodeKey>();
                    lockedNodesByWorkspaceName.put(lock.getWorkspaceName(), lockedNodes);
                }
                lockedNodes.add(lockedNodeKey);
            }
            systemSession.save();
            for (String workspaceName : lockedNodesByWorkspaceName.keySet()) {
                SessionCache internalSession = this.repository.repositoryCache().createSession(context, workspaceName, false);
                for (NodeKey lockedNodeKey : (List)lockedNodesByWorkspaceName.get(workspaceName)) {
                    this.locksByNodeKey.remove(lockedNodeKey);
                    CachedNode lockedNode = internalSession.getWorkspace().getNode(lockedNodeKey);
                    if (lockedNode == null) continue;
                    MutableCachedNode mutableLockedNode = internalSession.mutable(lockedNodeKey);
                    mutableLockedNode.removeProperty(internalSession, JcrLexicon.LOCK_IS_DEEP);
                    mutableLockedNode.removeProperty(internalSession, JcrLexicon.LOCK_OWNER);
                    mutableLockedNode.unlock();
                }
                internalSession.save();
            }
        }
        catch (Throwable t) {
            this.logger.error(t, (I18nResource)JcrI18n.errorCleaningUpLocks, new Object[]{this.repository.name()});
        }
    }

    protected final NodeKey lockedNodeKeyFromLockKey(NodeKey key) {
        String identifier = key.getIdentifier();
        return new NodeKey(identifier.substring(KEY_OFFSET));
    }

    final boolean isLocked(NodeKey lockedNodeKey) {
        return this.locksByNodeKey.containsKey(lockedNodeKey);
    }

    final ModeShapeLock findLockFor(NodeKey nodeKey) {
        return (ModeShapeLock)this.locksByNodeKey.get(nodeKey);
    }

    private final CachedNode findLockedNodeAtOrBelow(CachedNode node, NodeCache cache) {
        if (node.getChildReferences(cache).isEmpty() && this.isLocked(node.getKey())) {
            return node;
        }
        Path path = node.getPath(cache);
        for (ModeShapeLock lock : this.locksByNodeKey.values()) {
            Path lockedPath;
            CachedNode lockedNode = cache.getNode(lock.getLockedNodeKey());
            if (lockedNode == null || !(lockedPath = lockedNode.getPath(cache)).isAtOrBelow(path)) continue;
            return lockedNode;
        }
        return null;
    }

    final Collection<ModeShapeLock> allLocks() {
        return this.locksByNodeKey.values();
    }

    protected final NodeKey generateLockKey(NodeKey prototype, NodeKey lockedNodeKey) {
        return prototype.withId("mode:lock-" + lockedNodeKey.toString());
    }

    protected final String generateLockToken() {
        return UUID.randomUUID().toString();
    }

    ModeShapeLock lock(JcrSession session, CachedNode node, boolean isDeep, boolean isSessionScoped, long timeoutHint, String ownerInfo) throws LockException, RepositoryException {
        SessionCache cache;
        CachedNode locked;
        assert (session != null);
        assert (node != null);
        ExecutionContext context = session.context();
        String owner = ownerInfo != null ? ownerInfo : session.getUserID();
        DateTimeFactory dateFactory = context.getValueFactories().getDateFactory();
        long expirationTimeInMillis = RepositoryConfiguration.LOCK_EXPIRY_AGE_IN_MILLIS;
        if (timeoutHint > 0L && timeoutHint < Long.MAX_VALUE) {
            expirationTimeInMillis = TimeUnit.MILLISECONDS.convert(timeoutHint, TimeUnit.SECONDS);
        }
        DateTime expirationDate = dateFactory.create().plus(expirationTimeInMillis, TimeUnit.MILLISECONDS);
        SessionCache systemSession = this.repository.createSystemSession(context, false);
        SystemContent system = new SystemContent(systemSession);
        NodeKey nodeKey = node.getKey();
        NodeKey lockKey = this.generateLockKey(system.locksKey(), nodeKey);
        String token = this.generateLockToken();
        ModeShapeLock lock = new ModeShapeLock(nodeKey, lockKey, session.workspaceName(), owner, token, isDeep, isSessionScoped, session.sessionId(), expirationDate);
        if (isDeep && (locked = this.findLockedNodeAtOrBelow(node, (NodeCache)(cache = session.cache()))) != null) {
            String nodePath = (String)session.stringFactory().create(node.getPath((NodeCache)cache));
            String descendantPath = (String)session.stringFactory().create(locked.getPath((NodeCache)cache));
            throw new LockException(JcrI18n.descendantAlreadyLocked.text(new Object[]{nodePath, descendantPath}));
        }
        ModeShapeLock existing = this.locksByNodeKey.putIfAbsent(nodeKey, lock);
        if (existing != null) {
            SessionCache cache2 = session.cache();
            CachedNode locked2 = cache2.getNode(existing.getLockedNodeKey());
            String lockedPath = (String)session.stringFactory().create(locked2.getPath((NodeCache)cache2));
            throw new LockException(JcrI18n.alreadyLocked.text(new Object[]{lockedPath}));
        }
        try {
            system.storeLock(lock);
            SessionCache lockingSession = session.spawnSessionCache(false);
            MutableCachedNode lockedNode = lockingSession.mutable(nodeKey);
            PropertyFactory propertyFactory = session.propertyFactory();
            lockedNode.setProperty(lockingSession, propertyFactory.create(JcrLexicon.LOCK_OWNER, (Object)owner));
            lockedNode.setProperty(lockingSession, propertyFactory.create(JcrLexicon.LOCK_IS_DEEP, (Object)isDeep));
            lockedNode.lock(isSessionScoped);
            lockingSession.save(systemSession, null);
        }
        catch (LockFailureException e) {
            String location = nodeKey.toString();
            try {
                location = session.node(nodeKey, null).getPath();
            }
            catch (Throwable t) {
                // empty catch block
            }
            this.locksByNodeKey.remove(nodeKey);
            throw new LockException(JcrI18n.alreadyLocked.text(new Object[]{location}));
        }
        catch (RuntimeException e) {
            this.locksByNodeKey.remove(nodeKey);
            throw new RepositoryException((Throwable)e);
        }
        return lock;
    }

    boolean setHeldBySession(JcrSession session, String lockToken, boolean value) throws LockException {
        assert (lockToken != null);
        ExecutionContext context = session.context();
        SessionCache systemSession = this.repository.createSystemSession(context, false);
        SystemContent system = new SystemContent(systemSession);
        if (!system.changeLockHeldBySession(lockToken, value)) {
            return false;
        }
        system.save();
        return true;
    }

    String unlock(JcrSession session, NodeKey lockedNodeKey) throws LockException {
        ModeShapeLock existing = (ModeShapeLock)this.locksByNodeKey.remove(lockedNodeKey);
        if (existing == null) {
            SessionCache cache = session.cache();
            String location = (String)session.stringFactory().create(cache.getNode(lockedNodeKey).getPath((NodeCache)cache));
            throw new LockException(JcrI18n.notLocked.text(new Object[]{location}));
        }
        this.unlock(session, Collections.singleton(existing));
        return existing.getLockToken();
    }

    private void unlock(JcrSession session, Iterable<ModeShapeLock> locks) {
        if (locks == null) {
            return;
        }
        ExecutionContext context = session.context();
        SessionCache systemSession = this.repository.createSystemSession(context, false);
        SystemContent system = new SystemContent(systemSession);
        SessionCache lockingSession = session.spawnSessionCache(false);
        for (ModeShapeLock lock : locks) {
            system.removeLock(lock);
            NodeKey lockedNodeKey = lock.getLockedNodeKey();
            if (session.cache().getNode(lockedNodeKey) == null) continue;
            MutableCachedNode lockedNode = lockingSession.mutable(lockedNodeKey);
            lockedNode.removeProperty(lockingSession, JcrLexicon.LOCK_IS_DEEP);
            lockedNode.removeProperty(lockingSession, JcrLexicon.LOCK_OWNER);
            lockedNode.unlock();
        }
        lockingSession.save(systemSession, null);
    }

    void cleanLocks(JcrSession session) throws RepositoryException {
        Set<String> lockTokens = session.lockManager().lockTokens();
        LinkedList<ModeShapeLock> locks = null;
        for (ModeShapeLock lock : this.locksByNodeKey.values()) {
            if (!lock.isSessionScoped() || !lockTokens.contains(lock.getLockToken())) continue;
            if (locks == null) {
                locks = new LinkedList<ModeShapeLock>();
            }
            locks.add(lock);
        }
        if (locks != null) {
            this.unlock(session, locks);
            for (ModeShapeLock lock : locks) {
                this.locksByNodeKey.remove(lock.getLockedNodeKey());
            }
        }
    }

    public void notify(ChangeSet changeSet) {
        if (!this.systemWorkspaceName.equals(changeSet.getWorkspaceName())) {
            return;
        }
        if (this.processId.equals(changeSet.getProcessKey())) {
            return;
        }
        try {
            HashSet locksToDelete = null;
            for (Change change : changeSet) {
                NodeRemoved removed;
                Path removedPath;
                if (change instanceof NodeAdded) {
                    NodeAdded added = (NodeAdded)change;
                    Path addedPath = added.getPath();
                    if (!this.locksPath.isAncestorOf(addedPath)) continue;
                    Map props = added.getProperties();
                    NodeKey lockKey = added.getKey();
                    ModeShapeLock lock = new ModeShapeLock(lockKey, props);
                    this.locksByNodeKey.put(lock.getLockedNodeKey(), lock);
                    continue;
                }
                if (!(change instanceof NodeRemoved) || !this.locksPath.isAncestorOf(removedPath = (removed = (NodeRemoved)change).getPath())) continue;
                if (locksToDelete == null) {
                    locksToDelete = new HashSet();
                }
                NodeKey lockedNodeKey = this.lockedNodeKeyFromLockKey(removed.getKey());
                this.locksByNodeKey.remove(lockedNodeKey);
            }
        }
        catch (Throwable e) {
            this.logger.error(e, (I18nResource)JcrI18n.errorCleaningUpLocks, new Object[]{this.repository.name()});
        }
    }

    protected final String firstString(Property property) {
        if (property == null) {
            return null;
        }
        return (String)this.repository.context().getValueFactories().getStringFactory().create(property.getFirstValue());
    }

    protected final boolean firstBoolean(Property property) {
        if (property == null) {
            return false;
        }
        return (Boolean)this.repository.context().getValueFactories().getBooleanFactory().create(property.getFirstValue());
    }

    protected final DateTime firstDate(Property property) {
        if (property == null) {
            return null;
        }
        return (DateTime)this.repository.context().getValueFactories().getDateFactory().create(property.getFirstValue());
    }

    final ModeShapeLock findLockByToken(String token) {
        assert (token != null);
        for (ModeShapeLock lock : this.locksByNodeKey.values()) {
            if (!token.equals(lock.getLockToken())) continue;
            return lock;
        }
        return null;
    }

    @Immutable
    public class ModeShapeLock {
        private final NodeKey lockedNodeKey;
        private final NodeKey lockKey;
        private final String lockOwner;
        private final String workspaceName;
        private final String lockToken;
        private final boolean deep;
        private final boolean sessionScoped;
        private final String lockingSessionId;
        private final DateTime expiryTime;

        protected ModeShapeLock(CachedNode lockNode, NodeCache cache) {
            this.lockKey = lockNode.getKey();
            this.lockedNodeKey = RepositoryLockManager.this.lockedNodeKeyFromLockKey(this.lockKey);
            this.workspaceName = RepositoryLockManager.this.firstString(lockNode.getProperty(ModeShapeLexicon.WORKSPACE, cache));
            this.lockOwner = RepositoryLockManager.this.firstString(lockNode.getProperty(JcrLexicon.LOCK_OWNER, cache));
            this.deep = RepositoryLockManager.this.firstBoolean(lockNode.getProperty(JcrLexicon.LOCK_IS_DEEP, cache));
            this.sessionScoped = RepositoryLockManager.this.firstBoolean(lockNode.getProperty(ModeShapeLexicon.IS_SESSION_SCOPED, cache));
            this.lockToken = RepositoryLockManager.this.firstString(lockNode.getProperty(ModeShapeLexicon.LOCK_TOKEN, cache));
            this.lockingSessionId = RepositoryLockManager.this.firstString(lockNode.getProperty(ModeShapeLexicon.LOCKING_SESSION, cache));
            this.expiryTime = RepositoryLockManager.this.firstDate(lockNode.getProperty(ModeShapeLexicon.EXPIRATION_DATE, cache));
        }

        protected ModeShapeLock(NodeKey lockKey, Map<Name, Property> properties) {
            this.lockKey = lockKey;
            this.lockedNodeKey = RepositoryLockManager.this.lockedNodeKeyFromLockKey(lockKey);
            this.workspaceName = RepositoryLockManager.this.firstString(properties.get(ModeShapeLexicon.WORKSPACE));
            this.lockOwner = RepositoryLockManager.this.firstString(properties.get(JcrLexicon.LOCK_OWNER));
            this.deep = RepositoryLockManager.this.firstBoolean(properties.get(JcrLexicon.LOCK_IS_DEEP));
            this.sessionScoped = RepositoryLockManager.this.firstBoolean(properties.get(ModeShapeLexicon.IS_SESSION_SCOPED));
            this.lockToken = RepositoryLockManager.this.firstString(properties.get(ModeShapeLexicon.LOCK_TOKEN));
            this.lockingSessionId = RepositoryLockManager.this.firstString(properties.get(ModeShapeLexicon.LOCKING_SESSION));
            this.expiryTime = RepositoryLockManager.this.firstDate(properties.get(ModeShapeLexicon.EXPIRATION_DATE));
        }

        protected ModeShapeLock(NodeKey lockedNodeKey, NodeKey lockKey, String workspace, String lockOwner, String lockToken, boolean deep, boolean sessionScoped, String lockingSessionId, DateTime expiryTime) {
            this.lockedNodeKey = lockedNodeKey;
            this.lockKey = lockKey;
            this.lockOwner = lockOwner;
            this.workspaceName = workspace;
            this.deep = deep;
            this.sessionScoped = sessionScoped;
            this.lockToken = lockToken;
            this.lockingSessionId = lockingSessionId;
            this.expiryTime = expiryTime;
        }

        protected ModeShapeLock withExpiryTime(DateTime expiryTime) {
            return new ModeShapeLock(this.lockedNodeKey, this.lockKey, this.workspaceName, this.lockOwner, this.lockToken, this.deep, this.sessionScoped, this.lockingSessionId, expiryTime);
        }

        public boolean isLive() {
            return RepositoryLockManager.this.isLocked(this.lockedNodeKey);
        }

        public NodeKey getLockKey() {
            return this.lockKey;
        }

        public NodeKey getLockedNodeKey() {
            return this.lockedNodeKey;
        }

        public String getWorkspaceName() {
            return this.workspaceName;
        }

        public boolean isDeep() {
            return this.deep;
        }

        public String getLockOwner() {
            return this.lockOwner;
        }

        public boolean isSessionScoped() {
            return this.sessionScoped;
        }

        public String getLockToken() {
            return this.lockToken;
        }

        public String getLockingSessionId() {
            return this.lockingSessionId;
        }

        public DateTime getExpiryTime() {
            return this.expiryTime;
        }

        public Lock lockFor(JcrSession session) throws RepositoryException {
            final AbstractJcrNode node = session.node(this.lockedNodeKey, null);
            final JcrLockManager lockManager = session.workspace().getLockManager();
            return new Lock(){

                public String getLockOwner() {
                    return ModeShapeLock.this.lockOwner;
                }

                public String getLockToken() {
                    if (ModeShapeLock.this.sessionScoped) {
                        return null;
                    }
                    String token = ModeShapeLock.this.getLockToken();
                    return lockManager.hasLockToken(token) ? token : null;
                }

                protected final String lockToken() {
                    return ModeShapeLock.this.getLockToken();
                }

                public Node getNode() {
                    return node;
                }

                public boolean isDeep() {
                    return ModeShapeLock.this.deep;
                }

                public boolean isLive() {
                    return ModeShapeLock.this.isLive();
                }

                public boolean isSessionScoped() {
                    return ModeShapeLock.this.sessionScoped;
                }

                public void refresh() throws LockException {
                    String token = this.lockToken();
                    if (!lockManager.hasLockToken(token)) {
                        String location = null;
                        try {
                            location = node.getPath();
                        }
                        catch (RepositoryException e) {
                            location = ModeShapeLock.this.lockedNodeKey.toString();
                        }
                        throw new LockException(JcrI18n.notLocked.text(new Object[]{location}));
                    }
                }

                public long getSecondsRemaining() {
                    return this.isLockOwningSession() ? Long.MAX_VALUE : Long.MIN_VALUE;
                }

                public boolean isLockOwningSession() {
                    String token = this.lockToken();
                    return lockManager.hasLockToken(token);
                }
            };
        }

        public String toString() {
            return "Lock " + this.lockKey + " for " + this.lockedNodeKey + " in '" + this.workspaceName + "' (" + (this.deep ? "deep," : "shallow;") + (this.sessionScoped ? "session;" : "global;") + "owner='" + this.lockOwner + "';token='" + this.lockToken + "';";
        }
    }
}

