/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.identifiers;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.fcrepo.kernel.impl.identifiers.HierarchyConverter;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HierarchyConverterTest {
    private static final String separator = "/";
    private HierarchyConverter testTranslator;
    private static final String[] testIdSegments = new String[]{"test1", "test2", "test3"};
    private static final String startingSegments = testIdSegments[0] + "/" + testIdSegments[1];
    private static final String endingSegment = testIdSegments[2];
    private final String testId = Joiner.on((String)"/").join((Object[])testIdSegments);
    private static final Logger log = LoggerFactory.getLogger(HierarchyConverterTest.class);

    @Before
    public void setUp() {
        this.testTranslator = new HierarchyConverter();
        this.testTranslator.setPrefix("");
        this.testTranslator.setLevels(0);
        this.testTranslator.setLength(1);
        this.testTranslator.setSeparator(separator);
    }

    @Test
    public void testNullForward() {
        Assert.assertNull((String)"Should get null forward for null input!", (Object)this.testTranslator.convert(null));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testBadSegmentLength() {
        this.testTranslator.setLength(0);
    }

    @Test
    public void testNoOpForward() {
        Assert.assertEquals((String)"Should not have altered input identifier!", (Object)this.testId, (Object)this.testTranslator.convert((Object)this.testId));
    }

    @Test
    public void testVaryingSegments() {
        for (byte length = 1; length < 5; length = (byte)(length + 1)) {
            for (byte levels = 1; levels < 5; levels = (byte)(levels + 1)) {
                this.testRoundTrip(levels, length);
            }
        }
    }

    public void testRoundTrip(byte levels, byte length) {
        this.testTranslator.setLevels((int)levels);
        this.testTranslator.setLength((int)length);
        String result = (String)this.testTranslator.reverse().convert((Object)this.testId);
        String testRegexp = startingSegments + separator + HierarchyConverterTest.hierarchyRegexpSection(levels, length) + separator + endingSegment;
        Matcher matches = Pattern.compile(testRegexp).matcher(result);
        log.debug("Got result of translation: {}", (Object)result);
        log.debug("Matching against test pattern: {}", (Object)testRegexp);
        Assert.assertTrue((String)"Did not find the appropriate modification to the input identifier!", (boolean)matches.matches());
        String shouldBeOriginal = (String)this.testTranslator.convert((Object)result);
        Assert.assertEquals((String)"Didn't get original back!", (Object)this.testId, (Object)shouldBeOriginal);
    }

    private static String hierarchyRegexpSection(byte levels, byte length) {
        return Joiner.on((String)separator).join(Collections.nCopies(levels, Strings.repeat((String)"\\w", (int)length)));
    }

    @Test
    public void testRecurse() {
        this.testTranslator.setLevels(3);
        this.testTranslator.setLength(3);
        String firstPass = (String)this.testTranslator.reverse().convert((Object)this.testId);
        String secondPass = (String)this.testTranslator.reverse().convert((Object)firstPass);
        Assert.assertEquals((String)"Failed to retrieve original after two stages of translation!", (Object)this.testId, (Object)this.testTranslator.convert(this.testTranslator.convert((Object)secondPass)));
    }

    @Test
    public void testWeirdIds() {
        this.testTranslator.setLevels(3);
        this.testTranslator.setLength(3);
        String result = (String)this.testTranslator.reverse().convert((Object)"");
        log.debug("Empty identifier translated into {}.", (Object)"", (Object)result);
        Assert.assertEquals((String)"Should not have altered empty identifier!", (Object)"", (Object)this.testTranslator.convert((Object)result));
        result = (String)this.testTranslator.reverse().convert((Object)separator);
        log.debug("Separator identifier translated into {}.", (Object)separator, (Object)result);
        Assert.assertEquals((String)"Should have altered separator identifier to empty identifier!", (Object)"", (Object)this.testTranslator.convert((Object)result));
    }
}

