/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.rdf.impl;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.vocabulary.RDF;
import javax.jcr.NamespaceRegistry;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.Workspace;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.PropertyDefinition;
import org.fcrepo.kernel.identifiers.IdentifierConverter;
import org.fcrepo.kernel.impl.rdf.impl.BlankNodeRdfContext;
import org.fcrepo.kernel.impl.rdf.impl.DefaultIdentifierTranslator;
import org.fcrepo.kernel.impl.testutilities.TestPropertyIterator;
import org.fcrepo.kernel.models.FedoraResource;
import org.fcrepo.kernel.utils.iterators.RdfStream;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class BlankNodeRdfContextTest {
    @Mock
    private FedoraResource mockResource;
    @Mock
    private Node mockNode;
    @Mock
    private Session mockSession;
    @Mock
    private Node mockBlankNode;
    @Mock
    private Node mockNestedBlankNode;
    @Mock
    private Node mockOtherNode;
    @Mock
    private Property mockProperty;
    @Mock
    private Property mockReferenceProperty;
    @Mock
    private Property mockBnodeReferenceProperty;
    @Mock
    private Property mockOtherBnodeReferenceProperty;
    @Mock
    private Value mockReferenceValue;
    @Mock
    private Value mockBnodeValue;
    @Mock
    private Value mockOtherBnodeValue;
    @Mock
    private NodeType mockNodeType;
    @Mock
    private Workspace mockWorkspace;
    @Mock
    private NamespaceRegistry mockNamespaceRegistry;
    @Mock
    private PropertyDefinition mockPropertyDefinition;
    private RdfStream testObj;
    private DefaultIdentifierTranslator subjects;

    @Before
    public void setUp() throws RepositoryException {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.mockResource.getNode()).thenReturn((Object)this.mockNode);
        Mockito.when((Object)this.mockResource.getPath()).thenReturn((Object)"/x");
        Mockito.when((Object)this.mockNode.getSession()).thenReturn((Object)this.mockSession);
        Mockito.when((Object)this.mockBlankNode.getSession()).thenReturn((Object)this.mockSession);
        Mockito.when((Object)this.mockOtherNode.getSession()).thenReturn((Object)this.mockSession);
        Mockito.when((Object)this.mockNestedBlankNode.getSession()).thenReturn((Object)this.mockSession);
        Mockito.when((Object)this.mockProperty.getType()).thenReturn((Object)2);
        Mockito.when((Object)this.mockBnodeReferenceProperty.getType()).thenReturn((Object)9);
        Mockito.when((Object)this.mockBnodeReferenceProperty.getName()).thenReturn((Object)"some:property");
        Mockito.when((Object)this.mockBnodeReferenceProperty.getValue()).thenReturn((Object)this.mockBnodeValue);
        Mockito.when((Object)this.mockBnodeReferenceProperty.getDefinition()).thenReturn((Object)this.mockPropertyDefinition);
        Mockito.when((Object)this.mockBnodeValue.getString()).thenReturn((Object)"xxxx");
        Mockito.when((Object)this.mockSession.getNodeByIdentifier("xxxx")).thenReturn((Object)this.mockBlankNode);
        Mockito.when((Object)this.mockBlankNode.isNodeType("fedora:Blanknode")).thenReturn((Object)true);
        Mockito.when((Object)this.mockBlankNode.getPath()).thenReturn((Object)"/.well-known/gen/xxxx");
        Mockito.when((Object)this.mockBlankNode.getPrimaryNodeType()).thenReturn((Object)this.mockNodeType);
        Mockito.when((Object)this.mockOtherBnodeReferenceProperty.getType()).thenReturn((Object)9);
        Mockito.when((Object)this.mockOtherBnodeReferenceProperty.getName()).thenReturn((Object)"some:property");
        Mockito.when((Object)this.mockOtherBnodeReferenceProperty.getValue()).thenReturn((Object)this.mockOtherBnodeValue);
        Mockito.when((Object)this.mockOtherBnodeValue.getType()).thenReturn((Object)9);
        Mockito.when((Object)this.mockOtherBnodeReferenceProperty.getDefinition()).thenReturn((Object)this.mockPropertyDefinition);
        Mockito.when((Object)this.mockOtherBnodeValue.getString()).thenReturn((Object)"yyyy");
        Mockito.when((Object)this.mockSession.getNodeByIdentifier("yyyy")).thenReturn((Object)this.mockNestedBlankNode);
        Mockito.when((Object)this.mockNestedBlankNode.isNodeType("fedora:Blanknode")).thenReturn((Object)true);
        Mockito.when((Object)this.mockNestedBlankNode.getPath()).thenReturn((Object)"/.well-known/gen/yyyy");
        Mockito.when((Object)this.mockNestedBlankNode.getPrimaryNodeType()).thenReturn((Object)this.mockNodeType);
        Mockito.when((Object)this.mockNodeType.getName()).thenReturn((Object)"some:type");
        Mockito.when((Object)this.mockSession.getWorkspace()).thenReturn((Object)this.mockWorkspace);
        Mockito.when((Object)this.mockWorkspace.getNamespaceRegistry()).thenReturn((Object)this.mockNamespaceRegistry);
        Mockito.when((Object)this.mockNamespaceRegistry.getURI("some")).thenReturn((Object)"info:some#");
        Mockito.when((Object)this.mockReferenceProperty.getType()).thenReturn((Object)9);
        Mockito.when((Object)this.mockReferenceProperty.getValue()).thenReturn((Object)this.mockReferenceValue);
        Mockito.when((Object)this.mockReferenceValue.getString()).thenReturn((Object)"zzzz");
        Mockito.when((Object)this.mockSession.getNodeByIdentifier("zzzz")).thenReturn((Object)this.mockOtherNode);
        this.subjects = new DefaultIdentifierTranslator(this.mockSession);
    }

    @Test
    public void testWithoutProperties() throws RepositoryException {
        Mockito.when((Object)this.mockNode.getProperties()).thenReturn((Object)new TestPropertyIterator(new Property[0]));
        this.testObj = new BlankNodeRdfContext(this.mockResource, (IdentifierConverter)this.subjects);
        Assert.assertTrue((String)"Expected no triples", (boolean)this.testObj.asModel().isEmpty());
    }

    @Test
    public void testWithoutReferenceProperties() throws RepositoryException {
        Mockito.when((Object)this.mockNode.getProperties()).thenReturn((Object)new TestPropertyIterator(this.mockProperty));
        this.testObj = new BlankNodeRdfContext(this.mockResource, (IdentifierConverter)this.subjects);
        Assert.assertTrue((String)"Expected no triples", (boolean)this.testObj.asModel().isEmpty());
    }

    @Test
    public void testWithoutBlanknodeReferences() throws RepositoryException {
        Mockito.when((Object)this.mockNode.getProperties()).thenReturn((Object)new TestPropertyIterator(this.mockReferenceProperty));
        this.testObj = new BlankNodeRdfContext(this.mockResource, (IdentifierConverter)this.subjects);
        Assert.assertTrue((String)"Expected no triples", (boolean)this.testObj.asModel().isEmpty());
    }

    @Test
    public void testWithBlanknode() throws RepositoryException {
        Mockito.when((Object)this.mockBlankNode.getProperties()).thenReturn((Object)new TestPropertyIterator(new Property[0]));
        Mockito.when((Object)this.mockNode.getProperties()).thenAnswer((Answer)new Answer<TestPropertyIterator>(){

            public TestPropertyIterator answer(InvocationOnMock invocationOnMock) {
                return new TestPropertyIterator(BlankNodeRdfContextTest.this.mockBnodeReferenceProperty);
            }
        });
        this.testObj = new BlankNodeRdfContext(this.mockResource, (IdentifierConverter)this.subjects);
        Model actual = this.testObj.asModel();
        Assert.assertTrue((boolean)actual.contains(this.subjects.toDomain("/.well-known/gen/xxxx"), RDF.type, (RDFNode)ResourceFactory.createResource((String)"info:some#type")));
    }

    @Test
    public void testWithNestedBlanknodes() throws RepositoryException {
        Mockito.when((Object)this.mockNode.getProperties()).thenAnswer((Answer)new Answer<TestPropertyIterator>(){

            public TestPropertyIterator answer(InvocationOnMock invocationOnMock) {
                return new TestPropertyIterator(BlankNodeRdfContextTest.this.mockBnodeReferenceProperty);
            }
        });
        Mockito.when((Object)this.mockBnodeReferenceProperty.getParent()).thenReturn((Object)this.mockNode);
        Mockito.when((Object)this.mockBlankNode.getProperties()).thenAnswer((Answer)new Answer<TestPropertyIterator>(){

            public TestPropertyIterator answer(InvocationOnMock invocationOnMock) {
                return new TestPropertyIterator(BlankNodeRdfContextTest.this.mockOtherBnodeReferenceProperty);
            }
        });
        Mockito.when((Object)this.mockOtherBnodeReferenceProperty.getParent()).thenReturn((Object)this.mockBlankNode);
        Mockito.when((Object)this.mockNestedBlankNode.getProperties()).thenReturn((Object)new TestPropertyIterator(new Property[0]));
        this.testObj = new BlankNodeRdfContext(this.mockResource, (IdentifierConverter)this.subjects);
        Model actual = this.testObj.asModel();
        Assert.assertTrue((boolean)actual.contains(this.subjects.toDomain("/.well-known/gen/xxxx"), RDF.type, (RDFNode)ResourceFactory.createResource((String)"info:some#type")));
        Assert.assertTrue((boolean)actual.contains(this.subjects.toDomain("/.well-known/gen/xxxx"), ResourceFactory.createProperty((String)"some:property"), (RDFNode)this.subjects.toDomain("/.well-known/gen/yyyy")));
        Assert.assertTrue((boolean)actual.contains(this.subjects.toDomain("/.well-known/gen/yyyy"), RDF.type, (RDFNode)ResourceFactory.createResource((String)"info:some#type")));
    }
}

