/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.rdf.impl;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import javax.jcr.NamespaceRegistry;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.Workspace;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.PropertyDefinition;
import org.fcrepo.kernel.identifiers.IdentifierConverter;
import org.fcrepo.kernel.impl.rdf.impl.DefaultIdentifierTranslator;
import org.fcrepo.kernel.impl.rdf.impl.HashRdfContext;
import org.fcrepo.kernel.impl.testutilities.TestNodeIterator;
import org.fcrepo.kernel.impl.testutilities.TestPropertyIterator;
import org.fcrepo.kernel.models.FedoraResource;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class HashRdfContextTest {
    @Mock
    private FedoraResource mockResource;
    @Mock
    private Node mockNode;
    @Mock
    private Session mockSession;
    private DefaultIdentifierTranslator subjects;
    @Mock
    private Node mockChildNode;
    @Mock
    private Node mockContainer;
    @Mock
    private Property mockProperty;
    @Mock
    private PropertyDefinition mockPropertyDefinition;
    @Mock
    private Value mockValue;
    @Mock
    private NodeType mockNodeType;
    @Mock
    private Workspace mockWorkspace;
    @Mock
    private NamespaceRegistry mockNamespaceRegistry;

    @Before
    public void setUp() throws RepositoryException {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.mockResource.getPath()).thenReturn((Object)"/a");
        Mockito.when((Object)this.mockResource.getNode()).thenReturn((Object)this.mockNode);
        Mockito.when((Object)this.mockNode.getNode("#")).thenReturn((Object)this.mockContainer);
        Mockito.when((Object)this.mockNode.getSession()).thenReturn((Object)this.mockSession);
        Mockito.when((Object)this.mockChildNode.getSession()).thenReturn((Object)this.mockSession);
        Mockito.when((Object)this.mockNodeType.getName()).thenReturn((Object)"some:type");
        Mockito.when((Object)this.mockSession.getWorkspace()).thenReturn((Object)this.mockWorkspace);
        Mockito.when((Object)this.mockWorkspace.getNamespaceRegistry()).thenReturn((Object)this.mockNamespaceRegistry);
        this.subjects = new DefaultIdentifierTranslator(this.mockSession);
    }

    @Test
    public void testHashContextWithNoHashChildren() throws RepositoryException {
        Mockito.when((Object)this.mockNode.hasNode("#")).thenReturn((Object)false);
        Model actual = new HashRdfContext(this.mockResource, (IdentifierConverter)this.subjects).asModel();
        Assert.assertTrue((String)"Expected the result to be empty", (boolean)actual.isEmpty());
    }

    @Test
    public void testHashContextWithHashChildren() throws RepositoryException {
        Mockito.when((Object)this.mockNode.hasNode("#")).thenReturn((Object)true);
        Mockito.when((Object)this.mockContainer.getNodes()).thenReturn((Object)TestNodeIterator.nodeIterator(this.mockChildNode));
        Mockito.when((Object)this.mockChildNode.getPath()).thenReturn((Object)"/a/#/123");
        Mockito.when((Object)this.mockChildNode.hasProperties()).thenReturn((Object)true);
        Mockito.when((Object)this.mockChildNode.getProperties()).thenAnswer((Answer)new Answer<PropertyIterator>(){

            public PropertyIterator answer(InvocationOnMock invocationOnMock) {
                return new TestPropertyIterator(HashRdfContextTest.this.mockProperty);
            }
        });
        Mockito.when((Object)this.mockChildNode.getPrimaryNodeType()).thenReturn((Object)this.mockNodeType);
        Mockito.when((Object)this.mockProperty.getParent()).thenReturn((Object)this.mockChildNode);
        Mockito.when((Object)this.mockProperty.getType()).thenReturn((Object)1);
        Mockito.when((Object)this.mockProperty.getDefinition()).thenReturn((Object)this.mockPropertyDefinition);
        Mockito.when((Object)this.mockProperty.isMultiple()).thenReturn((Object)false);
        Mockito.when((Object)this.mockProperty.getName()).thenReturn((Object)"info:y");
        Mockito.when((Object)this.mockProperty.getValue()).thenReturn((Object)this.mockValue);
        Mockito.when((Object)this.mockValue.getString()).thenReturn((Object)"x");
        Model actual = new HashRdfContext(this.mockResource, (IdentifierConverter)this.subjects).asModel();
        Assert.assertFalse((String)"Expected the result to not be empty", (boolean)actual.isEmpty());
        Assert.assertTrue((String)"Expected to find child properties", (boolean)actual.contains(ResourceFactory.createResource((String)"info:fedora/a#123"), ResourceFactory.createProperty((String)"info:y"), (RDFNode)ResourceFactory.createPlainLiteral((String)"x")));
    }
}

