/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.rdf.impl;

import com.google.common.base.Converter;
import com.google.common.collect.Iterators;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.Workspace;
import org.fcrepo.kernel.identifiers.IdentifierConverter;
import org.fcrepo.kernel.impl.identifiers.NodeResourceConverter;
import org.fcrepo.kernel.impl.rdf.impl.DefaultIdentifierTranslator;
import org.fcrepo.kernel.impl.rdf.impl.LdpContainerRdfContext;
import org.fcrepo.kernel.impl.testutilities.TestNodeIterator;
import org.fcrepo.kernel.impl.testutilities.TestPropertyIterator;
import org.fcrepo.kernel.models.FedoraResource;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.modeshape.jcr.api.NamespaceRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdpContainerRdfContextTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(LdpContainerRdfContextTest.class);
    @Mock
    private FedoraResource mockResource;
    @Mock
    private Node mockContainerNode;
    @Mock
    private Node mockChild;
    @Mock
    private Node mockNode;
    @Mock
    private PropertyIterator mockReferences;
    @Mock
    private Property mockProperty;
    @Mock
    private Property mockInsertedContentRelationProperty;
    @Mock
    private Property mockRelationProperty;
    @Mock
    private Value mockRelationValue;
    @Mock
    private Session mockSession;
    @Mock
    private Workspace mockWorkspace;
    @Mock
    private NamespaceRegistry mockNamespaceRegistry;
    private DefaultIdentifierTranslator subjects;
    private LdpContainerRdfContext testObj;

    @Before
    public void setUp() throws RepositoryException {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.mockNode.getSession()).thenReturn((Object)this.mockSession);
        Mockito.when((Object)this.mockResource.getPath()).thenReturn((Object)"/a");
        Mockito.when((Object)this.mockResource.getNode()).thenReturn((Object)this.mockNode);
        Mockito.when((Object)this.mockSession.getWorkspace()).thenReturn((Object)this.mockWorkspace);
        Mockito.when((Object)this.mockWorkspace.getNamespaceRegistry()).thenReturn((Object)this.mockNamespaceRegistry);
        this.subjects = new DefaultIdentifierTranslator(this.mockSession);
    }

    @Test
    public void testLdpResource() throws RepositoryException {
        Mockito.when((Object)this.mockReferences.hasNext()).thenReturn((Object)false);
        Mockito.when((Object)this.mockNode.getReferences("ldp:membershipResource")).thenReturn((Object)this.mockReferences);
        this.testObj = new LdpContainerRdfContext(this.mockResource, (IdentifierConverter)this.subjects);
        Model model = this.testObj.asModel();
        Assert.assertTrue((String)"Expected stream to be empty", (boolean)model.isEmpty());
    }

    @Test
    public void testLdpResourceWithEmptyContainer() throws RepositoryException {
        Mockito.when((Object)this.mockNode.getReferences("ldp:membershipResource")).thenReturn((Object)new TestPropertyIterator(this.mockProperty));
        Mockito.when((Object)this.mockProperty.getParent()).thenReturn((Object)this.mockContainerNode);
        Mockito.when((Object)this.mockContainerNode.getNodes()).thenReturn((Object)new TestNodeIterator(new Node[0]));
        this.testObj = new LdpContainerRdfContext(this.mockResource, (IdentifierConverter)this.subjects);
        Model model = this.testObj.asModel();
        Assert.assertTrue((String)"Expected stream to be empty", (boolean)model.isEmpty());
    }

    @Test
    public void testLdpResourceWithBasicContainer() throws RepositoryException {
        Mockito.when((Object)this.mockResource.hasType("ldp:BasicContainer")).thenReturn((Object)true);
        Mockito.when((Object)this.mockNode.getReferences("ldp:membershipResource")).thenReturn((Object)new TestPropertyIterator(new Property[0]));
        Mockito.when((Object)this.mockResource.getChildren()).thenReturn((Object)Iterators.singletonIterator((Object)this.mockResource));
        Mockito.when((Object)this.mockChild.getName()).thenReturn((Object)"b");
        Mockito.when((Object)this.mockChild.getPath()).thenReturn((Object)"/b");
        this.testObj = new LdpContainerRdfContext(this.mockResource, (IdentifierConverter)this.subjects);
        Model model = this.testObj.asModel();
        Assert.assertTrue((String)"Expected stream to be empty", (boolean)model.isEmpty());
    }

    @Test
    public void testLdpResourceWithDirectContainerWithoutRelation() throws RepositoryException {
        Mockito.when((Object)this.mockContainerNode.isNodeType("ldp:DirectContainer")).thenReturn((Object)true);
        Mockito.when((Object)this.mockNode.getReferences("ldp:membershipResource")).thenReturn((Object)new TestPropertyIterator(this.mockProperty));
        Mockito.when((Object)this.mockProperty.getParent()).thenReturn((Object)this.mockContainerNode);
        Mockito.when((Object)this.mockContainerNode.getNodes()).thenReturn((Object)new TestNodeIterator(this.mockChild));
        Mockito.when((Object)this.mockChild.getName()).thenReturn((Object)"b");
        Mockito.when((Object)this.mockChild.getPath()).thenReturn((Object)"/b");
        this.testObj = new LdpContainerRdfContext(this.mockResource, (IdentifierConverter)this.subjects);
        Model model = this.testObj.asModel();
        Assert.assertTrue((String)"Expected stream to be empty", (boolean)model.isEmpty());
    }

    @Test
    public void testLdpResourceWithDirectContainerAssertingRelation() throws RepositoryException {
        Mockito.when((Object)this.mockNode.getReferences("ldp:membershipResource")).thenReturn((Object)new TestPropertyIterator(this.mockProperty));
        Mockito.when((Object)this.mockProperty.getParent()).thenReturn((Object)this.mockContainerNode);
        Mockito.when((Object)this.mockContainerNode.isNodeType("ldp:DirectContainer")).thenReturn((Object)true);
        Mockito.when((Object)this.mockContainerNode.getNodes()).thenReturn((Object)new TestNodeIterator(this.mockChild));
        Mockito.when((Object)this.mockChild.getPath()).thenReturn((Object)"/b");
        Mockito.when((Object)this.mockChild.getName()).thenReturn((Object)"b");
        Property mockRelation = (Property)Mockito.mock(Property.class);
        Mockito.when((Object)mockRelation.getString()).thenReturn((Object)"some:property");
        Mockito.when((Object)this.mockContainerNode.hasProperty("ldp:hasMemberRelation")).thenReturn((Object)true);
        Mockito.when((Object)this.mockContainerNode.getProperty("ldp:hasMemberRelation")).thenReturn((Object)mockRelation);
        this.testObj = new LdpContainerRdfContext(this.mockResource, (IdentifierConverter)this.subjects);
        Model model = this.testObj.asModel();
        Assert.assertTrue((String)"Expected stream to have one triple", (model.size() == 1L ? 1 : 0) != 0);
        Assert.assertTrue((boolean)model.contains((Resource)this.subjects.reverse().convert((Object)this.mockResource), ResourceFactory.createProperty((String)"some:property"), (RDFNode)NodeResourceConverter.nodeToResource((Converter)this.subjects).convert((Object)this.mockChild)));
    }

    @Test
    public void testLdpResourceWithIndirectContainerAssertingRelation() throws RepositoryException {
        Mockito.when((Object)this.mockNode.getReferences("ldp:membershipResource")).thenReturn((Object)new TestPropertyIterator(this.mockProperty));
        Mockito.when((Object)this.mockProperty.getParent()).thenReturn((Object)this.mockContainerNode);
        Mockito.when((Object)this.mockContainerNode.getSession()).thenReturn((Object)this.mockSession);
        Mockito.when((Object)this.mockContainerNode.isNodeType("ldp:IndirectContainer")).thenReturn((Object)true);
        Mockito.when((Object)this.mockContainerNode.hasProperty("ldp:insertedContentRelation")).thenReturn((Object)true);
        Mockito.when((Object)this.mockContainerNode.getProperty("ldp:insertedContentRelation")).thenReturn((Object)this.mockInsertedContentRelationProperty);
        Mockito.when((Object)this.mockInsertedContentRelationProperty.getString()).thenReturn((Object)"some:relation");
        Mockito.when((Object)this.mockNamespaceRegistry.isRegisteredUri("some:")).thenReturn((Object)true);
        Mockito.when((Object)this.mockNamespaceRegistry.getPrefix("some:")).thenReturn((Object)"some");
        Mockito.when((Object)this.mockContainerNode.getNodes()).thenReturn((Object)new TestNodeIterator(this.mockChild));
        Mockito.when((Object)this.mockChild.getPath()).thenReturn((Object)"/b");
        Mockito.when((Object)this.mockChild.getName()).thenReturn((Object)"b");
        Mockito.when((Object)this.mockChild.hasProperty("some:relation")).thenReturn((Object)true);
        Mockito.when((Object)this.mockChild.getProperty("some:relation")).thenReturn((Object)this.mockRelationProperty);
        Mockito.when((Object)this.mockRelationProperty.isMultiple()).thenReturn((Object)false);
        Mockito.when((Object)this.mockRelationProperty.getValue()).thenReturn((Object)this.mockRelationValue);
        Mockito.when((Object)this.mockRelationValue.getString()).thenReturn((Object)"x");
        Property mockRelation = (Property)Mockito.mock(Property.class);
        Mockito.when((Object)mockRelation.getString()).thenReturn((Object)"some:property");
        Mockito.when((Object)this.mockContainerNode.hasProperty("ldp:hasMemberRelation")).thenReturn((Object)true);
        Mockito.when((Object)this.mockContainerNode.getProperty("ldp:hasMemberRelation")).thenReturn((Object)mockRelation);
        this.testObj = new LdpContainerRdfContext(this.mockResource, (IdentifierConverter)this.subjects);
        Model model = this.testObj.asModel();
        Assert.assertTrue((String)"Expected stream to have one triple", (model.size() == 1L ? 1 : 0) != 0);
        Assert.assertTrue((boolean)model.contains((Resource)this.subjects.reverse().convert((Object)this.mockResource), ResourceFactory.createProperty((String)"some:property"), (RDFNode)ResourceFactory.createPlainLiteral((String)"x")));
    }

    @Test
    public void testLdpResourceWithIndirectContainerWithoutRelation() throws RepositoryException {
        Mockito.when((Object)this.mockNode.getReferences("ldp:membershipResource")).thenReturn((Object)new TestPropertyIterator(this.mockProperty));
        Mockito.when((Object)this.mockProperty.getParent()).thenReturn((Object)this.mockContainerNode);
        Mockito.when((Object)this.mockContainerNode.getSession()).thenReturn((Object)this.mockSession);
        Mockito.when((Object)this.mockContainerNode.isNodeType("ldp:IndirectContainer")).thenReturn((Object)true);
        Mockito.when((Object)this.mockContainerNode.hasProperty("ldp:insertedContentRelation")).thenReturn((Object)true);
        Mockito.when((Object)this.mockContainerNode.getProperty("ldp:insertedContentRelation")).thenReturn((Object)this.mockInsertedContentRelationProperty);
        Mockito.when((Object)this.mockInsertedContentRelationProperty.getString()).thenReturn((Object)"some:relation");
        Mockito.when((Object)this.mockNamespaceRegistry.isRegisteredUri("some:")).thenReturn((Object)true);
        Mockito.when((Object)this.mockNamespaceRegistry.getPrefix("some:")).thenReturn((Object)"some");
        Mockito.when((Object)this.mockContainerNode.getNodes()).thenReturn((Object)new TestNodeIterator(this.mockChild));
        Mockito.when((Object)this.mockChild.getPath()).thenReturn((Object)"/b");
        Mockito.when((Object)this.mockChild.getName()).thenReturn((Object)"b");
        Mockito.when((Object)this.mockChild.hasProperty("some:relation")).thenReturn((Object)false);
        Property mockRelation = (Property)Mockito.mock(Property.class);
        Mockito.when((Object)mockRelation.getString()).thenReturn((Object)"some:property");
        Mockito.when((Object)this.mockContainerNode.hasProperty("ldp:hasMemberRelation")).thenReturn((Object)true);
        Mockito.when((Object)this.mockContainerNode.getProperty("ldp:hasMemberRelation")).thenReturn((Object)mockRelation);
        this.testObj = new LdpContainerRdfContext(this.mockResource, (IdentifierConverter)this.subjects);
        Model model = this.testObj.asModel();
        Assert.assertTrue((String)"Expected stream to be empty", (boolean)model.isEmpty());
    }

    @Test
    public void testLdpResourceWithIndirectContainerWithoutInsertedContentRelation() throws RepositoryException {
        Mockito.when((Object)this.mockNode.getReferences("ldp:membershipResource")).thenReturn((Object)new TestPropertyIterator(this.mockProperty));
        Mockito.when((Object)this.mockProperty.getParent()).thenReturn((Object)this.mockContainerNode);
        Mockito.when((Object)this.mockContainerNode.getSession()).thenReturn((Object)this.mockSession);
        Mockito.when((Object)this.mockContainerNode.isNodeType("ldp:IndirectContainer")).thenReturn((Object)true);
        Mockito.when((Object)this.mockContainerNode.hasProperty("ldp:insertedContentRelation")).thenReturn((Object)false);
        Mockito.when((Object)this.mockContainerNode.getNodes()).thenReturn((Object)new TestNodeIterator(this.mockChild));
        Property mockRelation = (Property)Mockito.mock(Property.class);
        Mockito.when((Object)mockRelation.getString()).thenReturn((Object)"some:property");
        Mockito.when((Object)this.mockContainerNode.hasProperty("ldp:hasMemberRelation")).thenReturn((Object)true);
        Mockito.when((Object)this.mockContainerNode.getProperty("ldp:hasMemberRelation")).thenReturn((Object)mockRelation);
        this.testObj = new LdpContainerRdfContext(this.mockResource, (IdentifierConverter)this.subjects);
        Model model = this.testObj.asModel();
        Assert.assertTrue((String)"Expected stream to be empty", (boolean)model.isEmpty());
    }
}

