/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.rdf.impl;

import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.List;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.ItemDefinition;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeIterator;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.nodetype.PropertyDefinition;
import org.fcrepo.kernel.impl.rdf.impl.NodeTypeRdfContext;
import org.fcrepo.kernel.impl.rdf.impl.mappings.ItemDefinitionToTriples;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.modeshape.jcr.api.Namespaced;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeTypeRdfContextTest {
    @Mock
    private NamespacedNodeType mockNodeType;
    @Mock
    private NamespacedNodeType mockNodeTypeA;
    @Mock
    private NamespacedNodeType mockNodeTypeB;
    private static final String mockNodeTypePrefix = "jcr";
    private static final String mockNodeTypeName = "someType";
    private static final String jcrNamespace = "http://www.jcp.org/jcr/1.0";
    @Mock
    private NamespacedPropertyDefinition mockProperty;
    @Mock
    private NamespacedNodeDefinition mockNodeDefinitionA;
    @Mock
    private NamespacedNodeDefinition mockNodeDefinitionB;
    private static final Logger LOGGER = LoggerFactory.getLogger(NodeTypeRdfContextTest.class);

    @Before
    public void setUp() throws RepositoryException {
        MockitoAnnotations.initMocks((Object)this);
        NodeTypeRdfContextTest.initNodeTypeMocks(this.mockNodeType, jcrNamespace, mockNodeTypeName);
        Mockito.when((Object)this.mockNodeType.getName()).thenReturn((Object)"jcr:someType");
        Mockito.when((Object)this.mockProperty.getName()).thenReturn((Object)"a:a");
        Mockito.when((Object)this.mockProperty.getNamespaceURI()).thenReturn((Object)"a#");
        Mockito.when((Object)this.mockProperty.getLocalName()).thenReturn((Object)"a");
        Mockito.when((Object)this.mockNodeTypeB.getName()).thenReturn((Object)"b:b");
        NodeTypeRdfContextTest.initNodeTypeMocks(this.mockNodeTypeB, "b#", "b");
        Mockito.when((Object)this.mockNodeTypeA.getName()).thenReturn((Object)"a:a");
        NodeTypeRdfContextTest.initNodeTypeMocks(this.mockNodeTypeA, "a#", "a");
        NodeTypeRdfContextTest.initNamespacedMocks(this.mockNodeDefinitionA, "a#", "a");
        Mockito.when((Object)this.mockNodeDefinitionA.getName()).thenReturn((Object)"a:a");
        NodeTypeRdfContextTest.initNamespacedMocks(this.mockNodeDefinitionB, "b#", "b");
        Mockito.when((Object)this.mockNodeDefinitionB.getName()).thenReturn((Object)"b:b");
        Mockito.when((Object)this.mockNodeDefinitionA.getRequiredPrimaryTypes()).thenReturn((Object)new NodeType[0]);
        Mockito.when((Object)this.mockNodeDefinitionB.getRequiredPrimaryTypes()).thenReturn((Object)new NodeType[0]);
    }

    @Test
    public void testShouldMapASimpleNodeTypeToRdf() throws RepositoryException {
        Model actual = new NodeTypeRdfContext((NodeType)this.mockNodeType).asModel();
        Assert.assertTrue((boolean)actual.contains(ResourceFactory.createResource((String)"http://fedora.info/definitions/v4/repository#someType"), RDF.type, (RDFNode)RDFS.Class));
        Assert.assertTrue((boolean)actual.contains(ResourceFactory.createResource((String)"http://fedora.info/definitions/v4/repository#someType"), RDFS.label, "jcr:someType"));
    }

    @Test
    public void testShouldMapNodeTypeIteratorToRdf() throws RepositoryException {
        List<NamespacedNodeType> mockNodeTypeList = Collections.singletonList(this.mockNodeType);
        Model actual = new NodeTypeRdfContext(mockNodeTypeList.iterator()).asModel();
        Assert.assertTrue((boolean)actual.contains(ResourceFactory.createResource((String)"http://fedora.info/definitions/v4/repository#someType"), RDF.type, (RDFNode)RDFS.Class));
    }

    @Test
    public void testShouldMapNodeTypeManagerToRdf() throws RepositoryException {
        NodeTypeManager mockNodeTypeManager = (NodeTypeManager)Mockito.mock(NodeTypeManager.class);
        NodeTypeIterator mockNodeTypeIterator = (NodeTypeIterator)Mockito.mock(NodeTypeIterator.class);
        Mockito.when((Object)mockNodeTypeIterator.next()).thenReturn((Object)this.mockNodeType);
        Mockito.when((Object)mockNodeTypeIterator.hasNext()).thenReturn((Object)true, (Object[])new Boolean[]{false});
        Mockito.when((Object)mockNodeTypeManager.getPrimaryNodeTypes()).thenReturn((Object)mockNodeTypeIterator);
        NodeTypeIterator mockMixinTypeIterator = (NodeTypeIterator)Mockito.mock(NodeTypeIterator.class);
        Mockito.when((Object)mockMixinTypeIterator.next()).thenReturn((Object)this.mockNodeTypeB);
        Mockito.when((Object)mockMixinTypeIterator.hasNext()).thenReturn((Object)true, (Object[])new Boolean[]{false});
        Mockito.when((Object)mockNodeTypeManager.getMixinNodeTypes()).thenReturn((Object)mockMixinTypeIterator);
        Model actual = new NodeTypeRdfContext(mockNodeTypeManager).asModel();
        Assert.assertTrue((boolean)actual.contains(ResourceFactory.createResource((String)"http://fedora.info/definitions/v4/repository#someType"), RDF.type, (RDFNode)RDFS.Class));
        Assert.assertTrue((boolean)actual.contains(ResourceFactory.createResource((String)"b#b"), RDF.type, (RDFNode)RDFS.Class));
    }

    @Test
    public void testShouldIncludeSupertypeInformation() throws RepositoryException {
        Mockito.when((Object)this.mockNodeType.getDeclaredSupertypes()).thenReturn((Object)new NodeType[]{this.mockNodeTypeA, this.mockNodeTypeB});
        Model actual = new NodeTypeRdfContext((NodeType)this.mockNodeType).asModel();
        Assert.assertTrue((boolean)actual.contains(ItemDefinitionToTriples.getResource((NodeType)this.mockNodeType), RDFS.subClassOf, (RDFNode)ItemDefinitionToTriples.getResource((NodeType)this.mockNodeTypeA)));
        Assert.assertTrue((boolean)actual.contains(ItemDefinitionToTriples.getResource((NodeType)this.mockNodeType), RDFS.subClassOf, (RDFNode)ItemDefinitionToTriples.getResource((NodeType)this.mockNodeTypeB)));
    }

    @Test
    public void testShouldIncludeChildNodeDefinitions() throws RepositoryException {
        Mockito.when((Object)this.mockNodeType.getDeclaredChildNodeDefinitions()).thenReturn((Object)new NodeDefinition[]{this.mockNodeDefinitionA, this.mockNodeDefinitionB});
        Model actual = new NodeTypeRdfContext((NodeType)this.mockNodeType).asModel();
        Assert.assertTrue((boolean)actual.contains(ItemDefinitionToTriples.getResource((ItemDefinition)this.mockNodeDefinitionA), RDFS.domain, (RDFNode)ItemDefinitionToTriples.getResource((NodeType)this.mockNodeType)));
        Assert.assertTrue((boolean)actual.contains(ItemDefinitionToTriples.getResource((ItemDefinition)this.mockNodeDefinitionB), RDFS.domain, (RDFNode)ItemDefinitionToTriples.getResource((NodeType)this.mockNodeType)));
    }

    @Test
    public void testShouldIncludeChildNodeRangeWhenTheChildNodeDeclaresRequiredType() throws RepositoryException {
        Mockito.when((Object)this.mockNodeDefinitionA.getRequiredPrimaryTypes()).thenReturn((Object)new NodeType[]{this.mockNodeTypeB});
        Mockito.when((Object)this.mockNodeType.getDeclaredChildNodeDefinitions()).thenReturn((Object)new NodeDefinition[]{this.mockNodeDefinitionA});
        Model actual = new NodeTypeRdfContext((NodeType)this.mockNodeType).asModel();
        Assert.assertTrue((boolean)actual.contains(ItemDefinitionToTriples.getResource((ItemDefinition)this.mockNodeDefinitionA), RDFS.domain, (RDFNode)ItemDefinitionToTriples.getResource((NodeType)this.mockNodeType)));
        Assert.assertTrue((boolean)actual.contains(ItemDefinitionToTriples.getResource((ItemDefinition)this.mockNodeDefinitionA), RDFS.range, (RDFNode)ItemDefinitionToTriples.getResource((NodeType)this.mockNodeTypeB)));
    }

    @Test
    public void testShouldSkipChildNodesAsResidualSet() throws RepositoryException, IOException {
        Mockito.when((Object)this.mockNodeDefinitionA.getName()).thenReturn((Object)"*");
        Mockito.when((Object)this.mockNodeType.getDeclaredChildNodeDefinitions()).thenReturn((Object)new NodeDefinition[]{this.mockNodeDefinitionA});
        Model actual = new NodeTypeRdfContext((NodeType)this.mockNodeType).asModel();
        NodeTypeRdfContextTest.logRdf("Retrieved RDF for testShouldSkipChildNodesAsResidualSet():", actual);
        Assert.assertFalse((boolean)actual.listResourcesWithProperty(RDFS.domain, (RDFNode)ItemDefinitionToTriples.getResource((NodeType)this.mockNodeType)).hasNext());
    }

    @Test
    public void testShouldIncludePropertyDefinitions() throws RepositoryException {
        Mockito.when((Object)this.mockNodeType.getDeclaredPropertyDefinitions()).thenReturn((Object)new PropertyDefinition[]{this.mockProperty});
        Model actual = new NodeTypeRdfContext((NodeType)this.mockNodeType).asModel();
        Assert.assertTrue((boolean)actual.contains(ItemDefinitionToTriples.getResource((ItemDefinition)this.mockProperty), RDFS.domain, (RDFNode)ItemDefinitionToTriples.getResource((NodeType)this.mockNodeType)));
    }

    @Test
    public void testShouldIncludePropertyDefinitionsRequiredTypeAsRange() throws RepositoryException {
        Mockito.when((Object)this.mockProperty.getRequiredType()).thenReturn((Object)9);
        Mockito.when((Object)this.mockNodeType.getDeclaredPropertyDefinitions()).thenReturn((Object)new PropertyDefinition[]{this.mockProperty});
        Model actual = new NodeTypeRdfContext((NodeType)this.mockNodeType).asModel();
        Assert.assertTrue((boolean)actual.contains(ItemDefinitionToTriples.getResource((ItemDefinition)this.mockProperty), RDFS.domain, (RDFNode)ItemDefinitionToTriples.getResource((NodeType)this.mockNodeType)));
        Assert.assertTrue((boolean)actual.contains(ItemDefinitionToTriples.getResource((ItemDefinition)this.mockProperty), RDFS.range, (RDFNode)ResourceFactory.createResource((String)XSDDatatype.XSDanyURI.getURI())));
    }

    @Test
    public void testShouldExcludePropertyDefinitionsForResidualSets() throws RepositoryException {
        Mockito.when((Object)this.mockProperty.getName()).thenReturn((Object)"*");
        Mockito.when((Object)this.mockNodeType.getDeclaredPropertyDefinitions()).thenReturn((Object)new PropertyDefinition[]{this.mockProperty});
        Model actual = new NodeTypeRdfContext((NodeType)this.mockNodeType).asModel();
        Assert.assertFalse((boolean)actual.listResourcesWithProperty(RDFS.domain, (RDFNode)ItemDefinitionToTriples.getResource((NodeType)this.mockNodeType)).hasNext());
    }

    private static void initNodeTypeMocks(NodeType mockNodeType, String mockNamespaceUri, String mockNodeTypeName) throws RepositoryException {
        NodeTypeRdfContextTest.initNamespacedMocks((Namespaced)mockNodeType, mockNamespaceUri, mockNodeTypeName);
        Mockito.when((Object)mockNodeType.getDeclaredSupertypes()).thenReturn((Object)new NodeType[0]);
        Mockito.when((Object)mockNodeType.getDeclaredChildNodeDefinitions()).thenReturn((Object)new NodeDefinition[0]);
        Mockito.when((Object)mockNodeType.getDeclaredPropertyDefinitions()).thenReturn((Object)new PropertyDefinition[0]);
    }

    private static void initNamespacedMocks(Namespaced namedspacedObject, String mockNamespaceUri, String mockNodeTypeName) throws RepositoryException {
        Mockito.when((Object)namedspacedObject.getNamespaceURI()).thenReturn((Object)mockNamespaceUri);
        Mockito.when((Object)namedspacedObject.getLocalName()).thenReturn((Object)mockNodeTypeName);
    }

    private static void logRdf(String message, Model model) throws IOException {
        LOGGER.debug(message);
        try (StringWriter w = new StringWriter();){
            model.write((Writer)w);
            LOGGER.debug("\n" + ((Object)w).toString());
        }
    }

    private static interface NamespacedNodeDefinition
    extends Namespaced,
    NodeDefinition {
    }

    private static interface NamespacedPropertyDefinition
    extends Namespaced,
    PropertyDefinition {
    }

    private static interface NamespacedNodeType
    extends Namespaced,
    NodeType {
    }
}

