/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.services;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.fcrepo.kernel.impl.services.ExternalContentServiceImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class ExternalContentServiceImplTest {
    private ExternalContentServiceImpl testObj;
    @Mock
    private HttpClientConnectionManager mockClientPool;
    @Mock
    private CloseableHttpClient mockClient;
    private URI sourceUri;
    @Mock
    private CloseableHttpResponse mockResponse;
    @Mock
    private HttpEntity mockEntity;
    @Mock
    private InputStream mockInputStream;

    @Before
    public void setUp() throws URISyntaxException, IOException {
        MockitoAnnotations.initMocks((Object)this);
        this.sourceUri = new URI("http://localhost:8080/xyz");
        this.testObj = (ExternalContentServiceImpl)Mockito.spy((Object)new ExternalContentServiceImpl());
        this.testObj.setConnManager(this.mockClientPool);
        Mockito.when((Object)this.testObj.getCloseableHttpClient()).thenReturn((Object)this.mockClient);
        Mockito.when((Object)this.mockClient.execute((HttpUriRequest)Matchers.any(HttpGet.class))).thenReturn((Object)this.mockResponse);
        Mockito.when((Object)this.mockResponse.getEntity()).thenReturn((Object)this.mockEntity);
        Mockito.when((Object)this.mockEntity.getContent()).thenReturn((Object)this.mockInputStream);
    }

    @Test
    public void testRetrieveExternalContent() throws Exception {
        try (InputStream xyz = this.testObj.retrieveExternalContent(this.sourceUri);){
            Assert.assertEquals((Object)this.mockInputStream, (Object)xyz);
        }
    }
}

