/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.services.functions;

import java.lang.reflect.Field;
import java.util.Map;
import javax.jcr.Repository;
import org.fcrepo.kernel.impl.services.functions.GetClusterConfiguration;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ClusteringConfiguration;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.TransactionConfiguration;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.DefaultCacheManager;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.modeshape.jcr.GetBinaryStore;
import org.modeshape.jcr.JcrRepository;
import org.modeshape.jcr.RepositoryConfiguration;
import org.modeshape.jcr.value.binary.infinispan.InfinispanBinaryStore;

public class GetClusterConfigurationTest {
    private GetClusterConfiguration testObj;
    @Mock
    private GetBinaryStore mockGetBinaryStore;
    @Mock
    private RepositoryConfiguration mockConfig;
    @Mock
    private JcrRepository mockRepo;
    @Mock
    private RepositoryConfiguration.BinaryStorage mockStorage;
    @Mock
    private Cache<Object, Object> mockCache;
    @Mock
    private Configuration mockCC;
    @Mock
    private DefaultCacheManager mockCM;
    @Mock
    private ClusteringConfiguration mockClustering;
    @Mock
    private TransactionConfiguration mockTransactionConfiguration;
    @Mock
    private CacheContainer mockCacheContainer;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        this.testObj = new GetClusterConfiguration();
        Field field = GetClusterConfiguration.class.getDeclaredField("getBinaryStore");
        field.setAccessible(true);
        field.set(this.testObj, this.mockGetBinaryStore);
        Mockito.when((Object)this.mockRepo.getConfiguration()).thenReturn((Object)this.mockConfig);
        Mockito.when((Object)this.mockConfig.getBinaryStorage()).thenReturn((Object)this.mockStorage);
        Mockito.when((Object)this.mockCacheContainer.getCache((String)Matchers.any(String.class))).thenReturn(this.mockCache);
        Mockito.when((Object)this.mockCache.getCacheConfiguration()).thenReturn((Object)this.mockCC);
        Mockito.when((Object)this.mockCC.clustering()).thenReturn((Object)this.mockClustering);
        Mockito.when((Object)this.mockCC.transaction()).thenReturn((Object)this.mockTransactionConfiguration);
        Mockito.when((Object)this.mockCC.transaction().transactionMode()).thenReturn(null);
        Mockito.when((Object)this.mockClustering.cacheMode()).thenReturn((Object)CacheMode.LOCAL);
        Mockito.when((Object)this.mockCM.getCache()).thenReturn(this.mockCache);
        InfinispanBinaryStore mockStore = new InfinispanBinaryStore(this.mockCacheContainer, false, "x", "y");
        Mockito.when((Object)this.mockGetBinaryStore.apply((Repository)this.mockRepo)).thenReturn((Object)mockStore);
        mockStore.start();
    }

    @Test
    public void testGood() {
        Mockito.when((Object)this.mockCache.getCacheManager()).thenReturn((Object)this.mockCM);
        Map actual = this.testObj.apply((Repository)this.mockRepo);
        Assert.assertNotNull((Object)actual);
        Assert.assertFalse((boolean)actual.isEmpty());
    }

    @Test
    public void testBad() {
        Map actual = this.testObj.apply((Repository)this.mockRepo);
        Assert.assertTrue((boolean)actual.isEmpty());
    }
}

