/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.spring;

import java.util.ArrayList;
import org.fcrepo.kernel.impl.spring.ModeShapeRepositoryFactoryBean;
import org.fcrepo.kernel.impl.utils.TestHelpers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.modeshape.common.collection.Problems;
import org.modeshape.jcr.JcrRepository;
import org.modeshape.jcr.JcrSession;
import org.modeshape.jcr.ModeShapeEngine;
import org.modeshape.jcr.RepositoryConfiguration;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

public class ModeShapeRepositoryFactoryBeanTest {
    private ModeShapeRepositoryFactoryBean testObj;
    private Resource config = new ClassPathResource("config/testing/repository.json");
    @Mock
    private JcrRepository mockRepo;
    @Mock
    private ModeShapeEngine mockModeShapeEngine;
    @Mock
    private JcrSession mockSession;
    @Mock
    private Problems mockProblems;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.mockRepo.getStartupProblems()).thenReturn((Object)this.mockProblems);
        Mockito.when((Object)this.mockProblems.iterator()).thenReturn(new ArrayList().iterator());
        Mockito.when((Object)this.mockRepo.login()).thenReturn((Object)this.mockSession);
        this.testObj = new ModeShapeRepositoryFactoryBean();
        this.testObj.setRepositoryConfiguration(this.config);
        Mockito.when((Object)this.mockModeShapeEngine.deploy((RepositoryConfiguration)Matchers.any(RepositoryConfiguration.class))).thenReturn((Object)this.mockRepo);
        TestHelpers.setField(this.testObj, "modeShapeEngine", this.mockModeShapeEngine);
    }

    @Test
    public void testFactory() throws Exception {
        this.testObj.buildRepository();
        Assert.assertEquals((Object)this.mockRepo, (Object)this.testObj.getObject());
    }

    @Test
    public void testFactoryMetadata() {
        Assert.assertEquals(JcrRepository.class, (Object)this.testObj.getObjectType());
        Assert.assertEquals((Object)true, (Object)this.testObj.isSingleton());
    }
}

