/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.utils;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.jcr.Binary;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.fcrepo.kernel.utils.ContentDigest;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public abstract class TestHelpers {
    private static final SecureRandom GARBAGE_GENERATOR = new SecureRandom("G4RbAG3".getBytes());

    public static Node getContentNodeMock(Node mock, int size) {
        return TestHelpers.getContentNodeMock(mock, TestHelpers.randomData(size));
    }

    public static Node getContentNodeMock(Node mock, String content) {
        return TestHelpers.getContentNodeMock(mock, content.getBytes());
    }

    public static Node getContentNodeMock(Node mock, final byte[] content) {
        long size = content.length;
        String digest = TestHelpers.checksumString(content);
        String digestType = "SHA-1";
        Property mockFedoraSize = (Property)Mockito.mock(Property.class);
        Property mockProp = (Property)Mockito.mock(Property.class);
        Property mockDigest = (Property)Mockito.mock(Property.class);
        Property mockDigestType = (Property)Mockito.mock(Property.class);
        Property mockCreated = (Property)Mockito.mock(Property.class);
        Binary mockBin = (Binary)Mockito.mock(Binary.class);
        try {
            Mockito.when((Object)mockFedoraSize.getLong()).thenReturn((Object)size);
            Mockito.when((Object)mockBin.getSize()).thenReturn((Object)size);
            Mockito.when((Object)mockBin.getStream()).thenAnswer((Answer)new Answer<InputStream>(){

                public InputStream answer(InvocationOnMock inv) {
                    return new ByteArrayInputStream(content);
                }
            });
            Mockito.when((Object)mockProp.getBinary()).thenReturn((Object)mockBin);
            Mockito.when((Object)mockDigest.getString()).thenReturn((Object)digest);
            Mockito.when((Object)mockDigestType.getString()).thenReturn((Object)"SHA-1");
            Mockito.when((Object)mock.hasProperty("jcr:data")).thenReturn((Object)true);
            Mockito.when((Object)mock.hasProperty("premis:hasSize")).thenReturn((Object)true);
            Mockito.when((Object)mock.hasProperty("fedora:digest")).thenReturn((Object)true);
            Mockito.when((Object)mock.hasProperty("jcr:createdBy")).thenReturn((Object)true);
            Mockito.when((Object)mock.getProperty("jcr:data")).thenReturn((Object)mockProp);
            Mockito.when((Object)mock.getProperty("premis:hasSize")).thenReturn((Object)mockFedoraSize);
            Mockito.when((Object)mock.getProperty("fedora:digest")).thenReturn((Object)mockDigest);
            Mockito.when((Object)mock.getProperty("jcr:createdBy")).thenReturn((Object)mockCreated);
        }
        catch (RepositoryException e) {
            // empty catch block
        }
        return mock;
    }

    public static String checksumString(String content) {
        return TestHelpers.checksumString(content.getBytes());
    }

    public static String checksumString(byte[] content) {
        try {
            MessageDigest d = MessageDigest.getInstance("SHA-1");
            byte[] digest = d.digest(content);
            return ContentDigest.asURI((String)"SHA-1", (byte[])digest).toString();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static PropertyIterator getPropertyIterator(int numValues, long size) {
        PropertyIterator mock = (PropertyIterator)Mockito.mock(PropertyIterator.class);
        Property mockProp = (Property)Mockito.mock(Property.class);
        try {
            Mockito.when((Object)mockProp.isMultiple()).thenReturn((Object)(numValues > 1 ? 1 : 0));
            if (numValues != 1) {
                Value[] values = new Value[numValues];
                for (int i = 0; i < numValues; ++i) {
                    Value mockVal = (Value)Mockito.mock(Value.class);
                    Binary mockBin = (Binary)Mockito.mock(Binary.class);
                    Mockito.when((Object)mockVal.getBinary()).thenReturn((Object)mockBin);
                    Mockito.when((Object)mockBin.getSize()).thenReturn((Object)size);
                    values[i] = mockVal;
                }
                Mockito.when((Object)mockProp.getValues()).thenReturn((Object)values);
            } else {
                Binary mockBin = (Binary)Mockito.mock(Binary.class);
                Mockito.when((Object)mockBin.getSize()).thenReturn((Object)size);
                Mockito.when((Object)mockProp.getBinary()).thenReturn((Object)mockBin);
            }
        }
        catch (RepositoryException e) {
            // empty catch block
        }
        Mockito.when((Object)mock.getSize()).thenReturn((Object)1L);
        Mockito.when((Object)mock.hasNext()).thenReturn((Object)true, (Object[])new Boolean[]{false});
        Mockito.when((Object)mock.nextProperty()).thenReturn((Object)mockProp).thenThrow(new Class[]{IndexOutOfBoundsException.class});
        return mock;
    }

    public static byte[] randomData(int byteLength) {
        byte[] bytes = new byte[byteLength];
        GARBAGE_GENERATOR.nextBytes(bytes);
        return bytes;
    }

    public static void setField(Object parent, String name, Object obj) {
        try {
            Field f = TestHelpers.findField(parent.getClass(), name);
            f.setAccessible(true);
            f.set(parent, obj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static Field findField(Class<?> clazz, String name) throws NoSuchFieldException {
        for (Field f : clazz.getDeclaredFields()) {
            if (!f.getName().equals(name)) continue;
            return f;
        }
        if (clazz.getSuperclass() == null) {
            throw new NoSuchFieldException("Field " + name + " could not be found");
        }
        return TestHelpers.findField(clazz.getSuperclass(), name);
    }
}

