/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.hp.hpl.jena.rdf.model.Resource;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.version.Version;
import javax.jcr.version.VersionHistory;
import org.fcrepo.kernel.exception.InvalidChecksumException;
import org.fcrepo.kernel.exception.PathNotFoundRuntimeException;
import org.fcrepo.kernel.exception.RepositoryRuntimeException;
import org.fcrepo.kernel.identifiers.IdentifierConverter;
import org.fcrepo.kernel.impl.FedoraResourceImpl;
import org.fcrepo.kernel.impl.NonRdfSourceDescriptionImpl;
import org.fcrepo.kernel.impl.rdf.impl.FixityRdfContext;
import org.fcrepo.kernel.impl.utils.FedoraTypesUtils;
import org.fcrepo.kernel.impl.utils.impl.CacheEntryFactory;
import org.fcrepo.kernel.models.FedoraBinary;
import org.fcrepo.kernel.models.FedoraResource;
import org.fcrepo.kernel.models.NonRdfSourceDescription;
import org.fcrepo.kernel.services.policy.StoragePolicyDecisionPoint;
import org.fcrepo.kernel.utils.ContentDigest;
import org.fcrepo.kernel.utils.iterators.RdfStream;
import org.fcrepo.metrics.RegistryService;
import org.modeshape.jcr.api.Binary;
import org.modeshape.jcr.api.ValueFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FedoraBinaryImpl
extends FedoraResourceImpl
implements FedoraBinary {
    private static final Logger LOGGER = LoggerFactory.getLogger(FedoraBinaryImpl.class);
    static final RegistryService registryService = RegistryService.getInstance();
    static final Counter fixityCheckCounter = registryService.getMetrics().counter(MetricRegistry.name(FedoraBinary.class, (String[])new String[]{"fixity-check-counter"}));
    static final Timer timer = registryService.getMetrics().timer(MetricRegistry.name(NonRdfSourceDescription.class, (String[])new String[]{"fixity-check-time"}));
    static final Histogram contentSizeHistogram = registryService.getMetrics().histogram(MetricRegistry.name(FedoraBinary.class, (String[])new String[]{"content-size"}));

    public FedoraBinaryImpl(Node node) {
        super(node);
        if (node.isNew()) {
            this.initializeNewBinaryProperties();
        }
    }

    private void initializeNewBinaryProperties() {
        try {
            FedoraBinaryImpl.decorateContentNode(this.node);
        }
        catch (RepositoryException e) {
            LOGGER.warn("Count not decorate {} with FedoraBinary properties: {}", (Object)this.node, (Object)e);
        }
    }

    public NonRdfSourceDescription getDescription() {
        try {
            return new NonRdfSourceDescriptionImpl(this.getNode().getParent());
        }
        catch (RepositoryException e) {
            throw new RepositoryRuntimeException((Throwable)e);
        }
    }

    public InputStream getContent() {
        try {
            return this.getBinaryContent().getStream();
        }
        catch (RepositoryException e) {
            throw new RepositoryRuntimeException((Throwable)e);
        }
    }

    public javax.jcr.Binary getBinaryContent() {
        try {
            return this.getProperty("jcr:data").getBinary();
        }
        catch (PathNotFoundException e) {
            throw new PathNotFoundRuntimeException((Throwable)e);
        }
        catch (RepositoryException e) {
            throw new RepositoryRuntimeException((Throwable)e);
        }
    }

    public void setContent(InputStream content, String contentType, URI checksum, String originalFileName, StoragePolicyDecisionPoint storagePolicyDecisionPoint) throws InvalidChecksumException {
        try {
            Node contentNode = this.getNode();
            if (contentNode.canAddMixin("fedora:Binary")) {
                contentNode.addMixin("fedora:Binary");
            }
            if (contentType != null) {
                contentNode.setProperty("jcr:mimeType", contentType);
            }
            if (originalFileName != null) {
                contentNode.setProperty("premis:hasOriginalName", originalFileName);
            }
            LOGGER.debug("Created content node at path: {}", (Object)contentNode.getPath());
            String hint = null;
            if (storagePolicyDecisionPoint != null) {
                hint = storagePolicyDecisionPoint.evaluatePolicies(this.node);
            }
            ValueFactory modevf = (ValueFactory)this.node.getSession().getValueFactory();
            Binary binary = modevf.createBinary(content, hint);
            Property dataProperty = contentNode.setProperty("jcr:data", (javax.jcr.Binary)binary);
            String dsChecksum = binary.getHexHash();
            URI uriChecksumString = ContentDigest.asURI((String)"SHA-1", (String)dsChecksum);
            if (checksum != null && !checksum.equals(uriChecksumString)) {
                LOGGER.debug("Failed checksum test");
                throw new InvalidChecksumException("Checksum Mismatch of " + uriChecksumString + " and " + checksum);
            }
            FedoraBinaryImpl.decorateContentNode(contentNode);
            LOGGER.debug("Created data property at path: {}", (Object)dataProperty.getPath());
        }
        catch (RepositoryException e) {
            throw new RepositoryRuntimeException((Throwable)e);
        }
    }

    public long getContentSize() {
        try {
            if (this.hasProperty("premis:hasSize")) {
                return this.getProperty("premis:hasSize").getLong();
            }
        }
        catch (RepositoryException e) {
            LOGGER.info("Could not get contentSize(): {}", (Object)e.getMessage());
        }
        return -1L;
    }

    public URI getContentDigest() {
        try {
            if (this.hasProperty("fedora:digest")) {
                return new URI(this.getProperty("fedora:digest").getString());
            }
        }
        catch (URISyntaxException | RepositoryException e) {
            LOGGER.info("Could not get content digest: {}", (Object)e.getMessage());
        }
        return ContentDigest.missingChecksum();
    }

    public String getMimeType() {
        try {
            if (this.hasProperty("jcr:mimeType")) {
                return this.getProperty("jcr:mimeType").getString();
            }
            return "application/octet-stream";
        }
        catch (RepositoryException e) {
            throw new RepositoryRuntimeException((Throwable)e);
        }
    }

    public String getFilename() {
        try {
            if (this.hasProperty("premis:hasOriginalName")) {
                return this.getProperty("premis:hasOriginalName").getString();
            }
            return this.node.getParent().getName();
        }
        catch (RepositoryException e) {
            throw new RepositoryRuntimeException((Throwable)e);
        }
    }

    public RdfStream getFixity(IdentifierConverter<Resource, FedoraResource> idTranslator) {
        return this.getFixity(idTranslator, this.getContentDigest(), this.getContentSize());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RdfStream getFixity(IdentifierConverter<Resource, FedoraResource> idTranslator, URI digestUri, long size) {
        fixityCheckCounter.inc();
        try (Timer.Context context = timer.time();){
            Repository repo = this.node.getSession().getRepository();
            LOGGER.debug("Checking resource: " + this.getPath());
            String algorithm = ContentDigest.getAlgorithm((URI)digestUri);
            Collection fixityResults = CacheEntryFactory.forProperty(repo, this.getProperty("jcr:data")).checkFixity(algorithm);
            FixityRdfContext fixityRdfContext = new FixityRdfContext(this, idTranslator, fixityResults, digestUri, size);
            return fixityRdfContext;
        }
        catch (RepositoryException e) {
            throw new RepositoryRuntimeException((Throwable)e);
        }
    }

    @Override
    public void delete() {
        NonRdfSourceDescription description = this.getDescription();
        super.delete();
        description.delete();
    }

    @Override
    public Version getBaseVersion() {
        return this.getDescription().getBaseVersion();
    }

    private static void decorateContentNode(Node contentNode) throws RepositoryException {
        if (contentNode == null) {
            LOGGER.warn("{} node appears to be null!", (Object)"jcr:content");
            return;
        }
        if (contentNode.canAddMixin("fedora:Binary")) {
            contentNode.addMixin("fedora:Binary");
        }
        if (contentNode.hasProperty("jcr:data")) {
            Property dataProperty = contentNode.getProperty("jcr:data");
            Binary binary = (Binary)dataProperty.getBinary();
            String dsChecksum = binary.getHexHash();
            contentSizeHistogram.update(dataProperty.getLength());
            contentNode.setProperty("premis:hasSize", dataProperty.getLength());
            contentNode.setProperty("fedora:digest", ContentDigest.asURI((String)"SHA-1", (String)dsChecksum).toString());
            LOGGER.debug("Decorated data property at path: {}", (Object)dataProperty.getPath());
        }
    }

    @Override
    public VersionHistory getVersionHistory() {
        try {
            return this.getSession().getWorkspace().getVersionManager().getVersionHistory(this.getDescription().getPath());
        }
        catch (RepositoryException e) {
            throw new RepositoryRuntimeException((Throwable)e);
        }
    }

    @Override
    public boolean isVersioned() {
        return this.getDescription().isVersioned();
    }

    @Override
    public void enableVersioning() {
        super.enableVersioning();
        this.getDescription().enableVersioning();
    }

    @Override
    public void disableVersioning() {
        super.disableVersioning();
        this.getDescription().disableVersioning();
    }

    public static boolean hasMixin(Node node) {
        return FedoraTypesUtils.isFedoraBinary.apply((Object)node);
    }
}

