/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.identifiers;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.fcrepo.kernel.identifiers.InternalIdentifierConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HierarchyConverter
extends InternalIdentifierConverter {
    public static final String DEFAULT_SEPARATOR = "/";
    private String separator = "/";
    private String prefix = "";
    private final Function<String, String> addPrefix = new Function<String, String>(){

        public String apply(String input) {
            return HierarchyConverter.this.prefix + input;
        }
    };
    private static final int DEFAULT_LENGTH = 2;
    private static final int DEFAULT_COUNT = 4;
    private int length = 2;
    private int levels = 4;
    private static final Logger log = LoggerFactory.getLogger(HierarchyConverter.class);

    protected String doBackward(String flat) {
        log.debug("Converting incoming identifier: {}", (Object)flat);
        List<String> hierarchySegments = this.createHierarchySegments();
        List<String> flatSegments = Arrays.asList(flat.split(this.separator));
        List<Object> firstSegments = Collections.emptyList();
        List<Object> lastSegment = Collections.emptyList();
        if (flatSegments.size() == 0) {
            return Joiner.on((String)this.separator).join(hierarchySegments);
        }
        if (flatSegments.size() > 1) {
            lastSegment = Collections.singletonList(Iterables.getLast(flatSegments));
            firstSegments = flatSegments.subList(0, flatSegments.size() - 1);
        } else {
            lastSegment = Collections.singletonList(flatSegments.get(0));
        }
        Iterable allSegments = Iterables.concat(firstSegments, hierarchySegments, lastSegment);
        return Joiner.on((String)this.separator).join(allSegments);
    }

    protected String doForward(String hierarchical) {
        log.debug("Converting outgoing identifier: {}", (Object)hierarchical);
        List<String> segments = Arrays.asList(hierarchical.split(this.separator));
        if (segments.size() <= this.levels) {
            return "";
        }
        List<Object> firstSegments = Collections.emptyList();
        List<Object> lastSegment = Collections.emptyList();
        if (segments.size() > this.levels + 1) {
            firstSegments = segments.subList(0, segments.size() - 1 - this.levels);
            lastSegment = Collections.singletonList(Iterables.getLast(segments));
        } else {
            lastSegment = Collections.singletonList(Iterables.getLast(segments));
        }
        return Joiner.on((String)this.separator).join(Iterables.concat(firstSegments, lastSegment));
    }

    private List<String> createHierarchySegments() {
        if (this.levels == 0) {
            return Collections.emptyList();
        }
        return Lists.transform((List)Splitter.fixedLength((int)this.length).splitToList(this.createHierarchyCharacterBlock()), this.addPrefix);
    }

    private CharSequence createHierarchyCharacterBlock() {
        return UUID.randomUUID().toString().replace("-", "").substring(0, this.length * this.levels);
    }

    public void setSeparator(String sep) {
        this.separator = sep;
    }

    public void setLength(int l) {
        if (l < 1) {
            throw new IllegalArgumentException("Segment length must be at least one!");
        }
        this.length = l;
    }

    public void setLevels(int l) {
        this.levels = l;
    }

    public void setPrefix(String p) {
        this.prefix = p;
    }
}

