/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.observer.eventmappings;

import com.google.common.base.Function;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.jcr.RepositoryException;
import javax.jcr.observation.Event;
import org.fcrepo.kernel.exception.RepositoryRuntimeException;
import org.fcrepo.kernel.observer.FedoraEvent;
import org.fcrepo.kernel.observer.eventmappings.InternalExternalEventMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AllNodeEventsOneEvent
implements InternalExternalEventMapper {
    private static final List<Integer> PROPERTY_EVENT_TYPES = Arrays.asList(4, 16, 8);
    private static final Function<Event, String> EXTRACT_NODE_ID = new Function<Event, String>(){

        public String apply(Event ev) {
            try {
                String id = ev.getIdentifier();
                log.debug("Sorting an event by identifier: {}", (Object)id);
                return id;
            }
            catch (RepositoryException e) {
                throw new RepositoryRuntimeException((Throwable)e);
            }
        }
    };
    private static final Logger log = LoggerFactory.getLogger(AllNodeEventsOneEvent.class);

    public Iterator<FedoraEvent> apply(final Iterator<Event> events) {
        return new Iterator<FedoraEvent>(){
            final Multimap<String, Event> sortedEvents;
            final Iterator<String> nodeIds;
            {
                this.sortedEvents = Multimaps.index((Iterator)events, (Function)EXTRACT_NODE_ID);
                this.nodeIds = this.sortedEvents.keySet().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.nodeIds.hasNext();
            }

            @Override
            public FedoraEvent next() {
                Iterator nodeSpecificEvents = this.sortedEvents.get((Object)this.nodeIds.next()).iterator();
                Event firstEvent = (Event)nodeSpecificEvents.next();
                FedoraEvent fedoraEvent = new FedoraEvent(firstEvent);
                this.addProperty(fedoraEvent, firstEvent);
                while (nodeSpecificEvents.hasNext()) {
                    Event otherEvent = (Event)nodeSpecificEvents.next();
                    fedoraEvent.addType(Integer.valueOf(otherEvent.getType()));
                    this.addProperty(fedoraEvent, otherEvent);
                }
                return fedoraEvent;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            private void addProperty(FedoraEvent fedoraEvent, Event ev) {
                try {
                    if (PROPERTY_EVENT_TYPES.contains(ev.getType())) {
                        String eventPath = ev.getPath();
                        fedoraEvent.addProperty(eventPath.substring(eventPath.lastIndexOf("/") + 1));
                    } else {
                        log.trace("Not adding non-event property: {}, {}", (Object)fedoraEvent, (Object)ev);
                    }
                }
                catch (RepositoryException e) {
                    throw new RepositoryRuntimeException((Throwable)e);
                }
            }
        };
    }
}

