/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.rdf.impl;

import com.google.common.base.Converter;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.NodeFactory;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import java.util.Collections;
import java.util.Iterator;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.fcrepo.kernel.RdfLexicon;
import org.fcrepo.kernel.exception.RepositoryRuntimeException;
import org.fcrepo.kernel.identifiers.IdentifierConverter;
import org.fcrepo.kernel.impl.identifiers.NodeResourceConverter;
import org.fcrepo.kernel.impl.rdf.converters.PropertyConverter;
import org.fcrepo.kernel.impl.rdf.converters.ValueConverter;
import org.fcrepo.kernel.impl.rdf.impl.ChildrenRdfContext;
import org.fcrepo.kernel.impl.rdf.impl.NodeRdfContext;
import org.fcrepo.kernel.impl.rdf.impl.mappings.PropertyValueIterator;
import org.fcrepo.kernel.models.FedoraResource;
import org.fcrepo.kernel.models.NonRdfSourceDescription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdpContainerRdfContext
extends NodeRdfContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChildrenRdfContext.class);
    private static Predicate<Property> isContainer = new Predicate<Property>(){

        public boolean apply(Property property) {
            try {
                javax.jcr.Node container = property.getParent();
                return container.isNodeType("ldp:DirectContainer") || container.isNodeType("ldp:IndirectContainer");
            }
            catch (RepositoryException e) {
                throw new RepositoryRuntimeException((Throwable)e);
            }
        }
    };

    public LdpContainerRdfContext(FedoraResource resource, IdentifierConverter<Resource, FedoraResource> idTranslator) throws RepositoryException {
        super(resource, idTranslator);
        PropertyIterator memberReferences = resource.getNode().getReferences("ldp:membershipResource");
        UnmodifiableIterator properties = Iterators.filter((Iterator)memberReferences, isContainer);
        if (properties.hasNext()) {
            LOGGER.trace("Found membership containers for {}", (Object)resource);
            this.concat(this.membershipContext((Iterator<Property>)properties));
        }
    }

    private Iterator<Triple> membershipContext(Iterator<Property> properties) {
        return Iterators.concat((Iterator)Iterators.transform(properties, this.nodes2triples()));
    }

    private Function<Property, Iterator<Triple>> nodes2triples() {
        return new Function<Property, Iterator<Triple>>(){

            public Iterator<Triple> apply(Property property) {
                try {
                    FedoraResource resource = (FedoraResource)NodeResourceConverter.nodeConverter.convert(property.getParent());
                    return LdpContainerRdfContext.this.memberRelations(resource);
                }
                catch (RepositoryException e) {
                    throw new RepositoryRuntimeException((Throwable)e);
                }
            }
        };
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Iterator<Triple> memberRelations(FedoraResource container) throws RepositoryException {
        String insertedContainerProperty;
        Node memberRelation;
        if (container.hasProperty("ldp:hasMemberRelation")) {
            Property property = container.getProperty("ldp:hasMemberRelation");
            memberRelation = NodeFactory.createURI((String)property.getString());
        } else {
            if (!container.hasType("ldp:BasicContainer")) return Collections.emptyIterator();
            memberRelation = RdfLexicon.LDP_MEMBER.asNode();
        }
        if (container.hasType("ldp:IndirectContainer")) {
            if (!container.hasProperty("ldp:insertedContentRelation")) return Collections.emptyIterator();
            insertedContainerProperty = container.getProperty("ldp:insertedContentRelation").getString();
        } else {
            insertedContainerProperty = RdfLexicon.MEMBER_SUBJECT.getURI();
        }
        Iterator memberNodes = container.getChildren();
        return Iterators.concat((Iterator)Iterators.transform((Iterator)memberNodes, (Function)new Function<FedoraResource, Iterator<Triple>>(){

            public Iterator<Triple> apply(FedoraResource child) {
                try {
                    Node childSubject = child instanceof NonRdfSourceDescription ? ((Resource)LdpContainerRdfContext.this.translator().reverse().convert((Object)((NonRdfSourceDescription)child).getDescribedResource())).asNode() : ((Resource)LdpContainerRdfContext.this.translator().reverse().convert((Object)child)).asNode();
                    if (insertedContainerProperty.equals(RdfLexicon.MEMBER_SUBJECT.getURI())) {
                        return Iterators.singletonIterator((Object)Triple.create((Node)LdpContainerRdfContext.this.subject(), (Node)memberRelation, (Node)childSubject));
                    }
                    String insertedContentProperty = PropertyConverter.getPropertyNameFromPredicate(LdpContainerRdfContext.this.resource().getNode(), ResourceFactory.createResource((String)insertedContainerProperty), null);
                    if (!child.hasProperty(insertedContentProperty)) {
                        return Collections.emptyIterator();
                    }
                    PropertyValueIterator values = new PropertyValueIterator(child.getProperty(insertedContentProperty));
                    return Iterators.transform((Iterator)((Object)values), (Function)new Function<Value, Triple>(){

                        public Triple apply(Value input) {
                            RDFNode membershipResource = (RDFNode)new ValueConverter(LdpContainerRdfContext.this.session(), (Converter<Resource, FedoraResource>)LdpContainerRdfContext.this.translator()).convert(input);
                            return Triple.create((Node)LdpContainerRdfContext.this.subject(), (Node)memberRelation, (Node)membershipResource.asNode());
                        }
                    });
                }
                catch (RepositoryException e) {
                    throw new RepositoryRuntimeException((Throwable)e);
                }
            }
        }));
    }
}

