/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.rdf.impl;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.vocabulary.RDF;
import org.fcrepo.kernel.RdfLexicon;
import org.fcrepo.kernel.identifiers.IdentifierConverter;
import org.fcrepo.kernel.impl.rdf.impl.NodeRdfContext;
import org.fcrepo.kernel.models.Container;
import org.fcrepo.kernel.models.FedoraResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdpRdfContext
extends NodeRdfContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(LdpRdfContext.class);

    public LdpRdfContext(FedoraResource resource, IdentifierConverter<Resource, FedoraResource> idTranslator) {
        super(resource, idTranslator);
        this.concat(this.typeContext());
        if (resource instanceof Container) {
            this.concat(this.containerContext());
            if (!resource.hasType("fedora:Container")) {
                this.concat(this.defaultContainerContext());
            }
        }
    }

    private Triple typeContext() {
        return Triple.create((Node)this.subject(), (Node)RDF.type.asNode(), (Node)RdfLexicon.RDF_SOURCE.asNode());
    }

    private Triple containerContext() {
        return Triple.create((Node)this.subject(), (Node)RDF.type.asNode(), (Node)RdfLexicon.CONTAINER.asNode());
    }

    private Triple defaultContainerContext() {
        return Triple.create((Node)this.subject(), (Node)RDF.type.asNode(), (Node)RdfLexicon.BASIC_CONTAINER.asNode());
    }
}

