/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.rdf.impl;

import com.codahale.metrics.Counter;
import com.google.common.collect.ImmutableSet;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.NodeFactory;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import java.util.Collection;
import java.util.Map;
import java.util.SortedMap;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeIterator;
import javax.jcr.nodetype.NodeTypeManager;
import org.apache.commons.lang.StringUtils;
import org.fcrepo.kernel.RdfLexicon;
import org.fcrepo.kernel.identifiers.IdentifierConverter;
import org.fcrepo.kernel.impl.rdf.impl.NodeRdfContext;
import org.fcrepo.kernel.impl.services.functions.GetClusterConfiguration;
import org.fcrepo.kernel.models.FedoraResource;
import org.fcrepo.metrics.RegistryService;
import org.modeshape.jcr.JcrRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RootRdfContext
extends NodeRdfContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(RootRdfContext.class);
    static final RegistryService registryService = RegistryService.getInstance();

    public RootRdfContext(FedoraResource resource, IdentifierConverter<Resource, FedoraResource> idTranslator) throws RepositoryException {
        super(resource, idTranslator);
        if (this.resource().hasType("mode:root")) {
            this.concatRepositoryTriples();
        }
    }

    private void concatRepositoryTriples() throws RepositoryException {
        SortedMap counters;
        LOGGER.trace("Creating RDF triples for repository description");
        Repository repository = this.resource().getNode().getSession().getRepository();
        ImmutableSet.Builder b = ImmutableSet.builder();
        for (String key : repository.getDescriptorKeys()) {
            String descriptor = repository.getDescriptor(key);
            if (descriptor == null) continue;
            StringBuilder uri = new StringBuilder("http://fedora.info/definitions/v4/repository#");
            uri.append("repository");
            for (String segment : key.split("\\.")) {
                uri.append(StringUtils.capitalize((String)segment));
            }
            b.add((Object)Triple.create((Node)this.subject(), (Node)NodeFactory.createURI((String)uri.toString()), (Node)NodeFactory.createLiteral((String)descriptor)));
        }
        NodeTypeManager nodeTypeManager = this.resource().getNode().getSession().getWorkspace().getNodeTypeManager();
        NodeTypeIterator nodeTypes = nodeTypeManager.getAllNodeTypes();
        while (nodeTypes.hasNext()) {
            NodeType nodeType = nodeTypes.nextNodeType();
            b.add((Object)Triple.create((Node)this.subject(), (Node)RdfLexicon.HAS_NODE_TYPE.asNode(), (Node)NodeFactory.createLiteral((String)nodeType.getName())));
        }
        if (JcrRepository.class.isAssignableFrom(repository.getClass())) {
            Map<String, String> config = new GetClusterConfiguration().apply(repository);
            assert (config != null);
            for (Map.Entry<String, String> entry : config.entrySet()) {
                b.add((Object)Triple.create((Node)this.subject(), (Node)NodeFactory.createURI((String)("http://fedora.info/definitions/v4/repository#" + entry.getKey())), (Node)NodeFactory.createLiteral((String)entry.getValue())));
            }
        }
        if ((counters = registryService.getMetrics().getCounters()).containsKey("LowLevelStorageService.fixity-check-counter")) {
            b.add((Object)Triple.create((Node)this.subject(), (Node)RdfLexicon.HAS_FIXITY_CHECK_COUNT.asNode(), (Node)ResourceFactory.createTypedLiteral((Object)((Counter)counters.get("org.fcrepo.services.LowLevelStorageService.fixity-check-counter")).getCount()).asNode()));
        }
        if (counters.containsKey("LowLevelStorageService.fixity-error-counter")) {
            b.add((Object)Triple.create((Node)this.subject(), (Node)RdfLexicon.HAS_FIXITY_ERROR_COUNT.asNode(), (Node)ResourceFactory.createTypedLiteral((Object)((Counter)counters.get("org.fcrepo.services.LowLevelStorageService.fixity-error-counter")).getCount()).asNode()));
        }
        if (counters.containsKey("LowLevelStorageService.fixity-repaired-counter")) {
            b.add((Object)Triple.create((Node)this.subject(), (Node)RdfLexicon.HAS_FIXITY_REPAIRED_COUNT.asNode(), (Node)ResourceFactory.createTypedLiteral((Object)((Counter)counters.get("org.fcrepo.services.LowLevelStorageService.fixity-repaired-counter")).getCount()).asNode()));
        }
        this.concat((Collection)b.build());
    }
}

