/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.services;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.fcrepo.kernel.exception.RepositoryRuntimeException;
import org.fcrepo.kernel.exception.ResourceTypeException;
import org.fcrepo.kernel.impl.ContainerImpl;
import org.fcrepo.kernel.impl.services.AbstractService;
import org.fcrepo.kernel.models.Container;
import org.fcrepo.kernel.services.ContainerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ContainerServiceImpl
extends AbstractService
implements ContainerService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContainerServiceImpl.class);

    public Container findOrCreate(Session session, String path) {
        LOGGER.trace("Executing findOrCreateObject() with path: {}", (Object)path);
        try {
            Node node = this.findOrCreateNode(session, path, "nt:folder");
            if (node.isNew()) {
                ContainerServiceImpl.initializeNewObjectProperties(node);
            }
            return new ContainerImpl(node);
        }
        catch (RepositoryException e) {
            throw new RepositoryRuntimeException((Throwable)e);
        }
    }

    public Container find(Session session, String path) {
        Node node = this.findNode(session, path);
        return this.cast(node);
    }

    private static void initializeNewObjectProperties(Node node) {
        try {
            LOGGER.debug("Setting object properties on node {}...", (Object)node.getPath());
            if (node.canAddMixin("fedora:Resource")) {
                node.addMixin("fedora:Resource");
            }
            if (node.canAddMixin("fedora:Container")) {
                node.addMixin("fedora:Container");
            }
        }
        catch (RepositoryException e) {
            LOGGER.warn("Could not decorate {} with {} properties: {} ", new Object[]{"jcr:content", "fedora:Container", e});
        }
    }

    public Container cast(Node node) {
        ContainerServiceImpl.assertIsType(node);
        return new ContainerImpl(node);
    }

    private static void assertIsType(Node node) {
        if (!ContainerImpl.hasMixin(node)) {
            throw new ResourceTypeException(node + " can not be used as a object");
        }
    }
}

