/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.services;

import java.io.IOException;
import java.io.InputStream;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.fcrepo.kernel.exception.RepositoryRuntimeException;
import org.fcrepo.kernel.impl.FedoraResourceImpl;
import org.fcrepo.kernel.impl.rdf.impl.NodeTypeRdfContext;
import org.fcrepo.kernel.impl.services.AbstractService;
import org.fcrepo.kernel.models.FedoraResource;
import org.fcrepo.kernel.services.NodeService;
import org.fcrepo.kernel.utils.NamespaceTools;
import org.fcrepo.kernel.utils.iterators.RdfStream;
import org.modeshape.jcr.api.nodetype.NodeTypeManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class NodeServiceImpl
extends AbstractService
implements NodeService {
    private static final Logger LOGGER = LoggerFactory.getLogger(NodeServiceImpl.class);

    @Override
    public boolean exists(Session session, String path) {
        try {
            NamespaceTools.validatePath((Session)session, (String)path);
            return session.nodeExists(path);
        }
        catch (RepositoryException e) {
            throw new RepositoryRuntimeException((Throwable)e);
        }
    }

    public FedoraResource find(Session session, String path) {
        try {
            return new FedoraResourceImpl(session.getNode(path));
        }
        catch (RepositoryException e) {
            throw new RepositoryRuntimeException((Throwable)e);
        }
    }

    public void copyObject(Session session, String source, String destination) {
        try {
            session.getWorkspace().copy(source, destination);
        }
        catch (RepositoryException e) {
            throw new RepositoryRuntimeException((Throwable)e);
        }
    }

    public void moveObject(Session session, String source, String destination) {
        try {
            FedoraResource srcResource = this.find(session, source);
            Node sourceNode = srcResource.getNode();
            String name = sourceNode.getName();
            Node parent = sourceNode.getDepth() > 0 ? sourceNode.getParent() : null;
            session.getWorkspace().move(source, destination);
            if (parent != null) {
                NodeServiceImpl.createTombstone(parent, name);
            }
        }
        catch (RepositoryException e) {
            throw new RepositoryRuntimeException((Throwable)e);
        }
    }

    private static void createTombstone(Node parent, String path) throws RepositoryException {
        FedoraResourceImpl fedoraResource = new FedoraResourceImpl(parent);
        Node n = fedoraResource.findOrCreateChild(parent, path, "fedora:Tombstone");
        LOGGER.info("Created tombstone at {} ", (Object)n.getPath());
    }

    public RdfStream getNodeTypes(Session session) {
        try {
            return new NodeTypeRdfContext(session.getWorkspace().getNodeTypeManager());
        }
        catch (RepositoryException e) {
            throw new RepositoryRuntimeException((Throwable)e);
        }
    }

    public void registerNodeTypes(Session session, InputStream cndStream) throws IOException {
        try {
            NodeTypeManager nodeTypeManager = (NodeTypeManager)session.getWorkspace().getNodeTypeManager();
            nodeTypeManager.registerNodeTypes(cndStream, true);
        }
        catch (RepositoryException e) {
            throw new RepositoryRuntimeException((Throwable)e);
        }
    }

    public FedoraResource findOrCreate(Session session, String path) {
        throw new RepositoryRuntimeException("unimplemented");
    }

    public FedoraResource cast(Node node) {
        return new FedoraResourceImpl(node);
    }
}

