/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.utils;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.PropertyDefinition;
import org.fcrepo.kernel.FedoraJcrTypes;
import org.fcrepo.kernel.exception.RepositoryRuntimeException;
import org.fcrepo.kernel.models.FedoraResource;
import org.fcrepo.kernel.services.functions.AnyTypesPredicate;
import org.fcrepo.kernel.services.functions.JcrPropertyFunctions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FedoraTypesUtils
implements FedoraJcrTypes {
    public static final String REFERENCE_PROPERTY_SUFFIX = "_ref";
    private static final Logger LOGGER = LoggerFactory.getLogger(FedoraTypesUtils.class);
    public static Predicate<Node> isContainer = new AnyTypesPredicate(new String[]{"fedora:Container"});
    public static Predicate<Node> isNonRdfSourceDescription = new AnyTypesPredicate(new String[]{"fedora:NonRdfSourceDescription"});
    public static Predicate<Node> isFedoraBinary = new AnyTypesPredicate(new String[]{"fedora:Binary"});
    public static Predicate<FedoraResource> isFrozenNode = new Predicate<FedoraResource>(){

        public boolean apply(FedoraResource f) {
            return f.hasType("nt:frozenNode") || f.getPath().contains("jcr:frozenNode");
        }
    };
    public static Predicate<Node> isBlankNode = new AnyTypesPredicate(new String[]{"fedora:Blanknode"});
    public static Predicate<Property> isInternalReferenceProperty = new Predicate<Property>(){

        public boolean apply(Property p) {
            try {
                return (p.getType() == 9 || p.getType() == 10) && p.getName().endsWith(FedoraTypesUtils.REFERENCE_PROPERTY_SUFFIX);
            }
            catch (RepositoryException e) {
                throw new RepositoryRuntimeException((Throwable)e);
            }
        }
    };
    public static Predicate<Property> isInternalProperty = new Predicate<Property>(){

        public boolean apply(Property p) {
            return JcrPropertyFunctions.isBinaryContentProperty.apply((Object)p) || isProtectedAndShouldBeHidden.apply((Object)p);
        }
    };
    public static Predicate<Property> isProtectedAndShouldBeHidden = new Predicate<Property>(){

        public boolean apply(Property p) {
            try {
                if (!p.getDefinition().isProtected()) {
                    return false;
                }
                if (p.getParent().isNodeType("nt:frozenNode")) {
                    return false;
                }
                String name = p.getName();
                for (String exposedName : FedoraJcrTypes.EXPOSED_PROTECTED_JCR_TYPES) {
                    if (!name.equals(exposedName)) continue;
                    return false;
                }
                return true;
            }
            catch (RepositoryException e) {
                throw new RepositoryRuntimeException((Throwable)e);
            }
        }
    };
    public static Predicate<Node> isInternalNode = new Predicate<Node>(){

        public boolean apply(Node n) {
            Preconditions.checkNotNull((Object)n, (Object)"null is neither internal nor not internal!");
            try {
                return n.isNodeType("mode:system");
            }
            catch (RepositoryException e) {
                throw new RepositoryRuntimeException((Throwable)e);
            }
        }
    };

    public static int getPropertyType(Node node, String propertyName) throws RepositoryException {
        LOGGER.debug("Getting type of property: {} from node: {}", (Object)propertyName, (Object)node);
        PropertyDefinition def = FedoraTypesUtils.getDefinitionForPropertyName(node, propertyName);
        if (def == null) {
            return 0;
        }
        return def.getRequiredType();
    }

    public static boolean isMultivaluedProperty(Node node, String propertyName) throws RepositoryException {
        PropertyDefinition def = FedoraTypesUtils.getDefinitionForPropertyName(node, propertyName);
        if (def == null) {
            return true;
        }
        return def.isMultiple();
    }

    public static PropertyDefinition getDefinitionForPropertyName(Node node, String propertyName) throws RepositoryException {
        NodeType primaryNodeType = node.getPrimaryNodeType();
        PropertyDefinition[] propertyDefinitions = primaryNodeType.getPropertyDefinitions();
        LOGGER.debug("Looking for property name: {}", (Object)propertyName);
        for (PropertyDefinition propertyDefinition : propertyDefinitions) {
            LOGGER.debug("Checking property: {}", (Object)propertyDefinition.getName());
            if (!propertyDefinition.getName().equals(propertyName)) continue;
            return propertyDefinition;
        }
        for (PropertyDefinition propertyDefinition : node.getMixinNodeTypes()) {
            for (PropertyDefinition p : propertyDefinition.getPropertyDefinitions()) {
                if (!p.getName().equals(propertyName)) continue;
                return p;
            }
        }
        return null;
    }

    public static String getReferencePropertyName(String propertyName) {
        return propertyName + REFERENCE_PROPERTY_SUFFIX;
    }

    public static String getReferencePropertyOriginalName(String refPropertyName) {
        int i = refPropertyName.lastIndexOf(REFERENCE_PROPERTY_SUFFIX);
        if (i < 0) {
            return refPropertyName;
        }
        return refPropertyName.substring(0, i);
    }

    public static boolean isReferenceProperty(Node node, String propertyName) throws RepositoryException {
        PropertyDefinition propertyDefinition = FedoraTypesUtils.getDefinitionForPropertyName(node, propertyName);
        return propertyDefinition != null && (propertyDefinition.getRequiredType() == 9 || propertyDefinition.getRequiredType() == 10);
    }

    public static Node getClosestExistingAncestor(Session session, String path) throws RepositoryException {
        String[] pathSegments = path.replaceAll("^/+", "").replaceAll("/+$", "").split("/");
        StringBuilder existingAncestorPath = new StringBuilder(path.length());
        existingAncestorPath.append("/");
        int len = pathSegments.length;
        for (int i = 0; i != len; ++i) {
            String pathSegment = pathSegments[i];
            if (session.nodeExists(existingAncestorPath.toString() + pathSegment)) {
                existingAncestorPath.append(pathSegment);
                if (i == len - 1) continue;
                existingAncestorPath.append("/");
                continue;
            }
            if (i == 0) break;
            existingAncestorPath.deleteCharAt(existingAncestorPath.length() - 1);
            break;
        }
        return session.getNode(existingAncestorPath.toString());
    }
}

