/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.utils;

import com.google.common.base.Joiner;
import com.hp.hpl.jena.rdf.listeners.StatementListener;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.vocabulary.RDF;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.fcrepo.kernel.exception.MalformedRdfException;
import org.fcrepo.kernel.exception.RepositoryRuntimeException;
import org.fcrepo.kernel.identifiers.IdentifierConverter;
import org.fcrepo.kernel.impl.rdf.JcrRdfTools;
import org.fcrepo.kernel.models.FedoraResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JcrPropertyStatementListener
extends StatementListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(JcrPropertyStatementListener.class);
    private final JcrRdfTools jcrRdfTools;
    private final IdentifierConverter<Resource, FedoraResource> idTranslator;
    private final List<String> exceptions;

    public JcrPropertyStatementListener(IdentifierConverter<Resource, FedoraResource> idTranslator, Session session) {
        this(idTranslator, new JcrRdfTools(idTranslator, session));
    }

    public JcrPropertyStatementListener(IdentifierConverter<Resource, FedoraResource> idTranslator, JcrRdfTools jcrRdfTools) {
        this.idTranslator = idTranslator;
        this.jcrRdfTools = jcrRdfTools;
        this.exceptions = new ArrayList<String>();
    }

    public void addedStatement(Statement input) {
        LOGGER.debug(">> added statement {}", (Object)input);
        try {
            Resource subject = input.getSubject();
            if (!this.idTranslator.inDomain((Object)subject) && !subject.isAnon()) {
                return;
            }
            Statement s = this.jcrRdfTools.skolemize(this.idTranslator, input);
            FedoraResource resource = (FedoraResource)this.idTranslator.convert((Object)s.getSubject());
            Property property = s.getPredicate();
            RDFNode objectNode = s.getObject();
            if (property.equals(RDF.type) && objectNode.isResource()) {
                Resource mixinResource = objectNode.asResource();
                this.jcrRdfTools.addMixin(resource, mixinResource, input.getModel().getNsPrefixMap());
                return;
            }
            this.jcrRdfTools.addProperty(resource, property, objectNode, input.getModel().getNsPrefixMap());
        }
        catch (RepositoryException | RepositoryRuntimeException e) {
            this.exceptions.add(e.getMessage());
        }
    }

    public void removedStatement(Statement s) {
        LOGGER.trace(">> removed statement {}", (Object)s);
        try {
            Resource subject = s.getSubject();
            if (!this.idTranslator.inDomain((Object)subject)) {
                return;
            }
            FedoraResource resource = (FedoraResource)this.idTranslator.convert((Object)subject);
            Property property = s.getPredicate();
            RDFNode objectNode = s.getObject();
            if (property.equals(RDF.type) && objectNode.isResource()) {
                Resource mixinResource = objectNode.asResource();
                try {
                    this.jcrRdfTools.removeMixin(resource, mixinResource, s.getModel().getNsPrefixMap());
                }
                catch (RepositoryException e) {
                    // empty catch block
                }
                return;
            }
            this.jcrRdfTools.removeProperty(resource, property, objectNode, s.getModel().getNsPrefixMap());
        }
        catch (RepositoryException | RepositoryRuntimeException e) {
            this.exceptions.add(e.getMessage());
        }
    }

    public void assertNoExceptions() throws MalformedRdfException {
        if (!this.exceptions.isEmpty()) {
            throw new MalformedRdfException(Joiner.on((String)"\n").join(this.exceptions));
        }
    }
}

