/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.utils;

import com.google.common.collect.Iterables;
import com.hp.hpl.jena.rdf.model.Resource;
import java.util.ArrayList;
import java.util.Collections;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.fcrepo.kernel.exception.IdentifierConversionException;
import org.fcrepo.kernel.exception.NoSuchPropertyDefinitionException;
import org.fcrepo.kernel.identifiers.IdentifierConverter;
import org.fcrepo.kernel.impl.utils.FedoraTypesUtils;
import org.fcrepo.kernel.models.FedoraResource;
import org.fcrepo.kernel.services.functions.JcrPropertyFunctions;
import org.modeshape.jcr.IsExternal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodePropertiesTools {
    private static final Logger LOGGER = LoggerFactory.getLogger(NodePropertiesTools.class);
    private static final IsExternal isExternal = new IsExternal();

    public Property appendOrReplaceNodeProperty(Node node, String propertyName, Value newValue) throws RepositoryException {
        String referencePropertyName;
        Property property;
        if (node.hasProperty(propertyName)) {
            property = node.getProperty(propertyName);
            if (property.isMultiple()) {
                LOGGER.debug("Appending value {} to {} property {}", new Object[]{newValue, PropertyType.nameFromValue((int)property.getType()), propertyName});
                ArrayList<Value> newValues = new ArrayList<Value>();
                Collections.addAll(newValues, node.getProperty(propertyName).getValues());
                if (!newValues.contains(newValue)) {
                    newValues.add(newValue);
                    property.setValue((Value[])Iterables.toArray(newValues, Value.class));
                }
            } else {
                LOGGER.debug("Overwriting {} property {} with new value {}", new Object[]{PropertyType.nameFromValue((int)property.getType()), propertyName, newValue});
                property.setValue(newValue);
            }
        } else {
            boolean isMultiple = true;
            try {
                isMultiple = FedoraTypesUtils.isMultivaluedProperty(node, propertyName);
            }
            catch (NoSuchPropertyDefinitionException e) {
                // empty catch block
            }
            if (isMultiple) {
                LOGGER.debug("Creating new multivalued {} property {} with initial value [{}]", new Object[]{PropertyType.nameFromValue((int)newValue.getType()), propertyName, newValue});
                property = node.setProperty(propertyName, new Value[]{newValue}, newValue.getType());
            } else {
                LOGGER.debug("Creating new single-valued {} property {} with initial value {}", new Object[]{PropertyType.nameFromValue((int)newValue.getType()), propertyName, newValue});
                property = node.setProperty(propertyName, newValue, newValue.getType());
            }
        }
        if (!property.isMultiple() && !FedoraTypesUtils.isInternalReferenceProperty.apply((Object)property) && node.hasProperty(referencePropertyName = FedoraTypesUtils.getReferencePropertyName(propertyName))) {
            node.setProperty(referencePropertyName, (Value[])null);
        }
        return property;
    }

    public void addReferencePlaceholders(IdentifierConverter<Resource, FedoraResource> idTranslator, Node node, String propertyName, Resource resource) throws RepositoryException {
        try {
            Node refNode = ((FedoraResource)idTranslator.convert((Object)resource)).getNode();
            if (isExternal.apply(refNode)) {
                return;
            }
            String referencePropertyName = FedoraTypesUtils.getReferencePropertyName(propertyName);
            if (!FedoraTypesUtils.isMultivaluedProperty(node, propertyName)) {
                if (node.hasProperty(referencePropertyName)) {
                    node.setProperty(referencePropertyName, (Value[])null);
                }
                if (node.hasProperty(propertyName)) {
                    node.setProperty(propertyName, (Value)null);
                }
            }
            Value v = node.getSession().getValueFactory().createValue(refNode, true);
            this.appendOrReplaceNodeProperty(node, referencePropertyName, v);
        }
        catch (IdentifierConversionException e) {
            // empty catch block
        }
    }

    public void removeReferencePlaceholders(IdentifierConverter<Resource, FedoraResource> idTranslator, Node node, String propertyName, Resource resource) throws RepositoryException {
        String referencePropertyName = FedoraTypesUtils.getReferencePropertyName(propertyName);
        Node refNode = ((FedoraResource)idTranslator.convert((Object)resource)).getNode();
        Value v = node.getSession().getValueFactory().createValue(refNode, true);
        this.removeNodeProperty(node, referencePropertyName, v);
    }

    public Property removeNodeProperty(Node node, String propertyName, Value valueToRemove) throws RepositoryException {
        Property property;
        if (node.hasProperty(propertyName)) {
            property = node.getProperty(propertyName);
            if (JcrPropertyFunctions.isMultipleValuedProperty.apply((Object)property)) {
                ArrayList<Value> newValues = new ArrayList<Value>();
                boolean remove = false;
                for (Value v : node.getProperty(propertyName).getValues()) {
                    if (v.equals(valueToRemove)) {
                        remove = true;
                        continue;
                    }
                    newValues.add(v);
                }
                if (remove) {
                    if (newValues.isEmpty()) {
                        LOGGER.debug("Removing property {}", (Object)propertyName);
                        property.setValue((Value[])null);
                    } else {
                        LOGGER.debug("Removing value {} from property {}", (Object)valueToRemove, (Object)propertyName);
                        property.setValue((Value[])Iterables.toArray(newValues, Value.class));
                    }
                }
            } else if (property.getValue().equals(valueToRemove)) {
                LOGGER.debug("Removing value from property {}", (Object)propertyName);
                property.setValue((Value)null);
            }
        } else {
            property = null;
        }
        return property;
    }
}

