/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.integration.kernel.impl;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.inject.Inject;
import javax.jcr.Node;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.ValueFactory;
import org.apache.commons.io.IOUtils;
import org.fcrepo.integration.kernel.impl.AbstractIT;
import org.fcrepo.kernel.RdfLexicon;
import org.fcrepo.kernel.exception.InvalidChecksumException;
import org.fcrepo.kernel.identifiers.IdentifierConverter;
import org.fcrepo.kernel.impl.rdf.impl.DefaultIdentifierTranslator;
import org.fcrepo.kernel.models.Container;
import org.fcrepo.kernel.models.FedoraBinary;
import org.fcrepo.kernel.models.FedoraResource;
import org.fcrepo.kernel.services.BinaryService;
import org.fcrepo.kernel.services.ContainerService;
import org.fcrepo.kernel.utils.ContentDigest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.test.context.ContextConfiguration;

@ContextConfiguration(value={"/spring-test/repo.xml"})
public class FedoraBinaryImplIT
extends AbstractIT {
    @Inject
    Repository repo;
    @Inject
    BinaryService binaryService;
    @Inject
    ContainerService containerService;
    private IdentifierConverter<Resource, FedoraResource> idTranslator;

    @Before
    public void setUp() throws RepositoryException {
        this.idTranslator = new DefaultIdentifierTranslator(this.repo.login());
    }

    @Test
    public void testCreatedDate() throws RepositoryException, InvalidChecksumException {
        Session session = this.repo.login();
        this.containerService.findOrCreate(session, "/testDatastreamObject");
        ((FedoraBinary)this.binaryService.findOrCreate(session, "/testDatastreamObject/testDatastreamNode1")).setContent((InputStream)new ByteArrayInputStream("asdf".getBytes()), "application/octet-stream", null, null, null);
        session.save();
        session.logout();
        session = this.repo.login();
        FedoraBinary ds = (FedoraBinary)this.binaryService.findOrCreate(session, "/testDatastreamObject/testDatastreamNode1");
        Assert.assertNotNull((String)"Couldn't find created date on datastream!", (Object)ds.getCreatedDate());
    }

    @Test
    public void testDatastreamContent() throws IOException, RepositoryException, InvalidChecksumException {
        Session session = this.repo.login();
        this.containerService.findOrCreate(session, "/testDatastreamObject");
        ((FedoraBinary)this.binaryService.findOrCreate(session, "/testDatastreamObject/testDatastreamNode1")).setContent((InputStream)new ByteArrayInputStream("asdf".getBytes()), "application/octet-stream", null, null, null);
        session.save();
        FedoraBinary ds = (FedoraBinary)this.binaryService.findOrCreate(session, "/testDatastreamObject/testDatastreamNode1");
        String contentString = IOUtils.toString((InputStream)ds.getContent(), (String)"ASCII");
        Assert.assertEquals((Object)"asdf", (Object)contentString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDatastreamContentType() throws RepositoryException, InvalidChecksumException {
        Session session = this.repo.login();
        try {
            this.containerService.findOrCreate(session, "/testDatastreamObject");
            ((FedoraBinary)this.binaryService.findOrCreate(session, "/testDatastreamObject/testDatastreamNode1")).setContent((InputStream)new ByteArrayInputStream("asdf".getBytes()), "some/mime-type; with=params", null, null, null);
            session.save();
            FedoraBinary ds = (FedoraBinary)this.binaryService.findOrCreate(session, "/testDatastreamObject/testDatastreamNode1");
            Assert.assertEquals((Object)"some/mime-type; with=params", (Object)ds.getMimeType());
        }
        finally {
            session.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDatastreamContentDigestAndLength() throws IOException, RepositoryException, InvalidChecksumException {
        Session session = this.repo.login();
        try {
            this.containerService.findOrCreate(session, "/testDatastreamObject");
            ((FedoraBinary)this.binaryService.findOrCreate(session, "/testDatastreamObject/testDatastreamNode2")).setContent((InputStream)new ByteArrayInputStream("asdf".getBytes()), "application/octet-stream", null, null, null);
            session.save();
            FedoraBinary ds = (FedoraBinary)this.binaryService.findOrCreate(session, "/testDatastreamObject/testDatastreamNode2");
            Assert.assertEquals((Object)"urn:sha1:3da541559918a808c2402bba5012f6c60b27661c", (Object)ds.getContentDigest().toString());
            Assert.assertEquals((long)4L, (long)ds.getContentSize());
            String contentString = IOUtils.toString((InputStream)ds.getContent(), (String)"ASCII");
            Assert.assertEquals((Object)"asdf", (Object)contentString);
        }
        finally {
            session.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testModifyDatastreamContentDigestAndLength() throws IOException, RepositoryException, InvalidChecksumException {
        Session session = this.repo.login();
        try {
            this.containerService.findOrCreate(session, "/testDatastreamObject");
            ((FedoraBinary)this.binaryService.findOrCreate(session, "/testDatastreamObject/testDatastreamNode3")).setContent((InputStream)new ByteArrayInputStream("asdf".getBytes()), "application/octet-stream", null, null, null);
            session.save();
            FedoraBinary ds = (FedoraBinary)this.binaryService.findOrCreate(session, "/testDatastreamObject/testDatastreamNode3");
            ds.setContent((InputStream)new ByteArrayInputStream("0123456789".getBytes()), null, null, null, null);
            Assert.assertEquals((Object)"urn:sha1:87acec17cd9dcd20a716cc2cf67417b71c8a7016", (Object)ds.getContentDigest().toString());
            Assert.assertEquals((long)10L, (long)ds.getContentSize());
            String contentString = IOUtils.toString((InputStream)ds.getContent(), (String)"ASCII");
            Assert.assertEquals((Object)"0123456789", (Object)contentString);
        }
        finally {
            session.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDatastreamContentWithChecksum() throws IOException, RepositoryException, InvalidChecksumException {
        Session session = this.repo.login();
        try {
            this.containerService.findOrCreate(session, "/testDatastreamObject");
            ((FedoraBinary)this.binaryService.findOrCreate(session, "/testDatastreamObject/testDatastreamNode4")).setContent((InputStream)new ByteArrayInputStream("asdf".getBytes()), "application/octet-stream", ContentDigest.asURI((String)"SHA-1", (String)"3da541559918a808c2402bba5012f6c60b27661c"), null, null);
            session.save();
            FedoraBinary ds = (FedoraBinary)this.binaryService.findOrCreate(session, "/testDatastreamObject/testDatastreamNode4");
            Assert.assertEquals((Object)"urn:sha1:3da541559918a808c2402bba5012f6c60b27661c", (Object)ds.getContentDigest().toString());
            String contentString = IOUtils.toString((InputStream)ds.getContent(), (String)"ASCII");
            Assert.assertEquals((Object)"asdf", (Object)contentString);
        }
        finally {
            session.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDatastreamFileName() throws RepositoryException, InvalidChecksumException {
        Session session = this.repo.login();
        try {
            this.containerService.findOrCreate(session, "/testDatastreamObject");
            ((FedoraBinary)this.binaryService.findOrCreate(session, "/testDatastreamObject/testDatastreamNode5")).setContent((InputStream)new ByteArrayInputStream("asdf".getBytes()), "application/octet-stream", null, "xyz.jpg", null);
            session.save();
            FedoraBinary ds = (FedoraBinary)this.binaryService.findOrCreate(session, "/testDatastreamObject/testDatastreamNode5");
            String filename = ds.getFilename();
            Assert.assertEquals((Object)"xyz.jpg", (Object)filename);
        }
        finally {
            session.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testChecksumBlobs() throws RepositoryException, InvalidChecksumException {
        Session session = this.repo.login();
        try {
            this.containerService.findOrCreate(session, "/testLLObject");
            ((FedoraBinary)this.binaryService.findOrCreate(session, "/testLLObject/testRepositoryContent")).setContent((InputStream)new ByteArrayInputStream("01234567890123456789012345678901234567890123456789".getBytes()), "application/octet-stream", null, null, null);
            session.save();
            FedoraBinary ds = (FedoraBinary)this.binaryService.findOrCreate(session, "/testLLObject/testRepositoryContent");
            Model fixityResults = ds.getFixity(this.idTranslator).asModel();
            Assert.assertNotEquals((long)0L, (long)fixityResults.size());
            Assert.assertTrue((String)"Expected to find checksum", (boolean)fixityResults.contains(null, RdfLexicon.HAS_MESSAGE_DIGEST, (RDFNode)ResourceFactory.createResource((String)"urn:sha1:9578f951955d37f20b601c26591e260c1e5389bf")));
        }
        finally {
            session.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testChecksumBlobsForInMemoryValues() throws RepositoryException, InvalidChecksumException {
        Session session = this.repo.login();
        try {
            this.containerService.findOrCreate(session, "/testLLObject");
            ((FedoraBinary)this.binaryService.findOrCreate(session, "/testLLObject/testMemoryContent")).setContent((InputStream)new ByteArrayInputStream("0123456789".getBytes()), "application/octet-stream", null, null, null);
            session.save();
            FedoraBinary ds = (FedoraBinary)this.binaryService.findOrCreate(session, "/testLLObject/testMemoryContent");
            Model fixityResults = ds.getFixity(this.idTranslator).asModel();
            Assert.assertNotEquals((long)0L, (long)fixityResults.size());
            Assert.assertTrue((String)"Expected to find checksum", (boolean)fixityResults.contains(null, RdfLexicon.HAS_MESSAGE_DIGEST, (RDFNode)ResourceFactory.createResource((String)"urn:sha1:87acec17cd9dcd20a716cc2cf67417b71c8a7016")));
        }
        finally {
            session.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testChecksumBlobsForValuesWithoutChecksums() throws RepositoryException {
        Session session = this.repo.login();
        try {
            ValueFactory factory = session.getValueFactory();
            Container object = (Container)this.containerService.findOrCreate(session, "/testLLObject");
            Node testRandomContentNode = object.getNode().addNode("testRandomContent", "nt:file");
            testRandomContentNode.addMixin("fedora:NonRdfSourceDescription");
            Node testRandomContent = testRandomContentNode.addNode("jcr:content", "nt:resource");
            testRandomContent.addMixin("fedora:Binary");
            testRandomContent.setProperty("jcr:data", factory.createBinary((InputStream)new ByteArrayInputStream("0123456789".getBytes())));
            session.save();
            FedoraBinary ds = (FedoraBinary)this.binaryService.findOrCreate(session, "/testLLObject/testRandomContent");
            Model fixityResults = ds.getFixity(this.idTranslator).asModel();
            Assert.assertNotEquals((long)0L, (long)fixityResults.size());
            Assert.assertTrue((String)"Expected to find checksum", (boolean)fixityResults.contains(null, RdfLexicon.HAS_MESSAGE_DIGEST, (RDFNode)ResourceFactory.createResource((String)"urn:sha1:87acec17cd9dcd20a716cc2cf67417b71c8a7016")));
        }
        finally {
            session.logout();
        }
    }
}

