/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.integration.kernel.impl.observer;

import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import java.util.Set;
import javax.inject.Inject;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.fcrepo.integration.kernel.impl.AbstractIT;
import org.fcrepo.kernel.observer.FedoraEvent;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.test.context.ContextConfiguration;

@ContextConfiguration(value={"/spring-test/eventing.xml", "/spring-test/repo.xml"})
public class SimpleObserverIT
extends AbstractIT {
    private Integer eventBusMessageCount;
    @Inject
    private Repository repository;
    @Inject
    private EventBus eventBus;

    @Test
    public void TestEventBusPublishing() throws RepositoryException {
        Session se = this.repository.login();
        se.getRootNode().addNode("/object1").addMixin("fedora:Container");
        se.getRootNode().addNode("/object2").addMixin("fedora:Container");
        se.save();
        se.logout();
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        Assert.assertEquals((String)"Where are my messages!?", (Object)2, (Object)this.eventBusMessageCount);
    }

    @Subscribe
    public void countMessages(FedoraEvent e) {
        Integer n = this.eventBusMessageCount;
        Integer n2 = this.eventBusMessageCount = Integer.valueOf(this.eventBusMessageCount + 1);
        Set properties = e.getProperties();
        Assert.assertNotNull((Object)properties);
        String expected = "http://fedora.info/definitions/v4/repository#mixinTypes";
        Assert.assertTrue((String)("Should contain: http://fedora.info/definitions/v4/repository#mixinTypes" + properties), (boolean)properties.contains("http://fedora.info/definitions/v4/repository#mixinTypes"));
    }

    @Before
    public void acquireConnections() {
        this.eventBusMessageCount = 0;
        this.eventBus.register((Object)this);
    }

    @After
    public void releaseConnections() {
        this.eventBus.unregister((Object)this);
    }
}

