/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.integration.kernel.impl.services;

import com.google.common.io.Files;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import javax.inject.Inject;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.fcrepo.integration.kernel.impl.AbstractIT;
import org.fcrepo.kernel.exception.InvalidChecksumException;
import org.fcrepo.kernel.models.FedoraBinary;
import org.fcrepo.kernel.services.BinaryService;
import org.fcrepo.kernel.services.RepositoryService;
import org.jgroups.util.Util;
import org.junit.Assert;
import org.junit.Test;
import org.modeshape.jcr.api.Problems;
import org.springframework.test.context.ContextConfiguration;

@ContextConfiguration(value={"/spring-test/repo.xml"})
public class RepositoryServiceImplIT
extends AbstractIT {
    @Inject
    private Repository repository;
    @Inject
    private RepositoryService repositoryService;
    @Inject
    private BinaryService binaryService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetAllObjectsDatastreamSize() throws RepositoryException, InvalidChecksumException {
        double originalSize;
        Session session = this.repository.login();
        try {
            originalSize = this.repositoryService.getRepositorySize().longValue();
            ((FedoraBinary)this.binaryService.findOrCreate(session, "/testObjectServiceNode")).setContent((InputStream)new ByteArrayInputStream("asdf".getBytes()), "application/octet-stream", null, null, null);
            session.save();
        }
        finally {
            session.logout();
        }
        try {
            session = this.repository.login();
            double afterSize = this.repositoryService.getRepositorySize().longValue();
            Util.assertEquals((Object)4.0, (Object)(afterSize - originalSize));
        }
        finally {
            session.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBackupRepository() throws Exception {
        Session session = this.repository.login();
        try {
            ((FedoraBinary)this.binaryService.findOrCreate(session, "/testObjectServiceNode0")).setContent((InputStream)new ByteArrayInputStream("asdfx".getBytes()), "application/octet-stream", null, null, null);
            session.save();
            File backupDirectory = Files.createTempDir();
            Problems problems = this.repositoryService.backupRepository(session, backupDirectory);
            Assert.assertFalse((boolean)problems.hasProblems());
        }
        finally {
            session.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRestoreRepository() throws Exception {
        Session session = this.repository.login();
        try {
            ((FedoraBinary)this.binaryService.findOrCreate(session, "/testObjectServiceNode1")).setContent((InputStream)new ByteArrayInputStream("asdfy".getBytes()), "application/octet-stream", null, null, null);
            session.save();
            File backupDirectory = Files.createTempDir();
            this.repositoryService.backupRepository(session, backupDirectory);
            Problems problems = this.repositoryService.restoreRepository(session, backupDirectory);
            Assert.assertFalse((boolean)problems.hasProblems());
        }
        finally {
            session.logout();
        }
    }
}

