/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.integration.kernel.impl.services;

import javax.inject.Inject;
import javax.jcr.PathNotFoundException;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.version.VersionHistory;
import org.fcrepo.integration.kernel.impl.AbstractIT;
import org.fcrepo.kernel.models.FedoraResource;
import org.fcrepo.kernel.services.ContainerService;
import org.fcrepo.kernel.services.NodeService;
import org.fcrepo.kernel.services.VersionService;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.test.context.ContextConfiguration;

@ContextConfiguration(value={"/spring-test/repo.xml"})
public class VersionServiceImplIT
extends AbstractIT {
    @Inject
    private Repository repository;
    @Inject
    NodeService nodeService;
    @Inject
    ContainerService containerService;
    @Inject
    VersionService versionService;
    private static final String LABEL = "label";
    private static final String SECOND_LABEL = "second-label";

    @Test
    public void testCreateVersion() throws RepositoryException {
        Session session = this.repository.login();
        String pid = this.getRandomPid();
        FedoraResource resource = (FedoraResource)this.containerService.findOrCreate(session, "/" + pid);
        session.save();
        this.versionService.createVersion(session, "/" + pid, LABEL);
        session.save();
        Assert.assertEquals((long)2L, (long)VersionServiceImplIT.countVersions(session, resource));
    }

    @Test
    public void testRemoveVersion() throws RepositoryException {
        Session session = this.repository.login();
        String pid = this.getRandomPid();
        FedoraResource resource = (FedoraResource)this.containerService.findOrCreate(session, "/" + pid);
        session.save();
        this.versionService.createVersion(session, "/" + pid, LABEL);
        session.save();
        Assert.assertEquals((long)2L, (long)VersionServiceImplIT.countVersions(session, resource));
        this.versionService.createVersion(session, "/" + pid, SECOND_LABEL);
        session.save();
        Assert.assertEquals((long)3L, (long)VersionServiceImplIT.countVersions(session, resource));
        this.versionService.removeVersion(session, "/" + pid, LABEL);
        session.save();
        Assert.assertEquals((long)2L, (long)VersionServiceImplIT.countVersions(session, resource));
    }

    @Test
    public void testRevertToVersion() throws RepositoryException {
        Session session = this.repository.login();
        String pid = this.getRandomPid();
        FedoraResource resource = (FedoraResource)this.containerService.findOrCreate(session, "/" + pid);
        session.save();
        String label = this.versionService.createVersion(session, "/" + pid, LABEL);
        session.save();
        Assert.assertEquals((long)2L, (long)VersionServiceImplIT.countVersions(session, resource));
        this.versionService.createVersion(session, "/" + pid, SECOND_LABEL);
        session.save();
        Assert.assertEquals((long)3L, (long)VersionServiceImplIT.countVersions(session, resource));
        this.versionService.revertToVersion(session, "/" + pid, LABEL);
        session.save();
        Assert.assertEquals((Object)label, (Object)VersionServiceImplIT.currentVersion(session, resource));
    }

    @Test(expected=PathNotFoundException.class)
    public void testRevertToInvalidVersion() throws RepositoryException {
        Session session = this.repository.login();
        String pid = this.getRandomPid();
        FedoraResource resource = (FedoraResource)this.containerService.findOrCreate(session, "/" + pid);
        session.save();
        this.versionService.createVersion(session, "/" + pid, LABEL);
        session.save();
        Assert.assertEquals((long)2L, (long)VersionServiceImplIT.countVersions(session, resource));
        this.versionService.revertToVersion(session, "/" + pid, "invalid-version-label");
        session.save();
    }

    @Test(expected=PathNotFoundException.class)
    public void testRemoveInvalidVersion() throws RepositoryException {
        Session session = this.repository.login();
        String pid = this.getRandomPid();
        FedoraResource resource = (FedoraResource)this.containerService.findOrCreate(session, "/" + pid);
        session.save();
        this.versionService.createVersion(session, "/" + pid, LABEL);
        session.save();
        Assert.assertEquals((long)2L, (long)VersionServiceImplIT.countVersions(session, resource));
        this.versionService.removeVersion(session, "/" + pid, "invalid-version-label");
        session.save();
    }

    private static String currentVersion(Session session, FedoraResource resource) throws RepositoryException {
        return session.getWorkspace().getVersionManager().getBaseVersion(resource.getNode().getPath()).getFrozenNode().getIdentifier();
    }

    private static long countVersions(Session session, FedoraResource resource) throws RepositoryException {
        VersionHistory versions = session.getWorkspace().getVersionManager().getVersionHistory(resource.getNode().getPath());
        return versions.getAllVersions().getSize();
    }
}

