/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.ResIterator;
import com.hp.hpl.jena.rdf.model.Resource;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Workspace;
import javax.jcr.nodetype.NodeType;
import javax.jcr.version.Version;
import javax.jcr.version.VersionHistory;
import javax.jcr.version.VersionManager;
import org.apache.commons.codec.digest.DigestUtils;
import org.fcrepo.kernel.exception.RepositoryRuntimeException;
import org.fcrepo.kernel.identifiers.IdentifierConverter;
import org.fcrepo.kernel.impl.FedoraResourceImpl;
import org.fcrepo.kernel.impl.rdf.JcrRdfTools;
import org.fcrepo.kernel.impl.rdf.impl.DefaultIdentifierTranslator;
import org.fcrepo.kernel.impl.testutilities.TestNodeIterator;
import org.fcrepo.kernel.impl.testutilities.TestPropertyIterator;
import org.fcrepo.kernel.impl.testutilities.TestTriplesContext;
import org.fcrepo.kernel.models.FedoraResource;
import org.fcrepo.kernel.utils.iterators.RdfStream;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;

public class FedoraResourceImplTest {
    private FedoraResource testObj;
    @Mock
    private Node mockNode;
    @Mock
    private Node mockRoot;
    @Mock
    private Node mockChild;
    @Mock
    private Node mockContainer;
    @Mock
    private Session mockSession;
    @Mock
    private Property mockProp;
    @Mock
    private Property mockContainerProperty;
    @Mock
    private JcrRdfTools mockJcrRdfTools;
    @Mock
    private IdentifierConverter<Resource, FedoraResource> mockSubjects;

    @Before
    public void setUp() throws RepositoryException {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.mockNode.getSession()).thenReturn((Object)this.mockSession);
        Mockito.when((Object)this.mockNode.getPath()).thenReturn((Object)"/some/path");
        NodeType mockNodeType = (NodeType)Mockito.mock(NodeType.class);
        Mockito.when((Object)mockNodeType.getName()).thenReturn((Object)"nt:folder");
        Mockito.when((Object)this.mockNode.getPrimaryNodeType()).thenReturn((Object)mockNodeType);
        this.testObj = new FedoraResourceImpl(this.mockNode);
        Assert.assertEquals((Object)this.mockNode, (Object)this.testObj.getNode());
        this.mockSubjects = new DefaultIdentifierTranslator(this.mockSession);
    }

    @Test
    public void testGetPath() throws RepositoryException {
        this.testObj.getPath();
        ((Node)Mockito.verify((Object)this.mockNode)).getPath();
    }

    @Test(expected=RepositoryRuntimeException.class)
    public void testGetPathException() throws RepositoryException {
        ((Node)Mockito.doThrow(RepositoryException.class).when((Object)this.mockNode)).getPath();
        this.testObj.getPath();
    }

    @Test
    public void testGetCreatedDate() throws RepositoryException {
        Calendar someDate = Calendar.getInstance();
        Mockito.when((Object)this.mockProp.getDate()).thenReturn((Object)someDate);
        Mockito.when((Object)this.mockNode.hasProperty("jcr:created")).thenReturn((Object)true);
        Mockito.when((Object)this.mockNode.getProperty("jcr:created")).thenReturn((Object)this.mockProp);
        Assert.assertEquals((long)someDate.getTimeInMillis(), (long)this.testObj.getCreatedDate().getTime());
    }

    @Test
    public void testGetLastModifiedDateDefault() throws RepositoryException {
        Calendar someDate = Calendar.getInstance();
        someDate.add(5, -1);
        try {
            Mockito.when((Object)this.mockNode.hasProperty("jcr:lastModified")).thenReturn((Object)false);
            Mockito.when((Object)this.mockProp.getDate()).thenReturn((Object)someDate);
            Mockito.when((Object)this.mockNode.hasProperty("jcr:created")).thenReturn((Object)true);
            Mockito.when((Object)this.mockNode.getProperty("jcr:created")).thenReturn((Object)this.mockProp);
            Mockito.when((Object)this.mockNode.getSession()).thenReturn((Object)this.mockSession);
        }
        catch (RepositoryException e) {
            e.printStackTrace();
        }
        Date actual = this.testObj.getLastModifiedDate();
        Assert.assertEquals((long)someDate.getTimeInMillis(), (long)actual.getTime());
        ((Session)Mockito.verify((Object)this.mockSession, (VerificationMode)Mockito.never())).save();
    }

    @Test
    public void testGetLastModifiedDate() {
        Calendar someDate = Calendar.getInstance();
        someDate.add(5, -1);
        try {
            Mockito.when((Object)this.mockProp.getDate()).thenReturn((Object)someDate);
            Mockito.when((Object)this.mockNode.hasProperty("jcr:created")).thenReturn((Object)true);
            Mockito.when((Object)this.mockNode.getProperty("jcr:created")).thenReturn((Object)this.mockProp);
            Mockito.when((Object)this.mockNode.getSession()).thenReturn((Object)this.mockSession);
        }
        catch (RepositoryException e) {
            e.printStackTrace();
        }
        Property mockMod = (Property)Mockito.mock(Property.class);
        Calendar modDate = Calendar.getInstance();
        try {
            Mockito.when((Object)this.mockNode.hasProperty("jcr:lastModified")).thenReturn((Object)true);
            Mockito.when((Object)this.mockNode.getProperty("jcr:lastModified")).thenReturn((Object)mockMod);
            Mockito.when((Object)mockMod.getDate()).thenReturn((Object)modDate);
        }
        catch (RepositoryException e) {
            System.err.println("What are we doing in the second test?");
            e.printStackTrace();
        }
        Date actual = this.testObj.getLastModifiedDate();
        Assert.assertEquals((long)modDate.getTimeInMillis(), (long)actual.getTime());
    }

    @Test
    public void testGetTriples() {
        RdfStream triples = this.testObj.getTriples(this.mockSubjects, TestTriplesContext.class);
        Model model = triples.asModel();
        ResIterator resIterator = model.listSubjects();
        ImmutableSet resources = ImmutableSet.copyOf((Iterator)Iterators.transform((Iterator)resIterator, (Function)new Function<Resource, String>(){

            public String apply(Resource resource) {
                return resource.getURI();
            }
        }));
        Assert.assertTrue((boolean)resources.contains((Object)"MockTriplesContextClass"));
    }

    @Test
    public void testGetBaseVersion() throws RepositoryException {
        Version mockVersion = (Version)Mockito.mock(Version.class);
        Mockito.when((Object)mockVersion.getName()).thenReturn((Object)"uuid");
        Workspace mockWorkspace = (Workspace)Mockito.mock(Workspace.class);
        Mockito.when((Object)this.mockSession.getWorkspace()).thenReturn((Object)mockWorkspace);
        VersionManager mockVersionManager = (VersionManager)Mockito.mock(VersionManager.class);
        Mockito.when((Object)mockWorkspace.getVersionManager()).thenReturn((Object)mockVersionManager);
        Mockito.when((Object)mockVersionManager.getBaseVersion(Matchers.anyString())).thenReturn((Object)mockVersion);
        this.testObj.getBaseVersion();
        ((VersionManager)Mockito.verify((Object)mockVersionManager)).getBaseVersion(Matchers.anyString());
    }

    @Test
    public void testGetVersionHistory() throws RepositoryException {
        VersionHistory mockVersionHistory = (VersionHistory)Mockito.mock(VersionHistory.class);
        Version mockVersion = (Version)Mockito.mock(Version.class);
        Mockito.when((Object)mockVersion.getName()).thenReturn((Object)"uuid");
        Workspace mockWorkspace = (Workspace)Mockito.mock(Workspace.class);
        Mockito.when((Object)this.mockSession.getWorkspace()).thenReturn((Object)mockWorkspace);
        VersionManager mockVersionManager = (VersionManager)Mockito.mock(VersionManager.class);
        Mockito.when((Object)mockWorkspace.getVersionManager()).thenReturn((Object)mockVersionManager);
        Mockito.when((Object)mockVersionManager.getVersionHistory(Matchers.anyString())).thenReturn((Object)mockVersionHistory);
        this.testObj.getVersionHistory();
        ((VersionManager)Mockito.verify((Object)mockVersionManager)).getVersionHistory(Matchers.anyString());
    }

    @Test
    public void testIsNew() {
        Mockito.when((Object)this.mockNode.isNew()).thenReturn((Object)true);
        Assert.assertTrue((String)"resource state should be the same as the node state", (boolean)this.testObj.isNew());
    }

    @Test
    public void testIsNotNew() {
        Mockito.when((Object)this.mockNode.isNew()).thenReturn((Object)false);
        Assert.assertFalse((String)"resource state should be the same as the node state", (boolean)this.testObj.isNew());
    }

    @Test
    public void testReplacePropertiesDataset() throws Exception {
        DefaultIdentifierTranslator defaultGraphSubjects = new DefaultIdentifierTranslator(this.mockSession);
        Mockito.when((Object)this.mockNode.getPath()).thenReturn((Object)"/xyz");
        Mockito.when((Object)this.mockSession.getNode("/xyz")).thenReturn((Object)this.mockNode);
        Model propertiesModel = ModelFactory.createDefaultModel();
        propertiesModel.add(propertiesModel.createResource("a"), propertiesModel.createProperty("b"), "c");
        propertiesModel.add(propertiesModel.createResource("i"), propertiesModel.createProperty("j"), "k");
        propertiesModel.add(propertiesModel.createResource("x"), propertiesModel.createProperty("y"), "z");
        RdfStream propertiesStream = RdfStream.fromModel((Model)propertiesModel);
        Model replacementModel = ModelFactory.createDefaultModel();
        replacementModel.add(replacementModel.createResource("a"), replacementModel.createProperty("b"), "n");
        replacementModel.add(replacementModel.createResource("i"), replacementModel.createProperty("j"), "k");
        this.testObj.replaceProperties((IdentifierConverter)defaultGraphSubjects, replacementModel, propertiesStream);
    }

    @Test
    public void shouldGetEtagForAnObject() throws RepositoryException {
        Property mockMod = (Property)Mockito.mock(Property.class);
        Calendar modDate = Calendar.getInstance();
        modDate.set(2013, 6, 30, 0, 0, 0);
        Mockito.when((Object)this.mockNode.getPath()).thenReturn((Object)"some-path");
        Mockito.when((Object)this.mockNode.hasProperty("jcr:lastModified")).thenReturn((Object)true);
        Mockito.when((Object)this.mockNode.getProperty("jcr:lastModified")).thenReturn((Object)mockMod);
        Mockito.when((Object)mockMod.getDate()).thenReturn((Object)modDate);
        Assert.assertEquals((Object)DigestUtils.shaHex((String)("some-path" + this.testObj.getLastModifiedDate().getTime())), (Object)this.testObj.getEtagValue());
    }

    @Test
    public void testGetContainer() throws RepositoryException {
        Mockito.when((Object)this.mockNode.getParent()).thenReturn((Object)this.mockContainer);
        Mockito.when((Object)this.mockNode.getDepth()).thenReturn((Object)1);
        FedoraResource actual = this.testObj.getContainer();
        Assert.assertEquals((Object)new FedoraResourceImpl(this.mockContainer), (Object)actual);
    }

    @Test
    public void testGetContainerForNestedResource() throws RepositoryException {
        Mockito.when((Object)this.mockNode.getParent()).thenReturn((Object)this.mockChild);
        Mockito.when((Object)this.mockNode.getDepth()).thenReturn((Object)3);
        Mockito.when((Object)this.mockChild.getParent()).thenReturn((Object)this.mockContainer);
        Mockito.when((Object)this.mockChild.getDepth()).thenReturn((Object)2);
        Mockito.when((Object)this.mockChild.isNodeType("fedora:Pairtree")).thenReturn((Object)true);
        Mockito.when((Object)this.mockContainer.getDepth()).thenReturn((Object)1);
        FedoraResource actual = this.testObj.getContainer();
        Assert.assertEquals((Object)new FedoraResourceImpl(this.mockContainer), (Object)actual);
    }

    @Test
    public void testGetChild() throws RepositoryException {
        Mockito.when((Object)this.mockNode.getNode("xyz")).thenReturn((Object)this.mockChild);
        FedoraResource actual = this.testObj.getChild("xyz");
        Assert.assertEquals((Object)new FedoraResourceImpl(this.mockChild), (Object)actual);
    }

    @Test
    public void testGetChildrenWithEmptyChildren() throws RepositoryException {
        Mockito.when((Object)this.mockNode.getNodes()).thenReturn((Object)TestNodeIterator.nodeIterator(new Node[0]));
        Iterator children = this.testObj.getChildren();
        Assert.assertFalse((String)"Expected an empty iterator", (boolean)children.hasNext());
    }

    @Test
    public void testGetChildrenWithChildren() throws RepositoryException {
        Mockito.when((Object)this.mockNode.getNodes()).thenReturn((Object)TestNodeIterator.nodeIterator(this.mockChild));
        Mockito.when((Object)this.mockChild.getName()).thenReturn((Object)"x");
        Iterator children = this.testObj.getChildren();
        Assert.assertTrue((String)"Expected an iterator with values", (boolean)children.hasNext());
        Assert.assertEquals((String)"Expected to find the child", (Object)this.mockChild, (Object)((FedoraResource)children.next()).getNode());
    }

    @Test
    public void testGetChildrenExcludesModeSystem() throws RepositoryException {
        Mockito.when((Object)this.mockNode.getNodes()).thenReturn((Object)TestNodeIterator.nodeIterator(this.mockChild));
        Mockito.when((Object)this.mockChild.isNodeType("mode:system")).thenReturn((Object)true);
        Mockito.when((Object)this.mockChild.getName()).thenReturn((Object)"x");
        Iterator children = this.testObj.getChildren();
        Assert.assertFalse((String)"Expected an empty iterator", (boolean)children.hasNext());
    }

    @Test
    public void testGetChildrenExcludesTombstones() throws RepositoryException {
        Mockito.when((Object)this.mockNode.getNodes()).thenReturn((Object)TestNodeIterator.nodeIterator(this.mockChild));
        Mockito.when((Object)this.mockChild.isNodeType("fedora:Tombstone")).thenReturn((Object)true);
        Mockito.when((Object)this.mockChild.getName()).thenReturn((Object)"x");
        Iterator children = this.testObj.getChildren();
        Assert.assertFalse((String)"Expected an empty iterator", (boolean)children.hasNext());
    }

    @Test
    public void testGetChildrenExcludesJcrContent() throws RepositoryException {
        Mockito.when((Object)this.mockNode.getNodes()).thenReturn((Object)TestNodeIterator.nodeIterator(this.mockChild));
        Mockito.when((Object)this.mockChild.getName()).thenReturn((Object)"jcr:content");
        Iterator children = this.testObj.getChildren();
        Assert.assertFalse((String)"Expected an empty iterator", (boolean)children.hasNext());
    }

    @Test
    public void testHasProperty() throws RepositoryException {
        Mockito.when((Object)this.mockNode.hasProperty("xyz")).thenReturn((Object)true);
        boolean actual = this.testObj.hasProperty("xyz");
        Assert.assertTrue((String)"Expected same value as Node#hasProperty", (boolean)actual);
    }

    @Test
    public void testGetProperty() throws RepositoryException {
        Mockito.when((Object)this.mockNode.getProperty("xyz")).thenReturn((Object)this.mockProp);
        Property actual = this.testObj.getProperty("xyz");
        Assert.assertEquals((Object)this.mockProp, (Object)actual);
    }

    @Test
    public void testEquals() {
        Assert.assertEquals((Object)new FedoraResourceImpl(this.mockNode), (Object)new FedoraResourceImpl(this.mockNode));
        Assert.assertNotEquals((Object)new FedoraResourceImpl(this.mockNode), (Object)new FedoraResourceImpl(this.mockRoot));
    }

    @Test
    public void testDelete() throws RepositoryException {
        Mockito.when((Object)this.mockNode.getReferences()).thenReturn((Object)new TestPropertyIterator(new Property[0]));
        Mockito.when((Object)this.mockNode.getWeakReferences()).thenReturn((Object)new TestPropertyIterator(new Property[0]));
        this.testObj.delete();
        ((Node)Mockito.verify((Object)this.mockNode)).remove();
    }

    @Test
    public void testDeleteLeavesATombstone() throws RepositoryException {
        Mockito.when((Object)this.mockNode.getReferences()).thenReturn((Object)new TestPropertyIterator(new Property[0]));
        Mockito.when((Object)this.mockNode.getWeakReferences()).thenReturn((Object)new TestPropertyIterator(new Property[0]));
        Mockito.when((Object)this.mockNode.getName()).thenReturn((Object)"a");
        Mockito.when((Object)this.mockNode.getParent()).thenReturn((Object)this.mockContainer);
        Mockito.when((Object)this.mockNode.getDepth()).thenReturn((Object)2);
        Mockito.when((Object)this.mockContainer.getNode("a")).thenThrow(new Throwable[]{new PathNotFoundException()});
        Mockito.when((Object)this.mockContainer.getPath()).thenReturn((Object)"b");
        Mockito.when((Object)this.mockContainer.getSession()).thenReturn((Object)this.mockSession);
        Mockito.when((Object)this.mockSession.nodeExists(Matchers.anyString())).thenReturn((Object)false);
        Mockito.when((Object)this.mockSession.getNode("b")).thenReturn((Object)this.mockContainer);
        this.testObj.delete();
        ((Node)Mockito.verify((Object)this.mockNode)).remove();
        ((Node)Mockito.verify((Object)this.mockContainer)).addNode("a", "fedora:Tombstone");
    }

    @Test
    public void testGetUnfrozenResourceForFrozenNode() throws RepositoryException {
        Mockito.when((Object)this.mockNode.isNodeType("nt:frozenNode")).thenReturn((Object)true);
        Mockito.when((Object)this.mockNode.getProperty("jcr:frozenUuid")).thenReturn((Object)this.mockProp);
        Mockito.when((Object)this.mockProp.getString()).thenReturn((Object)"frozen-id");
        Mockito.when((Object)this.mockSession.getNodeByIdentifier("frozen-id")).thenReturn((Object)this.mockChild);
        FedoraResource actual = this.testObj.getUnfrozenResource();
        Assert.assertEquals((Object)this.mockChild, (Object)actual.getNode());
    }

    @Test
    public void testGetUnfrozenResourceForResource() throws RepositoryException {
        Mockito.when((Object)this.mockNode.isNodeType("nt:frozenNode")).thenReturn((Object)false);
        FedoraResource actual = this.testObj.getUnfrozenResource();
        Assert.assertEquals((Object)this.testObj, (Object)actual);
    }

    @Test
    public void testGetVersionedAncestorForResource() throws RepositoryException {
        Mockito.when((Object)this.mockNode.isNodeType("nt:frozenNode")).thenReturn((Object)false);
        FedoraResource actual = this.testObj.getVersionedAncestor();
        Assert.assertNull((Object)actual);
    }

    @Test
    public void testGetVersionedAncestorForVersionedResource() throws RepositoryException {
        Mockito.when((Object)this.mockNode.isNodeType("nt:frozenNode")).thenReturn((Object)true);
        Mockito.when((Object)this.mockNode.getProperty("jcr:frozenUuid")).thenReturn((Object)this.mockProp);
        Mockito.when((Object)this.mockNode.isNodeType("mix:versionable")).thenReturn((Object)true);
        Mockito.when((Object)this.mockProp.getString()).thenReturn((Object)"frozen-id");
        Mockito.when((Object)this.mockSession.getNodeByIdentifier("frozen-id")).thenReturn((Object)this.mockNode);
        FedoraResource actual = this.testObj.getVersionedAncestor();
        Assert.assertEquals((Object)this.mockNode, (Object)actual.getNode());
    }

    @Test
    public void testGetVersionedAncestorForVersionedResourceWithinTree() throws RepositoryException {
        Mockito.when((Object)this.mockNode.isNodeType("nt:frozenNode")).thenReturn((Object)true);
        Mockito.when((Object)this.mockNode.getDepth()).thenReturn((Object)2);
        Mockito.when((Object)this.mockNode.getProperty("jcr:frozenUuid")).thenReturn((Object)this.mockProp);
        Mockito.when((Object)this.mockNode.isNodeType("mix:versionable")).thenReturn((Object)false);
        Mockito.when((Object)this.mockProp.getString()).thenReturn((Object)"frozen-id");
        Mockito.when((Object)this.mockSession.getNodeByIdentifier("frozen-id")).thenReturn((Object)this.mockNode);
        Mockito.when((Object)this.mockNode.getParent()).thenReturn((Object)this.mockContainer);
        Mockito.when((Object)this.mockContainer.getSession()).thenReturn((Object)this.mockSession);
        Mockito.when((Object)this.mockContainer.getDepth()).thenReturn((Object)1);
        Mockito.when((Object)this.mockContainer.isNodeType("nt:frozenNode")).thenReturn((Object)true);
        Mockito.when((Object)this.mockContainer.getProperty("jcr:frozenUuid")).thenReturn((Object)this.mockContainerProperty);
        Mockito.when((Object)this.mockContainerProperty.getString()).thenReturn((Object)"frozen-id-container");
        Mockito.when((Object)this.mockSession.getNodeByIdentifier("frozen-id-container")).thenReturn((Object)this.mockContainer);
        Mockito.when((Object)this.mockContainer.isNodeType("mix:versionable")).thenReturn((Object)true);
        FedoraResource actual = this.testObj.getVersionedAncestor();
        Assert.assertEquals((Object)this.mockContainer, (Object)actual.getNode());
    }
}

