/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.identifiers;

import java.util.Arrays;
import org.fcrepo.kernel.impl.identifiers.HashConverter;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class HashConverterTest {
    @Parameterized.Parameter(value=0)
    public String internalId;
    @Parameterized.Parameter(value=1)
    public String externalId;
    private HashConverter testObj;

    @Parameterized.Parameters
    public static Iterable<String[]> data() {
        return Arrays.asList({"/some/path", "/some/path"}, {"/some/path/#/with-a-hash-uri", "/some/path#with-a-hash-uri"}, {"/some/path/#/with%2Fa%2Fhash%2Furi", "/some/path#with/a/hash/uri"});
    }

    @Before
    public void setUp() {
        this.testObj = new HashConverter();
    }

    @Test
    public void testDoForward() {
        Assert.assertEquals((Object)this.internalId, (Object)this.testObj.convert((Object)this.externalId));
    }

    @Test
    public void testDoBackwards() {
        Assert.assertEquals((Object)this.externalId, (Object)this.testObj.reverse().convert((Object)this.internalId));
    }
}

