/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.rdf.impl;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.security.AccessControlException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.fcrepo.kernel.RdfLexicon;
import org.fcrepo.kernel.identifiers.IdentifierConverter;
import org.fcrepo.kernel.impl.rdf.impl.AclRdfContext;
import org.fcrepo.kernel.impl.rdf.impl.DefaultIdentifierTranslator;
import org.fcrepo.kernel.models.FedoraResource;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AclRdfContextTest {
    @Mock
    private FedoraResource resource;
    @Mock
    private Node mockNode;
    private IdentifierConverter<Resource, FedoraResource> idTranslator;
    @Mock
    private Session mockSession;
    private Resource nodeSubject;
    private String path = "/path/to/node";
    private static final Logger LOGGER = LoggerFactory.getLogger(AclRdfContextTest.class);

    @Before
    public void setUp() throws RepositoryException {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.resource.getNode()).thenReturn((Object)this.mockNode);
        Mockito.when((Object)this.mockNode.getSession()).thenReturn((Object)this.mockSession);
        Mockito.when((Object)this.resource.getPath()).thenReturn((Object)this.path);
        this.idTranslator = new DefaultIdentifierTranslator(this.mockSession);
        this.nodeSubject = (Resource)this.idTranslator.reverse().convert((Object)this.resource);
    }

    @Test
    public void testWritableNode() throws RepositoryException {
        Model actual = new AclRdfContext(this.resource, this.idTranslator).asModel();
        Literal booleanTrue = actual.createTypedLiteral("true", (RDFDatatype)XSDDatatype.XSDboolean);
        Assert.assertTrue((String)"Didn't find writable triple!", (boolean)actual.contains(this.nodeSubject, RdfLexicon.WRITABLE, (RDFNode)booleanTrue));
    }

    @Test
    public void testReadOnlyNode() throws RepositoryException, IOException {
        ((Session)Mockito.doThrow((Throwable)new AccessControlException("permissions check failed")).when((Object)this.mockSession)).checkPermission((String)Matchers.eq((Object)this.path), (String)Matchers.eq((Object)"add_node,set_property,remove"));
        Model actual = new AclRdfContext(this.resource, this.idTranslator).asModel();
        AclRdfContextTest.logRdf("Constructed RDF: ", actual);
        Literal booleanFalse = actual.createTypedLiteral((Object)false, (RDFDatatype)XSDDatatype.XSDboolean);
        Assert.assertTrue((String)"Didn't find writable triple!", (boolean)actual.contains(this.nodeSubject, RdfLexicon.WRITABLE, (RDFNode)booleanFalse));
    }

    private static void logRdf(String message, Model model) throws IOException {
        LOGGER.debug(message);
        try (StringWriter w = new StringWriter();){
            model.write((Writer)w);
            LOGGER.debug("\n" + ((Object)w).toString());
        }
    }
}

