/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.rdf.impl;

import com.google.common.base.Converter;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.Workspace;
import org.fcrepo.kernel.identifiers.IdentifierConverter;
import org.fcrepo.kernel.impl.identifiers.NodeResourceConverter;
import org.fcrepo.kernel.impl.rdf.impl.DefaultIdentifierTranslator;
import org.fcrepo.kernel.impl.rdf.impl.LdpIsMemberOfRdfContext;
import org.fcrepo.kernel.models.FedoraBinary;
import org.fcrepo.kernel.models.FedoraResource;
import org.fcrepo.kernel.models.NonRdfSourceDescription;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.modeshape.jcr.api.NamespaceRegistry;

public class LdpIsMemberOfRdfContextTest {
    private LdpIsMemberOfRdfContext testObj;
    @Mock
    private FedoraBinary mockBinary;
    @Mock
    private NonRdfSourceDescription mockBinaryDescription;
    @Mock
    private Node mockBinaryNode;
    @Mock
    private FedoraResource mockResource;
    @Mock
    private Node mockResourceNode;
    @Mock
    private FedoraResource mockContainer;
    @Mock
    private Node mockContainerNode;
    @Mock
    private Node mockNode;
    @Mock
    private Property mockRelationProperty;
    @Mock
    private Property mockMembershipProperty;
    @Mock
    private Session mockSession;
    private DefaultIdentifierTranslator subjects;
    @Mock
    private Property mockInsertedContentRelationProperty;
    @Mock
    private Workspace mockWorkspace;
    @Mock
    private NamespaceRegistry mockNamespaceRegistry;
    @Mock
    private Value mockRelationValue;

    @Before
    public void setUp() throws RepositoryException {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.mockResource.getPath()).thenReturn((Object)"/a");
        Mockito.when((Object)this.mockResource.getContainer()).thenReturn((Object)this.mockContainer);
        Mockito.when((Object)this.mockResource.getNode()).thenReturn((Object)this.mockResourceNode);
        Mockito.when((Object)this.mockResourceNode.getSession()).thenReturn((Object)this.mockSession);
        Mockito.when((Object)this.mockResourceNode.getDepth()).thenReturn((Object)1);
        Mockito.when((Object)this.mockContainer.getPath()).thenReturn((Object)"/");
        Mockito.when((Object)this.mockContainer.getNode()).thenReturn((Object)this.mockContainerNode);
        Mockito.when((Object)this.mockContainerNode.getDepth()).thenReturn((Object)0);
        Mockito.when((Object)this.mockNode.getPath()).thenReturn((Object)"/some/path");
        Mockito.when((Object)this.mockBinary.hasType("fedora:Binary")).thenReturn((Object)true);
        Mockito.when((Object)this.mockBinary.getPath()).thenReturn((Object)"/a/jcr:content");
        Mockito.when((Object)this.mockBinary.getNode()).thenReturn((Object)this.mockBinaryNode);
        Mockito.when((Object)this.mockBinary.getContainer()).thenReturn((Object)this.mockContainer);
        Mockito.when((Object)this.mockSession.getWorkspace()).thenReturn((Object)this.mockWorkspace);
        Mockito.when((Object)this.mockWorkspace.getNamespaceRegistry()).thenReturn((Object)this.mockNamespaceRegistry);
        this.subjects = new DefaultIdentifierTranslator(this.mockSession);
    }

    @Test
    public void testIsMemberOfRelationWithRootResource() throws RepositoryException {
        this.testObj = new LdpIsMemberOfRdfContext(this.mockContainer, (IdentifierConverter)this.subjects);
        Model model = this.testObj.asModel();
        Assert.assertTrue((String)"Expected stream to be empty", (boolean)model.isEmpty());
    }

    @Test
    public void testIsMemberOfRelationWithoutIsMemberOfResource() throws RepositoryException {
        this.testObj = new LdpIsMemberOfRdfContext(this.mockResource, (IdentifierConverter)this.subjects);
        Model model = this.testObj.asModel();
        Assert.assertTrue((String)"Expected stream to be empty", (boolean)model.isEmpty());
    }

    @Test
    public void testIsMemberOfRelation() throws RepositoryException {
        Mockito.when((Object)this.mockContainer.hasType("ldp:DirectContainer")).thenReturn((Object)true);
        Mockito.when((Object)this.mockContainer.hasProperty("ldp:isMemberOfRelation")).thenReturn((Object)true);
        Mockito.when((Object)this.mockContainer.getProperty("ldp:isMemberOfRelation")).thenReturn((Object)this.mockRelationProperty);
        Mockito.when((Object)this.mockContainer.hasProperty("ldp:membershipResource")).thenReturn((Object)true);
        Mockito.when((Object)this.mockContainer.getProperty("ldp:membershipResource")).thenReturn((Object)this.mockMembershipProperty);
        Mockito.when((Object)this.mockMembershipProperty.getType()).thenReturn((Object)9);
        Mockito.when((Object)this.mockMembershipProperty.getNode()).thenReturn((Object)this.mockNode);
        String property = "some:uri";
        Mockito.when((Object)this.mockRelationProperty.getString()).thenReturn((Object)"some:uri");
        this.testObj = new LdpIsMemberOfRdfContext(this.mockResource, (IdentifierConverter)this.subjects);
        Model model = this.testObj.asModel();
        Assert.assertTrue((String)"Expected stream to contain triple", (boolean)model.contains((Resource)this.subjects.reverse().convert((Object)this.mockResource), ResourceFactory.createProperty((String)"some:uri"), (RDFNode)NodeResourceConverter.nodeToResource((Converter)this.subjects).convert((Object)this.mockNode)));
    }

    @Test
    public void testIsMemberOfRelationToExternalResource() throws RepositoryException {
        Mockito.when((Object)this.mockContainer.hasType("ldp:DirectContainer")).thenReturn((Object)true);
        Mockito.when((Object)this.mockContainer.hasProperty("ldp:isMemberOfRelation")).thenReturn((Object)true);
        Mockito.when((Object)this.mockContainer.getProperty("ldp:isMemberOfRelation")).thenReturn((Object)this.mockRelationProperty);
        Mockito.when((Object)this.mockContainer.hasProperty("ldp:membershipResource")).thenReturn((Object)true);
        Mockito.when((Object)this.mockContainer.getProperty("ldp:membershipResource")).thenReturn((Object)this.mockMembershipProperty);
        Mockito.when((Object)this.mockMembershipProperty.getType()).thenReturn((Object)11);
        Mockito.when((Object)this.mockMembershipProperty.getString()).thenReturn((Object)"some:resource");
        String property = "some:uri";
        Mockito.when((Object)this.mockRelationProperty.getString()).thenReturn((Object)"some:uri");
        this.testObj = new LdpIsMemberOfRdfContext(this.mockResource, (IdentifierConverter)this.subjects);
        Model model = this.testObj.asModel();
        Converter nodeSubjects = this.subjects.reverse();
        Assert.assertTrue((String)"Expected stream to contain triple", (boolean)model.contains((Resource)nodeSubjects.convert((Object)this.mockResource), ResourceFactory.createProperty((String)"some:uri"), (RDFNode)ResourceFactory.createResource((String)"some:resource")));
    }

    @Test
    public void testIsMemberOfRelationForBinary() throws RepositoryException {
        Mockito.when((Object)this.mockContainer.hasType("ldp:DirectContainer")).thenReturn((Object)true);
        Mockito.when((Object)this.mockContainer.hasProperty("ldp:isMemberOfRelation")).thenReturn((Object)true);
        Mockito.when((Object)this.mockContainer.getProperty("ldp:isMemberOfRelation")).thenReturn((Object)this.mockRelationProperty);
        Mockito.when((Object)this.mockContainer.hasProperty("ldp:membershipResource")).thenReturn((Object)true);
        Mockito.when((Object)this.mockContainer.getProperty("ldp:membershipResource")).thenReturn((Object)this.mockMembershipProperty);
        Mockito.when((Object)this.mockMembershipProperty.getType()).thenReturn((Object)9);
        Mockito.when((Object)this.mockMembershipProperty.getNode()).thenReturn((Object)this.mockNode);
        String property = "some:uri";
        Mockito.when((Object)this.mockRelationProperty.getString()).thenReturn((Object)"some:uri");
        this.testObj = new LdpIsMemberOfRdfContext((FedoraResource)this.mockBinary, (IdentifierConverter)this.subjects);
        Model model = this.testObj.asModel();
        Converter nodeSubjects = this.subjects.reverse();
        Assert.assertTrue((String)"Expected stream to contain triple", (boolean)model.contains((Resource)nodeSubjects.convert((Object)this.mockBinary), ResourceFactory.createProperty((String)"some:uri"), (RDFNode)NodeResourceConverter.nodeToResource((Converter)this.subjects).convert((Object)this.mockNode)));
    }

    @Test
    public void testIsMemberOfRelationWithIndirectContainer() throws RepositoryException {
        Mockito.when((Object)this.mockContainer.hasType("ldp:IndirectContainer")).thenReturn((Object)true);
        Mockito.when((Object)this.mockContainer.hasProperty("ldp:isMemberOfRelation")).thenReturn((Object)true);
        Mockito.when((Object)this.mockContainer.getProperty("ldp:isMemberOfRelation")).thenReturn((Object)this.mockRelationProperty);
        Mockito.when((Object)this.mockContainer.hasProperty("ldp:membershipResource")).thenReturn((Object)true);
        Mockito.when((Object)this.mockContainer.getProperty("ldp:membershipResource")).thenReturn((Object)this.mockMembershipProperty);
        Mockito.when((Object)this.mockContainer.hasProperty("ldp:insertedContentRelation")).thenReturn((Object)true);
        Mockito.when((Object)this.mockContainer.getProperty("ldp:insertedContentRelation")).thenReturn((Object)this.mockInsertedContentRelationProperty);
        Mockito.when((Object)this.mockInsertedContentRelationProperty.getString()).thenReturn((Object)"some:relation");
        Mockito.when((Object)this.mockNamespaceRegistry.isRegisteredUri("some:")).thenReturn((Object)true);
        Mockito.when((Object)this.mockNamespaceRegistry.getPrefix("some:")).thenReturn((Object)"some");
        Mockito.when((Object)this.mockResource.hasProperty("some:relation")).thenReturn((Object)true);
        Mockito.when((Object)this.mockResource.getProperty("some:relation")).thenReturn((Object)this.mockRelationProperty);
        Mockito.when((Object)this.mockRelationProperty.isMultiple()).thenReturn((Object)false);
        Mockito.when((Object)this.mockRelationProperty.getValue()).thenReturn((Object)this.mockRelationValue);
        Mockito.when((Object)this.mockRelationValue.getType()).thenReturn((Object)11);
        Mockito.when((Object)this.mockRelationValue.getString()).thenReturn((Object)this.subjects.toDomain("/a/#/hash-uri").getURI());
        Mockito.when((Object)this.mockMembershipProperty.getType()).thenReturn((Object)9);
        Mockito.when((Object)this.mockMembershipProperty.getNode()).thenReturn((Object)this.mockNode);
        String property = "some:uri";
        Mockito.when((Object)this.mockRelationProperty.getString()).thenReturn((Object)"some:uri");
        this.testObj = new LdpIsMemberOfRdfContext(this.mockResource, (IdentifierConverter)this.subjects);
        Model model = this.testObj.asModel();
        Assert.assertTrue((String)"Expected stream to contain triple", (boolean)model.contains(this.subjects.toDomain("/a/#/hash-uri"), ResourceFactory.createProperty((String)"some:uri"), (RDFNode)NodeResourceConverter.nodeToResource((Converter)this.subjects).convert((Object)this.mockNode)));
    }

    @Test
    public void testIsMemberOfRelationWithIndirectContainerAndRelationOutsideDomain() throws RepositoryException {
        Mockito.when((Object)this.mockContainer.hasType("ldp:IndirectContainer")).thenReturn((Object)true);
        Mockito.when((Object)this.mockContainer.hasProperty("ldp:isMemberOfRelation")).thenReturn((Object)true);
        Mockito.when((Object)this.mockContainer.getProperty("ldp:isMemberOfRelation")).thenReturn((Object)this.mockRelationProperty);
        Mockito.when((Object)this.mockContainer.hasProperty("ldp:membershipResource")).thenReturn((Object)true);
        Mockito.when((Object)this.mockContainer.getProperty("ldp:membershipResource")).thenReturn((Object)this.mockMembershipProperty);
        Mockito.when((Object)this.mockContainer.hasProperty("ldp:insertedContentRelation")).thenReturn((Object)true);
        Mockito.when((Object)this.mockContainer.getProperty("ldp:insertedContentRelation")).thenReturn((Object)this.mockInsertedContentRelationProperty);
        Mockito.when((Object)this.mockInsertedContentRelationProperty.getString()).thenReturn((Object)"some:relation");
        Mockito.when((Object)this.mockNamespaceRegistry.isRegisteredUri("some:")).thenReturn((Object)true);
        Mockito.when((Object)this.mockNamespaceRegistry.getPrefix("some:")).thenReturn((Object)"some");
        Mockito.when((Object)this.mockResource.hasProperty("some:relation")).thenReturn((Object)true);
        Mockito.when((Object)this.mockResource.getProperty("some:relation")).thenReturn((Object)this.mockRelationProperty);
        Mockito.when((Object)this.mockRelationProperty.isMultiple()).thenReturn((Object)false);
        Mockito.when((Object)this.mockRelationProperty.getValue()).thenReturn((Object)this.mockRelationValue);
        Mockito.when((Object)this.mockRelationValue.getString()).thenReturn((Object)"x");
        Mockito.when((Object)this.mockMembershipProperty.getType()).thenReturn((Object)9);
        Mockito.when((Object)this.mockMembershipProperty.getNode()).thenReturn((Object)this.mockNode);
        String property = "some:uri";
        Mockito.when((Object)this.mockRelationProperty.getString()).thenReturn((Object)"some:uri");
        this.testObj = new LdpIsMemberOfRdfContext(this.mockResource, (IdentifierConverter)this.subjects);
        Model model = this.testObj.asModel();
        Assert.assertTrue((String)"Expected stream to be empty", (boolean)model.isEmpty());
    }
}

