/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.rdf.impl;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.vocabulary.RDF;
import javax.jcr.Session;
import org.fcrepo.kernel.RdfLexicon;
import org.fcrepo.kernel.identifiers.IdentifierConverter;
import org.fcrepo.kernel.impl.rdf.impl.DefaultIdentifierTranslator;
import org.fcrepo.kernel.impl.rdf.impl.LdpRdfContext;
import org.fcrepo.kernel.models.Container;
import org.fcrepo.kernel.models.FedoraResource;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class LdpRdfContextTest {
    @Mock
    private FedoraResource mockResource;
    @Mock
    private Container mockContainer;
    @Mock
    private Session mockSession;
    private DefaultIdentifierTranslator subjects;
    private LdpRdfContext testObj;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.mockResource.getPath()).thenReturn((Object)"/a");
        Mockito.when((Object)this.mockContainer.getPath()).thenReturn((Object)"/a");
        this.subjects = new DefaultIdentifierTranslator(this.mockSession);
    }

    @Test
    public void shouldIncludeRdfTypeAssertions() {
        this.testObj = new LdpRdfContext(this.mockResource, (IdentifierConverter)this.subjects);
        Model model = this.testObj.asModel();
        Assert.assertTrue((boolean)model.contains(this.subject(), RDF.type, (RDFNode)RdfLexicon.RDF_SOURCE));
    }

    @Test
    public void shouldIncludeRdfContainerAssertions() {
        this.testObj = new LdpRdfContext((FedoraResource)this.mockContainer, (IdentifierConverter)this.subjects);
        Model model = this.testObj.asModel();
        Assert.assertTrue((boolean)model.contains(this.subject(), RDF.type, (RDFNode)RdfLexicon.RDF_SOURCE));
        Assert.assertTrue((boolean)model.contains(this.subject(), RDF.type, (RDFNode)RdfLexicon.CONTAINER));
    }

    @Test
    public void shouldIncludeRdfDefaultContainerAssertion() {
        this.testObj = new LdpRdfContext((FedoraResource)this.mockContainer, (IdentifierConverter)this.subjects);
        Model model = this.testObj.asModel();
        Assert.assertTrue((boolean)model.contains(this.subject(), RDF.type, (RDFNode)RdfLexicon.BASIC_CONTAINER));
    }

    @Test
    public void shouldNotIncludeRdfDefaultContainerAssertionIfContainerSet() {
        Mockito.when((Object)this.mockContainer.hasType("fedora:Container")).thenReturn((Object)true);
        this.testObj = new LdpRdfContext((FedoraResource)this.mockContainer, (IdentifierConverter)this.subjects);
        Model model = this.testObj.asModel();
        Assert.assertFalse((boolean)model.contains(this.subject(), RDF.type, (RDFNode)RdfLexicon.BASIC_CONTAINER));
    }

    private Resource subject() {
        return (Resource)this.subjects.reverse().convert((Object)this.mockResource);
    }
}

