/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.value.binary.infinispan;

import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ClusteringConfiguration;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.TransactionConfiguration;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.transaction.TransactionMode;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.modeshape.jcr.value.BinaryKey;
import org.modeshape.jcr.value.binary.infinispan.ChunkBinaryMetadata;
import org.modeshape.jcr.value.binary.infinispan.InfinispanBinaryStore;
import org.modeshape.jcr.value.binary.infinispan.InfinispanUtils;
import org.modeshape.jcr.value.binary.infinispan.Metadata;

public class InfinispanUtilsTest {
    @Test
    public void testDataKeyFrom() {
        DefaultCacheManager mgr = (DefaultCacheManager)Mockito.mock(DefaultCacheManager.class);
        InfinispanBinaryStore store = new InfinispanBinaryStore((CacheContainer)mgr, false, "foo", "bar");
        BinaryKey key = new BinaryKey("foo");
        Assert.assertEquals((Object)"foo-data", (Object)InfinispanUtils.dataKeyFrom((InfinispanBinaryStore)store, (BinaryKey)key));
    }

    @Test
    public void testGetMetadata() {
        DefaultCacheManager mgr = (DefaultCacheManager)Mockito.mock(DefaultCacheManager.class);
        InfinispanBinaryStore store = new InfinispanBinaryStore((CacheContainer)mgr, false, "foo", "bar");
        BinaryKey key = new BinaryKey("foo");
        Cache cache = (Cache)Mockito.mock(Cache.class);
        Metadata meta = new Metadata(0L, 1024L, 8, 128);
        Mockito.when((Object)mgr.getCache(Matchers.anyString())).thenReturn((Object)cache);
        ((Cache)Mockito.doReturn((Object)meta).when((Object)cache)).get(Matchers.anyObject());
        Configuration cacheConfig = (Configuration)Mockito.mock(Configuration.class);
        Mockito.when((Object)cache.getCacheConfiguration()).thenReturn((Object)cacheConfig);
        TransactionConfiguration txConfig = (TransactionConfiguration)Mockito.mock(TransactionConfiguration.class);
        Mockito.when((Object)cacheConfig.transaction()).thenReturn((Object)txConfig);
        Mockito.when((Object)txConfig.transactionMode()).thenReturn((Object)TransactionMode.NON_TRANSACTIONAL);
        ClusteringConfiguration clConfig = (ClusteringConfiguration)Mockito.mock(ClusteringConfiguration.class);
        Mockito.when((Object)cacheConfig.clustering()).thenReturn((Object)clConfig);
        Mockito.when((Object)clConfig.cacheMode()).thenReturn((Object)CacheMode.LOCAL);
        store.start();
        ChunkBinaryMetadata chunk = InfinispanUtils.getMetadata((InfinispanBinaryStore)store, (BinaryKey)key);
        Assert.assertEquals((long)1024L, (long)chunk.getLength());
        Assert.assertEquals((long)128L, (long)chunk.getChunkSize());
    }
}

